/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.rt.midp.Log;
import com.nokia.mj.impl.rt.midp.MemoryLogger;
import com.nokia.mj.impl.rt.midp.MidletLifeCycle;
import com.nokia.mj.impl.rt.midp.StartupException;
import com.nokia.mj.impl.rt.support.JvmInternal;
import com.nokia.mj.impl.utils.DebugUtils;
import com.nokia.mj.impl.utils.StartUpTrace;

public final class Main {
    public static void main(String[] args) {
        StartUpTrace.doTrace("Midp runtime ready");
        System.out.println("java.version: " + System.getProperty("java.version"));
        System.out.println("java.fullversion: " + System.getProperty("java.fullversion"));
        boolean ok = true;
        try {
            MidletLifeCycle.getInstance().doRun(args);
            StartUpTrace.doTrace("Midp runtime closing");
        }
        catch (StartupException se) {
            if (se.isError()) {
                Log.logE("Startup failure: " + se);
                ok = false;
            }
        }
        catch (Throwable th) {
            Log.logE("Error in MIDP runtime: ", th);
            ok = false;
        }
        try {
            DebugUtils.closeThreadDumper();
            MidletLifeCycle.destroyInstance();
            MemoryLogger.close();
            System.gc();
            JvmInternal.runFinalization();
        }
        catch (Throwable thr) {
            Log.logE("Error in MIDP runtime (final clean): ", thr);
            ok = false;
        }
    }
}

