/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.rt.midp.ApplicationInfoImpl;
import com.nokia.mj.impl.rt.midp.Log;

public class MemoryLogger
extends Thread {
    private static MemoryLogger sInstance;
    private boolean mForcedStop = false;

    private MemoryLogger() {
    }

    static void startMonitoring() {
        if (sInstance == null) {
            sInstance = new MemoryLogger();
            sInstance.start();
        }
    }

    static void close() {
        if (sInstance != null) {
            MemoryLogger.sInstance.mForcedStop = true;
            sInstance.interrupt();
        }
    }

    public void run() {
        try {
            MemoryLogger.sleep(60000L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.mForcedStop) {
            sInstance = null;
            return;
        }
        try {
            Runtime rt = Runtime.getRuntime();
            long freeMem = rt.freeMemory();
            long totMem = rt.totalMemory();
            int heapSize = (int)((totMem - freeMem) / 1024L);
            this._writeFile(ApplicationInfoImpl.getMidletInfo().getRootPath() + "heap", heapSize);
        }
        catch (Throwable th) {
            Log.logE("Error in MemoryLogger: ", th);
        }
        sInstance = null;
    }

    private native void _writeFile(String var1, int var2);
}

