/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.support;

import com.nokia.mj.impl.rt.support.ShutdownListener;
import com.nokia.mj.impl.utils.Uid;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ApplicationUtils {
    private static final String PORTCLASS = ".ApplicationUtilsImpl";
    protected static ApplicationUtils sInstance = null;
    private Vector mListeners;
    private Object mApplicationStartLock = new Object();
    private Boolean mStartCmd;

    public static ApplicationUtils getInstance() {
        return sInstance;
    }

    public abstract void notifyExitCmd();

    public abstract void checkPermission(Permission var1) throws AccessControlException, NullPointerException;

    public abstract void checkPermission(Uid var1, Permission var2) throws AccessControlException, NullPointerException;

    public void addShutdownListener(ShutdownListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new Vector();
        }
        this.mListeners.addElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitStart() {
        Object object = this.mApplicationStartLock;
        synchronized (object) {
            if (this.mStartCmd == null) {
                try {
                    this.mApplicationStartLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.mStartCmd == null ? false : this.mStartCmd;
        }
    }

    public void pauseApplication() {
    }

    public void resumeApplication() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseStartWaiter(boolean doStart) {
        if (this.mApplicationStartLock != null) {
            Object object = this.mApplicationStartLock;
            synchronized (object) {
                this.mStartCmd = new Boolean(doStart);
                this.mApplicationStartLock.notifyAll();
            }
        }
    }

    protected void doShutdown() {
        if (this.mListeners != null) {
            Enumeration enumer = this.mListeners.elements();
            while (enumer.hasMoreElements()) {
                ShutdownListener listener = (ShutdownListener)enumer.nextElement();
                listener.shuttingDown();
            }
        }
    }

    static {
        String packageEnd = System.getProperty("com.nokia.rt.port");
        if (packageEnd == null) {
            throw new RuntimeException("Not able to load .ApplicationUtilsImplclass since com.nokia.rt.port system property is undefined");
        }
        String className = "com.nokia.mj.impl.rt." + packageEnd + PORTCLASS;
        try {
            Class clazz = Class.forName(className);
            sInstance = (ApplicationUtils)clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Not able to instantiate class " + className + ". Reason is: " + e);
        }
    }
}

