/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.satsa;

import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.satsa.APDUError;
import com.nokia.mj.impl.satsa.APDUPermission;
import com.nokia.mj.impl.security.common.Certificate;
import com.nokia.mj.impl.security.midp.authentication.AuthenticationModule;
import com.nokia.mj.impl.security.midp.common.ProtectionDomain;
import com.nokia.mj.impl.security.midp.common.SigningInfo;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.apdu.APDUConnection;
import javax.microedition.io.ConnectionNotFoundException;

public final class APDUConnectionImpl
implements APDUConnection {
    protected static final int ENUMERATION_CHANGE_PIN = 0;
    protected static final int ENUMERATION_DISABLE_PIN = 1;
    protected static final int ENUMERATION_ENABLE_PIN = 2;
    protected static final int ENUMERATION_ENTER_PIN = 3;
    protected static final int ENUMERATION_SAT = 0;
    protected static final int ENUMERATION_AID = 1;
    private final int iHandle;
    private byte[] iResponseBytes;
    private int iErrorCode;
    protected final Object iLock;
    protected final Object iCloseLock;

    public APDUConnectionImpl(String aURI, int aMode, boolean aTimeouts) throws ConnectionNotFoundException, SecurityException, IOException, IllegalArgumentException {
        APDUPermission permission;
        ApplicationUtils appUtils;
        Logger.LOG(23, 4, "+ APDUConnectionImpl::APDUConnectionImpl()");
        this.iLock = new Object();
        this.iCloseLock = new Object();
        Logger.LOG(23, 4, "+ APDUConnectionImpl: Create Apps Info object");
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        Logger.LOG(23, 4, "+ APDUConnectionImpl: get suite name");
        String name = appInfo.getSuiteName();
        Logger.LOG(23, 4, "+ APDUConnectionImpl: get vendor name");
        String vendor = appInfo.getVendor();
        Logger.LOG(23, 4, "+ APDUConnectionImpl: get version");
        String version = appInfo.getVersion();
        Logger.LOG(23, 4, "+ APDUConnectionImpl: get domain info");
        String domain = appInfo.getProtectionDomain();
        Logger.LOG(23, 4, "+ APDUConnectionImpl: Create Auth module instance");
        AuthenticationModule authModule = AuthenticationModule.getInstance();
        Logger.LOG(23, 4, "+ APDUConnectionImpl: get signing info");
        SigningInfo signingInfo = authModule.getSigningInfo(name, version, vendor);
        Logger.LOG(23, 4, "+ APDUConnectionImpl: get protection domain");
        ProtectionDomain protDomain = signingInfo.getProtectionDomain();
        String signingCertHash = "";
        String rootCertHash = "";
        if (domain.equals("MFD") || domain.equals("OPD") || domain.equals("ITPD")) {
            Logger.LOG(23, 4, "+ APDUConnectionImpl: get signing cert");
            Certificate signingCertificate = signingInfo.getSigningCertificate();
            Logger.LOG(23, 4, "+ APDUConnectionImpl: get signing cert hash");
            signingCertHash = signingCertificate.getFingerprint();
            Logger.LOG(23, 4, "+ APDUConnectionImpl: get root cert");
            Certificate rootCertificate = signingInfo.getRootCertificate();
            Logger.LOG(23, 4, "+APDUConnectionImpl:get certhash for domain" + domain);
            rootCertHash = rootCertificate.getFingerprint();
        }
        int[] connTypeArray = new int[1];
        Logger.LOG(23, 4, "+ APDUConnectionImpl: Create the connection object");
        this.iHandle = this._create(aURI, name, vendor, version, domain, rootCertHash, signingCertHash, connTypeArray);
        Logger.LOG(23, 4, "+ APDUConnectionImpl: Connection object created");
        if (this.iHandle <= 0) {
            Logger.LOG(23, 4, "+ APDUConnectionImpl:: Failed to create a handle");
            try {
                APDUError.check(this.iHandle, true, true, true, false, true);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Creating APDU connection failed: " + iae.getMessage());
            }
            catch (SecurityException se) {
                throw new SecurityException("Creating APDU connection failed: " + se.getMessage());
            }
            catch (ConnectionNotFoundException cne) {
                throw new ConnectionNotFoundException("Creating APDU connection failed: " + cne.getMessage());
            }
            catch (IOException ie) {
                throw new IOException("Creating APDU connection failed: " + ie.getMessage());
            }
        }
        int connType = connTypeArray[0];
        Logger.LOG(23, 4, "+ APDUConnectionImpl: Check Permission");
        if (connType == 0) {
            Logger.LOG(23, 4, "+ APDUConnectionImpl::Check againast SAT permission");
            appUtils = ApplicationUtils.getInstance();
            permission = new APDUPermission("apdu://*", "sat");
            appUtils.checkPermission(permission);
            Logger.LOG(23, 4, "+ APDUConnectionImpl: SAT is allowed");
        } else {
            Logger.LOG(23, 4, "+ APDUConnectionImpl: Check against AID permission");
            appUtils = ApplicationUtils.getInstance();
            permission = new APDUPermission("apdu://*", "aid");
            appUtils.checkPermission(permission);
            Logger.LOG(23, 4, "+ APDUConnectionImpl: AID is allowed");
        }
        Logger.LOG(23, 4, "+ APDUConnectionImpl: Open the connection");
        int err = APDUConnectionImpl._open(this.iHandle);
        if (err < 0) {
            Logger.LOG(23, 4, "+ APDUConnectionImpl: Failed to open connection");
            if (err == -4) {
                throw new OutOfMemoryError();
            }
            try {
                APDUError.check(err, true, true, true, false, true);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Opening APDU Connection failed: " + iae.getMessage());
            }
            catch (SecurityException se) {
                throw new SecurityException("Opening APDU Connection failed: " + se.getMessage());
            }
            catch (ConnectionNotFoundException cne) {
                throw new ConnectionNotFoundException("Opening APDU Connection failed: " + cne.getMessage());
            }
            catch (IOException ie) {
                throw new IOException("Opening APDU Connection failed: " + ie.getMessage());
            }
        }
    }

    public synchronized byte[] changePin(int pinID) throws IOException {
        byte[] response;
        try {
            response = this.doPinMethod(0, pinID);
        }
        catch (SecurityException se) {
            throw new SecurityException("ChangePin failed: " + se.getMessage());
        }
        catch (InterruptedIOException iie) {
            throw new InterruptedIOException("ChangePin failed: " + iie.getMessage());
        }
        catch (IOException ie) {
            throw new IOException("ChangePin failed: " + ie.getMessage());
        }
        return response;
    }

    public synchronized byte[] disablePin(int pinID) throws IOException {
        byte[] response;
        try {
            response = this.doPinMethod(1, pinID);
        }
        catch (SecurityException se) {
            throw new SecurityException("DisablePin failed: " + se.getMessage());
        }
        catch (InterruptedIOException iie) {
            throw new InterruptedIOException("DisablePin failed: " + iie.getMessage());
        }
        catch (IOException ie) {
            throw new IOException("DisablePin failed: " + ie.getMessage());
        }
        return response;
    }

    public synchronized byte[] enablePin(int pinID) throws IOException {
        byte[] response;
        try {
            response = this.doPinMethod(2, pinID);
        }
        catch (SecurityException se) {
            throw new SecurityException("EnablePin failed: " + se.getMessage());
        }
        catch (InterruptedIOException iie) {
            throw new InterruptedIOException("EnablePin failed: " + iie.getMessage());
        }
        catch (IOException ie) {
            throw new IOException("EnablePin failed: " + ie.getMessage());
        }
        return response;
    }

    public synchronized byte[] enterPin(int pinID) throws IOException {
        byte[] response;
        try {
            response = this.doPinMethod(3, pinID);
        }
        catch (SecurityException se) {
            throw new SecurityException("EnterPin failed: " + se.getMessage());
        }
        catch (InterruptedIOException iie) {
            throw new InterruptedIOException("EnterPin failed: " + iie.getMessage());
        }
        catch (IOException ie) {
            throw new IOException("EnterPin failed: " + ie.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] exchangeAPDU(byte[] commandAPDU) throws IOException {
        Object object = this.iLock;
        synchronized (object) {
            byte[] response;
            if (commandAPDU == null) {
                throw new IllegalArgumentException("ExchangeAPDU failed: Parameter is null");
            }
            int err = APDUConnectionImpl._exchangeAPDU(this.iHandle, commandAPDU);
            try {
                response = this.finalizeMethod(err, true, false);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("ExchangeAPDU failed: " + iae.getMessage());
            }
            catch (SecurityException se) {
                throw new SecurityException("ExchangeAPDU failed: " + se.getMessage());
            }
            catch (InterruptedIOException iie) {
                throw new InterruptedIOException("ExchangeAPDU failed: " + iie.getMessage());
            }
            catch (IOException ie) {
                throw new IOException("ExchangeAPDU failed: " + ie.getMessage());
            }
            return response;
        }
    }

    public synchronized byte[] getATR() {
        int[] errArray = new int[1];
        byte[] nativeResponse = APDUConnectionImpl._getATR(this.iHandle, errArray);
        int err = errArray[0];
        if (err < 0) {
            if (err == -4) {
                throw new OutOfMemoryError();
            }
            nativeResponse = null;
        }
        return this.copyToJava(nativeResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] unblockPin(int blockedPinID, int unblockingPinID) throws IOException {
        Object object = this.iLock;
        synchronized (object) {
            byte[] response;
            int err = APDUConnectionImpl._unblockPin(this.iHandle, blockedPinID, unblockingPinID);
            try {
                response = this.finalizeMethod(err, false, true);
            }
            catch (SecurityException se) {
                throw new SecurityException("UnblockPin failed: " + se.getMessage());
            }
            catch (InterruptedIOException iie) {
                throw new InterruptedIOException("UnblockPin failed: " + iie.getMessage());
            }
            catch (IOException ie) {
                throw new IOException("UnblockPin failed: " + ie.getMessage());
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.iCloseLock;
        synchronized (object) {
            int err = APDUConnectionImpl._close(this.iHandle);
            if (err < 0) {
                if (err == -4) {
                    throw new OutOfMemoryError();
                }
                try {
                    APDUError.check(err, false, false, false, false, true);
                }
                catch (IOException iex) {
                    throw new IOException("Closing connection failed: " + iex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationComplete(int aOperationID, int aErrorCode, byte[] aResponseBytes) {
        this.iErrorCode = aErrorCode;
        this.iResponseBytes = this.copyToJava(aResponseBytes);
        Object object = this.iLock;
        synchronized (object) {
            this.iLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doPinMethod(int pinMethodType, int pinID) throws IOException {
        Object object = this.iLock;
        synchronized (object) {
            int err = APDUConnectionImpl._doPinMethod(this.iHandle, pinMethodType, pinID);
            return this.finalizeMethod(err, false, true);
        }
    }

    private byte[] finalizeMethod(int aErr, boolean aCheckIllegalArg, boolean aCheckCancelErr) throws IOException {
        APDUError.check(aErr, aCheckIllegalArg, true, false, true, true);
        try {
            this.iLock.wait();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        if (this.iErrorCode < 0) {
            if (this.iErrorCode == -4) {
                throw new OutOfMemoryError();
            }
            if (aCheckCancelErr && this.iErrorCode == -3600) {
                return null;
            }
            APDUError.check(this.iErrorCode, false, false, false, false, true);
        }
        return this.iResponseBytes;
    }

    private byte[] copyToJava(byte[] aSource) {
        byte[] destination = null;
        if (aSource != null && (destination = new byte[aSource.length]) != null) {
            System.arraycopy((Object)aSource, 0, (Object)destination, 0, destination.length);
        }
        return destination;
    }

    private native int _create(String var1, String var2, String var3, String var4, String var5, String var6, String var7, int[] var8);

    private static native int _open(int var0);

    private static native int _doPinMethod(int var0, int var1, int var2);

    private static native int _exchangeAPDU(int var0, byte[] var1);

    private static native byte[] _getATR(int var0, int[] var1);

    private static native int _unblockPin(int var0, int var1, int var2);

    private static native int _close(int var0);

    static {
        try {
            Jvm.loadSystemLibrary("javasatsa");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

