/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.common;

import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import com.nokia.mj.impl.utils.Tokenizer;
import java.security.Permission;

public abstract class PermissionBase
extends Permission {
    public static final int BLANKET_ANSWER_OPTION = 1;
    public static final int SESSION_ANSWER_OPTION = 2;
    public static final int ONESHOT_ANSWER_OPTION = 3;
    public static final int ONESHOT_INTERACTION_MODE = 1;
    public static final int SESSION_INTERACTION_MODE = 2;
    public static final int BLANKET_INTERACTION_MODE = 3;

    public PermissionBase(String name) {
        super(name);
    }

    public abstract String getSecurityPromptQuestion();

    public abstract String toString();

    public String getSecurityPromptAnswerOption(int aAnswerOption) {
        SecurityPromptMessage securityPromptMessage = SecurityPromptMessage.getInstance();
        switch (aAnswerOption) {
            case 3: {
                return securityPromptMessage.getText("prompt_allow", null);
            }
            case 2: {
                return securityPromptMessage.getText("prompt_allow", null);
            }
            case 1: {
                return securityPromptMessage.getText("prompt_allow", null);
            }
        }
        return null;
    }

    public boolean isSecurityPromptNeeed(int aInteractionMode) {
        return true;
    }

    public static boolean matchActions(String aAction1, String aAction2) {
        if (aAction1 == null && aAction2 == null) {
            return true;
        }
        if (aAction1 == null || aAction2 == null) {
            return false;
        }
        String[] actions1 = Tokenizer.split(aAction1, ",");
        String[] actions2 = Tokenizer.split(aAction2, ",");
        for (int i = 0; i < actions2.length; ++i) {
            boolean found = false;
            for (int j = 0; j < actions1.length; ++j) {
                if (!actions2[i].equalsIgnoreCase(actions1[j])) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

