/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.authentication;

import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.rt.ui.ConfirmData;
import com.nokia.mj.impl.rt.ui.RuntimeUi;
import com.nokia.mj.impl.rt.ui.RuntimeUiFactory;
import com.nokia.mj.impl.security.common.InstallerSecurityException;
import com.nokia.mj.impl.security.midp.authentication.OcspData;
import com.nokia.mj.impl.security.midp.authentication.OcspEventListener;
import com.nokia.mj.impl.security.midp.authentication.OcspSettings;
import com.nokia.mj.impl.security.midp.authentication.OcspUserPreferences;
import com.nokia.mj.impl.security.utils.Logger;
import com.nokia.mj.impl.security.utils.SecurityDetailedErrorMessage;
import com.nokia.mj.impl.security.utils.SecurityErrorMessage;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import com.nokia.mj.impl.utils.ErrorMessageBase;

public final class OcspChecker
implements Runnable {
    private OcspData[] ocspData = null;
    long iap = 0L;
    long snap = 0L;
    private static OcspSettings iOcspSettings;
    private static OcspUserPreferences iOcspUserPreferences;
    private boolean running = false;
    private Thread thread = null;
    private int iNativeThreadHandle;
    private int iNativePeerHandle;
    private OcspEventListener iEventListener;
    private boolean iOcspCancelled = false;

    public OcspChecker(OcspData[] ocspData, OcspSettings ocspSettings, OcspUserPreferences ocspUserPreferences, OcspEventListener eventListener) {
        this.ocspData = ocspData;
        try {
            this.iap = Long.parseLong(ocspSettings.iap);
        }
        catch (NumberFormatException e) {
            Logger.logWarning("Invalid ocsp settings: iap is not a valid. Default value (0) will be used instead.");
        }
        try {
            this.snap = Long.parseLong(ocspSettings.snap);
        }
        catch (NumberFormatException e) {
            Logger.logWarning("Invalid ocsp settings: snap is not a valid. Default value (0) will be used instead.");
        }
        this.iNativeThreadHandle = this._createNativeThread();
        this.iNativePeerHandle = this._createNativePeer(this.iNativeThreadHandle, this.iap, this.snap, ocspUserPreferences.getOcspUrl());
        this.thread = new Thread(this, "OcspChecker");
        Jvm.setThreadAsDaemon(this.thread, true);
        this.iEventListener = eventListener;
        iOcspSettings = ocspSettings;
        iOcspUserPreferences = ocspUserPreferences;
        this.iOcspCancelled = false;
    }

    public void start() {
        if (this.iEventListener != null) {
            this.iEventListener.ocspEvent(1, null);
        }
        this.running = true;
        this.thread.start();
        Logger.log("Ocsp checks started");
    }

    public void run() {
        this._ocspChecks(this.iNativeThreadHandle, this.iNativePeerHandle, this.ocspData);
        this.finish(false);
    }

    public void cancel() {
        Logger.log("Ocsp checks cancelled");
        this.iOcspCancelled = true;
        this._cancelOcspChecks(this.iNativeThreadHandle, this.iNativePeerHandle);
        this.finish(true);
    }

    public void destroy() {
        this._destroyNativePeer(this.iNativeThreadHandle, this.iNativePeerHandle);
        this._destroyNativeThread(this.iNativeThreadHandle);
        this.iOcspCancelled = false;
    }

    private synchronized void finish(boolean ignoreResponse) {
        if (!this.running) {
            return;
        }
        this.running = false;
        Throwable response = null;
        if (!ignoreResponse) {
            response = this.handleResponse();
        }
        if (this.iEventListener != null) {
            this.iEventListener.ocspEvent(2, response);
        }
        Logger.log("Ocsp checks finished");
    }

    private Throwable handleResponse() {
        InstallerSecurityException response = null;
        int selectedOcspResponse = 4;
        int[] selectedOcspResponses = null;
        for (int i = 0; this.ocspData != null && i < this.ocspData.length; ++i) {
            int currentOcspResponse = this.ocspData[i].getSummary();
            if (!this.betterOcspResponse(currentOcspResponse, selectedOcspResponse)) continue;
            selectedOcspResponse = currentOcspResponse;
            selectedOcspResponses = this.ocspData[i].getIndividualResponses();
        }
        Logger.logOcspResponse(selectedOcspResponse, selectedOcspResponses);
        switch (selectedOcspResponse) {
            case 1: {
                break;
            }
            case 4: {
                if (this.handleOcspWarning(selectedOcspResponses)) break;
                response = new InstallerSecurityException((ErrorMessageBase)new SecurityErrorMessage(), 5, null, (ErrorMessageBase)new SecurityDetailedErrorMessage(), this.getOcspDetailedError(selectedOcspResponses), null, 909);
                break;
            }
            case 3: {
                if (this.isOcspWarning(selectedOcspResponses) && this.handleOcspWarning(selectedOcspResponses)) break;
                response = new InstallerSecurityException((ErrorMessageBase)new SecurityErrorMessage(), 5, null, (ErrorMessageBase)new SecurityDetailedErrorMessage(), this.getOcspDetailedError(selectedOcspResponses), null, 909);
                break;
            }
            case 2: {
                response = new InstallerSecurityException((ErrorMessageBase)new SecurityErrorMessage(), 5, null, (ErrorMessageBase)new SecurityDetailedErrorMessage(), 9, null, 909);
            }
        }
        return response;
    }

    private boolean betterOcspResponse(int ocspResponse1, int ocspResponse2) {
        switch (ocspResponse2) {
            case 1: {
                return false;
            }
            case 3: {
                return ocspResponse1 == 1;
            }
            case 2: {
                return ocspResponse1 == 1 || ocspResponse1 == 3 || ocspResponse1 == 4;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean handleOcspWarning(int[] ocspResponses) {
        if (OcspChecker.iOcspSettings.silent || this.iOcspCancelled || this.ignoreOcspWarning(ocspResponses)) {
            return true;
        }
        if (OcspChecker.iOcspSettings.ocspWarning == 2 || iOcspUserPreferences.getOcspMode() == 1) {
            RuntimeUi ui = RuntimeUiFactory.getRuntimeUi(true);
            SecurityPromptMessage pm = SecurityPromptMessage.getInstance();
            String[] answerOptions = new String[]{pm.getText("prompt_yes", null), pm.getText("prompt_no", null)};
            ConfirmData cData = new ConfirmData(pm.getText("ocsp_warning", null), answerOptions, 0);
            ui.confirm(pm.getText("general_warning", null), cData);
            ui.destroy();
            return cData.getAnswer() == 0;
        }
        return false;
    }

    private boolean isOcspWarning(int[] ocspResponses) {
        for (int i = 0; i < ocspResponses.length; ++i) {
            if (ocspResponses[i] != 6 && ocspResponses[i] != 3 && ocspResponses[i] != 2) continue;
            return false;
        }
        return true;
    }

    private boolean ignoreOcspWarning(int[] ocspResponses) {
        if (ocspResponses != null) {
            for (int i = 0; i < ocspResponses.length; ++i) {
                if (ocspResponses[i] != 8) continue;
                return true;
            }
        }
        return false;
    }

    private int getOcspDetailedError(int[] ocspResponses) {
        if (ocspResponses != null) {
            for (int i = 0; i < ocspResponses.length; ++i) {
                switch (ocspResponses[i]) {
                    case 5: 
                    case 7: {
                        return 8;
                    }
                    case 2: {
                        return 9;
                    }
                }
            }
        }
        return 7;
    }

    private native int _createNativeThread();

    private native void _destroyNativeThread(int var1);

    private native int _createNativePeer(int var1, long var2, long var4, String var6);

    private native void _destroyNativePeer(int var1, int var2);

    private native void _ocspChecks(int var1, int var2, OcspData[] var3);

    private native void _cancelOcspChecks(int var1, int var2);

    static {
        Jvm.loadSystemLibrary("javasecurity");
    }
}

