/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.authorization;

import com.nokia.mj.impl.security.midp.authorization.ClassInstantiator;
import com.nokia.mj.impl.security.midp.authorization.PermissionResolver;
import com.nokia.mj.impl.security.midp.authorization.SecurityPromptHandler;
import com.nokia.mj.impl.security.midp.common.GeneralSecuritySettings;
import com.nokia.mj.impl.security.midp.common.MIDPPermission;
import com.nokia.mj.impl.security.midp.common.PermissionMappingTable;
import com.nokia.mj.impl.security.midp.common.PolicyBasedPermissionImpl;
import com.nokia.mj.impl.security.midp.common.UserPermission;
import com.nokia.mj.impl.security.midp.common.UserSecuritySettings;
import com.nokia.mj.impl.security.midp.storage.SecurityStorage;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Uid;
import com.nokia.mj.impl.utils.exception.UserCancelException;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Vector;

public final class AccessControllerImpl {
    private Uid iAppUID;
    private SecurityPromptHandler iSecurityPromptHandler;
    private StorageSession iStorageSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermission(Permission p) {
        SecurityStorage storage = new SecurityStorage(this.iStorageSession);
        try {
            Vector resolvedPermissions = this.queryPermission(p, storage);
            boolean unresolvedUserPermission = false;
            for (int i = 0; i < resolvedPermissions.size(); ++i) {
                PolicyBasedPermissionImpl resolvedPermission = (PolicyBasedPermissionImpl)resolvedPermissions.elementAt(i);
                if (resolvedPermission.getUserSecuritySettings() != null) {
                    if (resolvedPermission.getPromptDetails() != null) {
                        this.handleUserPermission(p, resolvedPermission, storage);
                        return;
                    }
                    unresolvedUserPermission = true;
                    continue;
                }
                unresolvedUserPermission = false;
            }
            if (unresolvedUserPermission) {
                this.fail(p);
            }
        }
        finally {
            storage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkPermission(String permissionName) {
        Permission permission = this.getPermissionInstance(permissionName);
        if (permission == null) {
            return 0;
        }
        SecurityStorage storage = new SecurityStorage(this.iStorageSession);
        try {
            Vector resolvedPermissions = PermissionResolver.resolvePermission(storage.getStorageSession(), this.iAppUID, permission);
            if (resolvedPermissions == null) {
                int n = 0;
                return n;
            }
            for (int i = 0; i < resolvedPermissions.size(); ++i) {
                PolicyBasedPermissionImpl resolvedPermission = (PolicyBasedPermissionImpl)resolvedPermissions.elementAt(i);
                if (resolvedPermission.getUserSecuritySettings() == null) continue;
                int n = -1;
                return n;
            }
        }
        finally {
            storage.close();
        }
        return 1;
    }

    public AccessControllerImpl(StorageSession aStorageSession, Uid aAppSuiteUid, String aAppName) {
        this.init(aStorageSession, aAppSuiteUid, aAppName);
    }

    public void destroy() {
        this.iSecurityPromptHandler.destroy();
    }

    private void init(StorageSession aStorageSession, Uid appUID, String appName) {
        this.iAppUID = appUID;
        this.iStorageSession = aStorageSession;
        this.iSecurityPromptHandler = new SecurityPromptHandler(appName, GeneralSecuritySettings.getSecurityWarningsMode(this.iStorageSession, appUID));
    }

    private Vector queryPermission(Permission p, SecurityStorage storage) {
        Vector resolvedPermissions = PermissionResolver.resolvePermission(storage.getStorageSession(), this.iAppUID, p);
        if (resolvedPermissions == null) {
            this.fail(p);
        }
        return resolvedPermissions;
    }

    private void handleUserPermission(Permission checkedPermission, UserPermission resolvedPermission, SecurityStorage storage) {
        UserSecuritySettings newSettings;
        UserSecuritySettings settings = resolvedPermission.getUserSecuritySettings();
        if (settings.getCurrentInteractionMode() == 4) {
            this.fail(checkedPermission);
        }
        if (!resolvedPermission.getPromptDetails().isSecurityPromptNeeed(settings.getCurrentInteractionMode())) {
            return;
        }
        boolean OFF = false;
        boolean ON = true;
        boolean blanketPromptShown = storage.readUserSecuritySettingsPromptFlag(this.iAppUID, settings.getName());
        try {
            newSettings = this.iSecurityPromptHandler.handleUserPermission(resolvedPermission, blanketPromptShown);
        }
        catch (UserCancelException e) {
            throw new UserCancelException(e.getMessage(), new AccessControlException("Permission " + checkedPermission + " not allowed"));
        }
        if (newSettings.equals(settings)) {
            if (newSettings.getCurrentInteractionMode() == 3 && !blanketPromptShown) {
                storage.writeUserSecuritySettingsPromptFlag(this.iAppUID, settings.getName(), ON);
            }
            return;
        }
        if (newSettings.getCurrentInteractionMode() == 4) {
            this.fail(checkedPermission);
        }
        if (settings.getCurrentInteractionMode() == 3 && newSettings.getCurrentInteractionMode() != 3) {
            blanketPromptShown = OFF;
        } else if (newSettings.getCurrentInteractionMode() == 3) {
            blanketPromptShown = ON;
        }
        storage.writeUserSecuritySettings(this.iAppUID, newSettings.getName(), newSettings.getCurrentInteractionMode(), blanketPromptShown);
        PermissionResolver.settingsChanged(this.iAppUID, newSettings);
    }

    private Permission getPermissionInstance(String permissionName) {
        MIDPPermission internalPermission;
        if (permissionName != null && (internalPermission = PermissionMappingTable.get(permissionName)) != null) {
            try {
                return (Permission)ClassInstantiator.newInstance(internalPermission.getName(), internalPermission.getTarget(), internalPermission.getActionList());
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return null;
    }

    private void fail(Permission p) {
        throw new AccessControlException("Permission " + p + " not allowed");
    }

    private void applyMutualExclusiveRules(SecurityStorage storage, UserSecuritySettings settings) {
        boolean settings_in_list1 = settings.getName().equalsIgnoreCase("Application Auto Invocation");
        boolean settings_in_list2 = settings.getName().equalsIgnoreCase("Net Access");
        if (settings.getCurrentInteractionMode() != 3 || !settings_in_list1 && !settings_in_list2) {
            return;
        }
        String mutualExclusiveSettingsName = settings_in_list1 ? "Net Access" : "Application Auto Invocation";
        UserSecuritySettings[] allSettings = storage.readUserSecuritySettings(this.iAppUID);
        for (int i = 0; i < allSettings.length; ++i) {
            if (!allSettings[i].getName().equals(mutualExclusiveSettingsName) || allSettings[i].getCurrentInteractionMode() != 3) continue;
            int mutualExclusiveSettingsIntractionMode = allSettings[i].isInteractionModeAllowed(2) ? 2 : (allSettings[i].isInteractionModeAllowed(1) ? 1 : 4);
            storage.writeUserSecuritySettings(this.iAppUID, mutualExclusiveSettingsName, mutualExclusiveSettingsIntractionMode);
            PermissionResolver.settingsChanged(this.iAppUID, allSettings[i]);
        }
    }
}

