/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.authorization;

import com.nokia.mj.impl.rt.ui.ConfirmData;
import com.nokia.mj.impl.rt.ui.RuntimeUi;
import com.nokia.mj.impl.rt.ui.RuntimeUiFactory;
import com.nokia.mj.impl.security.midp.common.UserPermission;
import com.nokia.mj.impl.security.midp.common.UserSecuritySettings;
import com.nokia.mj.impl.security.midp.common.UserSecuritySettingsImpl;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import com.nokia.mj.impl.utils.exception.UserCancelException;
import java.util.Hashtable;
import java.util.Vector;

public class SecurityPromptHandler {
    private RuntimeUi ui;
    private SecurityPromptMessage securityPromptMessages = SecurityPromptMessage.getInstance();
    private String appName;
    private Hashtable sessionPromptsShown = new Hashtable();
    private Hashtable sessionsDenied = new Hashtable();
    private Vector promptTexts = new Vector();
    private int iSecurityPromptsMode = 2;

    public SecurityPromptHandler(String appName, int securityPromptsMode) {
        this.appName = appName;
        switch (securityPromptsMode) {
            case 1: 
            case 2: {
                this.iSecurityPromptsMode = securityPromptsMode;
            }
        }
    }

    public UserSecuritySettings handleUserPermission(UserPermission userPermission, boolean blanketPromptShown) {
        boolean sessionDenied;
        UserSecuritySettings settings = userPermission.getUserSecuritySettings();
        Boolean tmp = (Boolean)this.sessionsDenied.get(settings.getName());
        boolean bl = sessionDenied = tmp == null ? false : tmp;
        if (sessionDenied) {
            return this.getDenyAnswer(settings);
        }
        tmp = (Boolean)this.sessionPromptsShown.get(settings.getName());
        boolean sessionPromptShown = tmp == null ? false : tmp;
        int currentInteractionMode = settings.getCurrentInteractionMode();
        if (currentInteractionMode == 1 || currentInteractionMode == 2 && !sessionPromptShown || currentInteractionMode == 3 && !blanketPromptShown) {
            String currentInteractionModeText = null;
            String mostPowerfulInteractionModeText = null;
            int mostPowerfulInteractionMode = -1;
            switch (currentInteractionMode) {
                case 1: {
                    currentInteractionModeText = userPermission.getPromptDetails().getSecurityPromptAnswerOption(3);
                    if (settings.isInteractionModeAllowed(3)) {
                        mostPowerfulInteractionModeText = userPermission.getPromptDetails().getSecurityPromptAnswerOption(1);
                        mostPowerfulInteractionMode = 3;
                        break;
                    }
                    if (!settings.isInteractionModeAllowed(2)) break;
                    mostPowerfulInteractionModeText = userPermission.getPromptDetails().getSecurityPromptAnswerOption(2);
                    mostPowerfulInteractionMode = 2;
                    break;
                }
                case 2: {
                    currentInteractionModeText = userPermission.getPromptDetails().getSecurityPromptAnswerOption(2);
                    if (!settings.isInteractionModeAllowed(3)) break;
                    mostPowerfulInteractionModeText = userPermission.getPromptDetails().getSecurityPromptAnswerOption(1);
                    mostPowerfulInteractionMode = 3;
                    break;
                }
                case 3: {
                    currentInteractionModeText = userPermission.getPromptDetails().getSecurityPromptAnswerOption(1);
                }
            }
            switch (this.iSecurityPromptsMode) {
                case 2: {
                    currentInteractionModeText = null;
                    break;
                }
                case 1: {
                    mostPowerfulInteractionModeText = null;
                }
            }
            if (mostPowerfulInteractionModeText != null && mostPowerfulInteractionModeText.equalsIgnoreCase(currentInteractionModeText)) {
                currentInteractionModeText = null;
            }
            String[] answerOptions = new String[mostPowerfulInteractionModeText != null && currentInteractionModeText != null ? 3 : 2];
            int i = 0;
            if (mostPowerfulInteractionModeText != null) {
                answerOptions[i] = mostPowerfulInteractionModeText;
                ++i;
            }
            if (currentInteractionModeText != null) {
                answerOptions[i] = currentInteractionModeText;
                ++i;
            }
            answerOptions[i] = this.securityPromptMessages.getText("prompt_deny", null);
            ConfirmData cData = new ConfirmData(userPermission.getPromptDetails().getSecurityPromptQuestion(), answerOptions, 0);
            int answer = -1;
            if (this.iSecurityPromptsMode == 2 && this.promptTexts.contains(userPermission.getPromptDetails().getSecurityPromptQuestion())) {
                answer = 0;
            } else {
                RuntimeUi ui = this.getUiInstance();
                boolean responseAvailable = ui.confirm(this.appName, cData);
                if (!responseAvailable) {
                    throw new UserCancelException("User canceled the security prompt");
                }
                if (cData.getAnswer() == -1 || cData.getAnswer() < 0 || cData.getAnswer() >= answerOptions.length) {
                    return settings;
                }
                answer = cData.getAnswer();
            }
            UserSecuritySettings newSettings = null;
            switch (answer) {
                case 0: {
                    if (mostPowerfulInteractionModeText == null) {
                        newSettings = settings;
                        break;
                    }
                    newSettings = new UserSecuritySettingsImpl(settings.getName(), mostPowerfulInteractionMode, settings.getAllowedInteractionModes());
                    break;
                }
                case 1: {
                    if (answerOptions.length == 2) {
                        newSettings = this.handleDenyAnswer(settings);
                        break;
                    }
                    newSettings = settings;
                    break;
                }
                case 2: {
                    newSettings = this.handleDenyAnswer(settings);
                }
            }
            if (this.iSecurityPromptsMode == 2) {
                this.promptTexts.addElement(userPermission.getPromptDetails().getSecurityPromptQuestion());
            }
            if (newSettings.getCurrentInteractionMode() != 4 && (currentInteractionMode == 2 || newSettings.getCurrentInteractionMode() == 2)) {
                this.sessionPromptsShown.put(settings.getName(), new Boolean(true));
            }
            return newSettings;
        }
        return settings;
    }

    public void destroy() {
        if (this.ui != null) {
            this.ui.destroy();
        }
    }

    private RuntimeUi getUiInstance() {
        if (this.ui == null) {
            this.ui = RuntimeUiFactory.getRuntimeUi();
        }
        return this.ui;
    }

    private UserSecuritySettings handleDenyAnswer(UserSecuritySettings settings) {
        if (this.iSecurityPromptsMode == 2 && (settings.isInteractionModeAllowed(2) || settings.isInteractionModeAllowed(3)) || this.iSecurityPromptsMode == 1 && (settings.getCurrentInteractionMode() == 2 || settings.getCurrentInteractionMode() == 3)) {
            this.sessionsDenied.put(settings.getName(), new Boolean(true));
        }
        return this.getDenyAnswer(settings);
    }

    private UserSecuritySettings getDenyAnswer(UserSecuritySettings settings) {
        return new UserSecuritySettingsImpl(settings.getName(), 4, settings.getAllowedInteractionModes());
    }
}

