/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.common;

import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.security.midp.storage.SecurityStorage;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Uid;

public class GeneralSecuritySettings {
    public static final int UNINITIALIZED_SECURITY_MODE = -1;
    public static final int USER_SECURITY_MODE = 1;
    public static final int DEFAULT_SECURITY_MODE = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSecurityWarningsMode(StorageSession aStorageSession, Uid appUid, int securityWarningsMode) {
        SecurityStorage storage = new SecurityStorage(aStorageSession);
        try {
            storage.writeSecurityWarningsMode(appUid, securityWarningsMode);
        }
        finally {
            storage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSecurityWarningsMode(StorageSession aStorageSession, Uid appUid) {
        SecurityStorage storage = new SecurityStorage(aStorageSession);
        try {
            int n = storage.readSecurityWarningsMode(appUid);
            return n;
        }
        finally {
            storage.close();
        }
    }

    public static String getSecurityPolicy() {
        return GeneralSecuritySettings._getSecurityPolicy();
    }

    public static int getDefaultSecurityWarningsMode() {
        int tmp = GeneralSecuritySettings._getDefaultSecurityWarningsMode();
        if (tmp != 1 && tmp != 2) {
            tmp = -1;
        }
        return tmp;
    }

    private static native String _getSecurityPolicy();

    private static native int _getDefaultSecurityWarningsMode();

    static {
        Jvm.loadSystemLibrary("javasecurity");
    }
}

