/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.common;

import com.nokia.mj.impl.security.midp.common.AuthenticationAttribute;
import com.nokia.mj.impl.security.midp.common.AuthorizationRestrictionAttribute;
import com.nokia.mj.impl.security.midp.common.MandatoryPermissionAttribute;
import com.nokia.mj.impl.security.midp.common.NetworkRestrictionsAttribute;
import com.nokia.mj.impl.security.midp.common.OptionalPermissionAttribute;
import com.nokia.mj.impl.security.midp.common.PermissionAttribute;
import com.nokia.mj.impl.security.utils.Logger;
import com.nokia.mj.impl.utils.Attribute;
import com.nokia.mj.impl.utils.exception.InvalidAttributeException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SecurityAttributes {
    public static final String MIDP_VERSION_ATTRIBUTE_NAME = "MicroEdition-Profile";
    public static final String MIDP3_VERSION_ATTRIBUTE_VALUE = "MIDP-3.0";
    private DescriptorAttributes descriptorAttributes;
    private ManifestAttributes manifestAttributes;

    public void addDescriptorAttributes(Hashtable attrNamesAndValues) {
        this.descriptorAttributes = new DescriptorAttributes(attrNamesAndValues);
        boolean signedSuite = this.descriptorAttributes != null && this.descriptorAttributes.authenticationAttributes != null;
        this.manifestAttributes = new ManifestAttributes(attrNamesAndValues, signedSuite);
    }

    public void addManifestAttributes(Hashtable attrNamesAndValues) {
        Hashtable manifestOnlyAttributes;
        boolean signedSuite = this.descriptorAttributes != null && this.descriptorAttributes.authenticationAttributes != null;
        int optPermsStartIndex = 1;
        int mandatoryPermsStartIndex = 1;
        int authorizationRestrictionsStartIndex = 1;
        AuthorizationRestrictionAttribute[] authRestrictionAttributes = this.getAuthorizationRestrictionAttributes();
        NetworkRestrictionsAttribute networkRestrictionsAttribute = this.getNetworkRestrictionsAttribute();
        if (authRestrictionAttributes != null) {
            authorizationRestrictionsStartIndex = authRestrictionAttributes.length + 1;
        }
        if (signedSuite) {
            PermissionAttribute[] permissionAttributes = this.getPermissionAttributes();
            manifestOnlyAttributes = this.getManifestOnlyAttributes(permissionAttributes, networkRestrictionsAttribute, authRestrictionAttributes, attrNamesAndValues);
            if (permissionAttributes != null) {
                for (int i = 0; i < permissionAttributes.length; ++i) {
                    if (permissionAttributes[i].getImportance() == 1) {
                        ++mandatoryPermsStartIndex;
                        continue;
                    }
                    ++optPermsStartIndex;
                }
            }
        } else {
            manifestOnlyAttributes = this.getManifestOnlyAttributes(null, null, authRestrictionAttributes, attrNamesAndValues);
        }
        this.descriptorAttributes = new DescriptorAttributes(manifestOnlyAttributes, optPermsStartIndex, mandatoryPermsStartIndex, false, signedSuite);
        this.manifestAttributes = new ManifestAttributes(manifestOnlyAttributes, authorizationRestrictionsStartIndex, signedSuite);
    }

    public PermissionAttribute[] getPermissionAttributes() {
        return this.descriptorAttributes == null ? null : this.descriptorAttributes.permissionAttributes;
    }

    public AuthenticationAttribute[] getAuthenticationAttributes() {
        return this.descriptorAttributes == null ? null : this.descriptorAttributes.authenticationAttributes;
    }

    public AuthorizationRestrictionAttribute[] getAuthorizationRestrictionAttributes() {
        return this.manifestAttributes == null ? null : this.manifestAttributes.authorizationRestrictionAttributes;
    }

    public NetworkRestrictionsAttribute getNetworkRestrictionsAttribute() {
        return this.manifestAttributes == null ? null : this.manifestAttributes.networkRestrictionsAttribute;
    }

    public boolean isTrusted() {
        return this.descriptorAttributes != null && this.descriptorAttributes.authenticationAttributes != null && this.descriptorAttributes.authenticationAttributes.length > 0;
    }

    private Hashtable getManifestOnlyAttributes(PermissionAttribute[] jadPermissions, NetworkRestrictionsAttribute jadNetworkRestrictions, AuthorizationRestrictionAttribute[] jadAuthorizations, Hashtable jarAttributes) {
        Object o;
        boolean legacyApp = false;
        String midpVersion = this.getValue(jarAttributes, MIDP_VERSION_ATTRIBUTE_NAME);
        if (midpVersion == null || !midpVersion.equalsIgnoreCase(MIDP3_VERSION_ATTRIBUTE_VALUE)) {
            legacyApp = true;
        }
        if (jadPermissions != null) {
            Vector permAttrNames = new Vector();
            for (int i = 0; i < jadPermissions.length; ++i) {
                if (permAttrNames.contains(jadPermissions[i].getAttributeName())) continue;
                permAttrNames.addElement(jadPermissions[i].getAttributeName());
                Object o2 = jarAttributes.remove(jadPermissions[i].getAttributeName());
                if (o2 != null) continue;
                this.jadAttributeNotFound(legacyApp, jadPermissions[i].getAttributeName());
            }
        }
        if (jadNetworkRestrictions != null && (o = jarAttributes.remove("MIDlet-Operator-Allowed")) == null) {
            this.jadAttributeNotFound(false, "MIDlet-Operator-Allowed");
        }
        if (jadAuthorizations != null) {
            for (int i = 0; i < jadAuthorizations.length; ++i) {
                Object o3 = jarAttributes.remove(jadAuthorizations[i].getMainAttributeName());
                if (o3 == null) {
                    this.jadAttributeNotFound(false, jadAuthorizations[i].getMainAttributeName());
                }
                jarAttributes.remove(jadAuthorizations[i].getSecondAttributeName());
            }
        }
        return jarAttributes;
    }

    private String findFirstAppearance(Enumeration strings, String[] strList, boolean exactMatch) {
        while (strings.hasMoreElements()) {
            String str = (String)strings.nextElement();
            String lStr = str.toLowerCase();
            for (int i = 0; i < strList.length; ++i) {
                if ((exactMatch || !lStr.startsWith(strList[i].toLowerCase())) && (!exactMatch || !lStr.equals(strList[i].toLowerCase()))) continue;
                return str;
            }
        }
        return null;
    }

    private String findFirstAppearance(Enumeration strings, String[] strList) {
        return this.findFirstAppearance(strings, strList, false);
    }

    private String[] getAttributeValues(Hashtable attrNamesAndValues, String attrPrefix) {
        return this.getAttributeValues(attrNamesAndValues, attrPrefix, 1);
    }

    private String[] getAttributeValues(Hashtable attrNamesAndValues, String attrPrefix, int startIndex) {
        String value;
        Vector values = new Vector();
        int i = startIndex;
        while ((value = this.getValue(attrNamesAndValues, attrPrefix + i)) != null) {
            if (!values.contains(value = value.trim())) {
                values.addElement(value);
            }
            ++i;
        }
        if (values.size() == 0) {
            return null;
        }
        Object[] strValues = new String[values.size()];
        values.copyInto(strValues);
        return strValues;
    }

    private String getValue(Hashtable attrNamesAndValues, String key) {
        Attribute attr = (Attribute)attrNamesAndValues.get(key);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private void jadAttributeNotFound(boolean legacyApp, String attrName) {
        if (!legacyApp) {
            Logger.logWarning(attrName + " is missing from JAD");
            throw new InvalidAttributeException(3, null, 5, new String[]{attrName}, 905);
        }
    }

    private class ManifestAttributes {
        public AuthorizationRestrictionAttribute[] authorizationRestrictionAttributes;
        public NetworkRestrictionsAttribute networkRestrictionsAttribute;

        public ManifestAttributes(Hashtable attrNamesAndValues, boolean signedSuite) {
            this(attrNamesAndValues, 1, signedSuite);
        }

        public ManifestAttributes(Hashtable attrNamesAndValues, int authorizationRestrictionsStartIndex, boolean signedSuite) {
            this.handleMIDP3Attributes(attrNamesAndValues, authorizationRestrictionsStartIndex, signedSuite);
        }

        private void handleLegacyAttributes(Hashtable attrNamesAndValues) {
            String midp3Attr = SecurityAttributes.this.findFirstAppearance(attrNamesAndValues.keys(), new String[]{"MIDlet-Access-Auth-Type-", "MIDlet-Access-Auth-Cert-", "MIDlet-Operator-Allowed"});
            if (midp3Attr != null) {
                Logger.logWarning(midp3Attr + " is a MIDP3 specific descriptor attribute, therefore it can only be placed into a MIDP3 descriptor");
                throw new InvalidAttributeException(3, null, 7, new String[]{midp3Attr}, 907);
            }
        }

        private void handleMIDP3Attributes(Hashtable attrNamesAndValues, int authorizationRestrictionsStartIndex, boolean signedSuite) {
            String networkRestrictions;
            Vector authRestrictions = new Vector();
            int i = authorizationRestrictionsStartIndex;
            String authRestrictionAttributeName = null;
            String authRestrictionCertAttributeName = null;
            while (true) {
                authRestrictionAttributeName = "MIDlet-Access-Auth-Type-" + i;
                String authRestriction = SecurityAttributes.this.getValue(attrNamesAndValues, authRestrictionAttributeName);
                authRestrictionCertAttributeName = "MIDlet-Access-Auth-Cert-" + i;
                String authRestrictionCert = SecurityAttributes.this.getValue(attrNamesAndValues, authRestrictionCertAttributeName);
                if (authRestriction == null && authRestrictionCert == null) break;
                AuthorizationRestrictionAttribute authRestrictionPair = new AuthorizationRestrictionAttribute(authRestrictionAttributeName, authRestriction, authRestrictionCertAttributeName, authRestrictionCert);
                if (!authRestrictions.contains(authRestrictionPair)) {
                    authRestrictions.addElement(authRestrictionPair);
                }
                ++i;
            }
            if (authRestrictions.size() != 0) {
                this.authorizationRestrictionAttributes = new AuthorizationRestrictionAttribute[authRestrictions.size()];
                authRestrictions.copyInto(this.authorizationRestrictionAttributes);
            }
            if (signedSuite && (networkRestrictions = SecurityAttributes.this.getValue(attrNamesAndValues, "MIDlet-Operator-Allowed")) != null) {
                this.networkRestrictionsAttribute = new NetworkRestrictionsAttribute(networkRestrictions);
            }
        }
    }

    private class DescriptorAttributes {
        public PermissionAttribute[] permissionAttributes;
        public AuthenticationAttribute[] authenticationAttributes;

        public DescriptorAttributes(Hashtable attrNamesAndValues) {
            this(attrNamesAndValues, 1, 1, true, true);
        }

        public DescriptorAttributes(Hashtable attrNamesAndValues, int optPermsStartIndex, int mandatoryPermsStartIndex, boolean parseAuthenticationInfo, boolean parsePermissions) {
            String midpVersion = SecurityAttributes.this.getValue(attrNamesAndValues, SecurityAttributes.MIDP_VERSION_ATTRIBUTE_NAME);
            if (midpVersion == null || !midpVersion.equalsIgnoreCase(SecurityAttributes.MIDP3_VERSION_ATTRIBUTE_VALUE)) {
                this.handleLegacyAttributes(attrNamesAndValues, parseAuthenticationInfo, parsePermissions);
            } else {
                this.handleMIDP3Attributes(attrNamesAndValues, optPermsStartIndex, mandatoryPermsStartIndex, parseAuthenticationInfo);
            }
        }

        private void handleLegacyAttributes(Hashtable attrNamesAndValues, boolean parseAuthenticationInfo, boolean parsePermissions) {
            String midp3Attr = SecurityAttributes.this.findFirstAppearance(attrNamesAndValues.keys(), new String[]{"MIDlet-Permission-", "MIDlet-Permission-Opt-", "MIDlet-Jar-RSA-SHA1-"});
            if (midp3Attr != null) {
                Logger.logWarning(midp3Attr + " is a MIDP3 specific descriptor attribute, therefore it can only be placed into a MIDP3 descriptor");
                throw new InvalidAttributeException(3, null, 7, new String[]{midp3Attr}, 906);
            }
            Object[] optPerms = null;
            Object[] mandatoryPerms = null;
            if (parseAuthenticationInfo) {
                this.saveAuthenticationInfo(attrNamesAndValues, true);
            }
            if (parsePermissions && (parseAuthenticationInfo && this.authenticationAttributes != null || !parseAuthenticationInfo)) {
                optPerms = OptionalPermissionAttribute.HandleLegacyAttribute(SecurityAttributes.this.getValue(attrNamesAndValues, "MIDlet-Permissions-Opt"));
                mandatoryPerms = MandatoryPermissionAttribute.HandleLegacyAttribute(SecurityAttributes.this.getValue(attrNamesAndValues, "MIDlet-Permissions"));
            } else {
                mandatoryPerms = new PermissionAttribute[]{new MandatoryPermissionAttribute()};
            }
            this.savePermissions(optPerms, mandatoryPerms);
        }

        private void handleMIDP3Attributes(Hashtable attrNamesAndValues, int optPermsStartIndex, int mandatoryPermsStartIndex, boolean parseAuthenticationInfo) {
            String legacySigAttr = SecurityAttributes.this.findFirstAppearance(attrNamesAndValues.keys(), new String[]{"MIDlet-Jar-RSA-SHA1", "MIDlet-Permissions", "MIDlet-Permissions-Opt"}, true);
            if (legacySigAttr != null) {
                Logger.logWarning(legacySigAttr + " is a MIDP2 specific descriptor attribute, therefore it can only be placed into a MIDP2 descriptor");
                throw new InvalidAttributeException(3, null, 7, new String[]{legacySigAttr}, 906);
            }
            Object[] optPermValues = SecurityAttributes.this.getAttributeValues(attrNamesAndValues, "MIDlet-Permission-Opt-", optPermsStartIndex);
            Object[] mandatoryPermValues = SecurityAttributes.this.getAttributeValues(attrNamesAndValues, "MIDlet-Permission-", mandatoryPermsStartIndex);
            this.savePermissions(optPermValues, mandatoryPermValues);
            if (parseAuthenticationInfo) {
                this.saveAuthenticationInfo(attrNamesAndValues, false);
            }
        }

        private void savePermissions(Object[] optPerms, Object[] mandatoryPerms) {
            boolean strings;
            if (optPerms == null && mandatoryPerms == null) {
                return;
            }
            int length = (optPerms != null ? optPerms.length : 0) + (mandatoryPerms != null ? mandatoryPerms.length : 0);
            if (length == 0) {
                return;
            }
            this.permissionAttributes = new PermissionAttribute[length];
            int i = 0;
            if (optPerms != null && optPerms.length > 0) {
                strings = optPerms[0] instanceof String;
                for (i = 0; i < optPerms.length; ++i) {
                    this.permissionAttributes[i] = strings ? new OptionalPermissionAttribute("MIDlet-Permission-Opt-" + (i + 1), (String)optPerms[i]) : (PermissionAttribute)optPerms[i];
                }
            }
            if (mandatoryPerms != null && mandatoryPerms.length > 0) {
                strings = mandatoryPerms[0] instanceof String;
                for (int j = 0; j < mandatoryPerms.length; ++j) {
                    this.permissionAttributes[i + j] = strings ? new MandatoryPermissionAttribute("MIDlet-Permission-" + (j + 1), (String)mandatoryPerms[j]) : (PermissionAttribute)mandatoryPerms[j];
                }
            }
        }

        private void saveAuthenticationInfo(Hashtable attrNamesAndValues, boolean legacyAttributes) {
            Vector authAttributes = new Vector();
            int i = 1;
            String signature = null;
            String certAttributeName = null;
            String signatureAttributeName = null;
            if (legacyAttributes) {
                signatureAttributeName = "MIDlet-Jar-RSA-SHA1";
                signature = SecurityAttributes.this.getValue(attrNamesAndValues, signatureAttributeName);
            }
            InvalidAttributeException firstException = null;
            while (true) {
                AuthenticationAttribute authAttribute = null;
                String[] certChain = SecurityAttributes.this.getAttributeValues(attrNamesAndValues, "MIDlet-Certificate-" + i + "-");
                certAttributeName = "MIDlet-Certificate-" + i + "-";
                if (!legacyAttributes) {
                    signatureAttributeName = "MIDlet-Jar-RSA-SHA1-" + i;
                    signature = SecurityAttributes.this.getValue(attrNamesAndValues, signatureAttributeName);
                }
                if (certChain == null && signature == null) break;
                try {
                    if (legacyAttributes && i > 1) {
                        if (certChain == null) break;
                        authAttribute = new AuthenticationAttribute(certAttributeName, certChain, signatureAttributeName, signature, true);
                    } else {
                        authAttribute = new AuthenticationAttribute(certAttributeName, certChain, signatureAttributeName, signature);
                        authAttribute.setLegacyInfo(legacyAttributes);
                    }
                    if (!authAttributes.contains(authAttribute)) {
                        authAttributes.addElement(authAttribute);
                    }
                }
                catch (InvalidAttributeException e) {
                    if (firstException == null) {
                        firstException = e;
                    }
                    Logger.log("The validation of the following attribute pair {" + certAttributeName + ", " + signatureAttributeName + "} failed with error " + e.getMessage());
                }
                ++i;
            }
            if (authAttributes.size() != 0) {
                this.authenticationAttributes = new AuthenticationAttribute[authAttributes.size()];
                authAttributes.copyInto(this.authenticationAttributes);
            } else if (firstException != null) {
                throw firstException;
            }
        }
    }
}

