/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.common;

import com.nokia.mj.impl.security.common.Certificate;
import com.nokia.mj.impl.security.midp.common.ProtectionDomain;

public final class SigningCertificate
extends Certificate {
    private ProtectionDomain protectionDomain;
    private String protectionDomainRoot;

    public SigningCertificate(String issuer, String subject, String organization, String notBefore, String notAfter, String serialNumber, String fingerprint, String protectionDomainRoot, String protectionDomainName, String protectionDomainCategory) {
        super(issuer, subject, organization, notBefore, notAfter, serialNumber, fingerprint);
        this.protectionDomain = new ProtectionDomain(protectionDomainName, protectionDomainCategory);
        this.protectionDomainRoot = protectionDomainRoot;
    }

    public SigningCertificate(Certificate cert, String protectionDomainRoot, String protectionDomainName, String protectionDomainCategory) {
        super(cert);
        this.protectionDomain = new ProtectionDomain(protectionDomainName, protectionDomainCategory);
        this.protectionDomainRoot = protectionDomainRoot;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public String getProtectionDomainRoot() {
        return this.protectionDomainRoot;
    }

    public boolean isSameSigner(SigningCertificate cert) {
        if (cert == null) {
            return this.getOrganization() == null && this.protectionDomainRoot == null;
        }
        return (this.getOrganization() == null && cert.getOrganization() == null || this.getOrganization() != null && this.getOrganization().equals(cert.getOrganization())) && (this.protectionDomainRoot == null && cert.getProtectionDomainRoot() == null || this.protectionDomainRoot != null && this.protectionDomainRoot.equals(cert.getProtectionDomainRoot()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\nProtection Domain Root:" + this.protectionDomainRoot);
        sb.append(" Protection Domain:").append(this.getProtectionDomain().toString());
        return sb.toString();
    }
}

