/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.common;

import com.nokia.mj.impl.security.midp.common.UserSecuritySettings;
import com.nokia.mj.impl.utils.ResourceLoader;
import java.util.Vector;

public class UserSecuritySettingsImpl
implements UserSecuritySettings {
    private String name;
    private int currentInteractionMode;
    private int[] allowedInteractionModes;
    private boolean blanketPrompt;
    private static ResourceLoader resLoader = null;
    private static final String NET_ACCESS_ID = "setting_net_access";
    private static final String LOW_LEVEL_NET_ACCESS_ID = "setting_low_level_net_access";
    private static final String MESSAGING_ID = "setting_messaging";
    private static final String RESTRICTED_MESSAGING_ID = "setting_restricted_messaging";
    private static final String CALL_CONTROL_ID = "setting_call_control";
    private static final String LOCAL_CONNECTIVITY_ID = "setting_local_conn";
    private static final String MULTIMEDIA_RECORDING_ID = "setting_mm_record";
    private static final String READ_USER_DATA_ACCESS_ID = "setting_read_data";
    private static final String WRITE_USER_DATA_ACCESS_ID = "setting_write_data";
    private static final String APPLICATION_AUTO_INVOCATION_ID = "setting_app_auto_invocat";
    private static final String PHONE_CALL_ID = "setting_phone_call";
    private static final String LOCATION_ID = "setting_location";
    private static final String LANDMARK_ID = "setting_landmarks";
    private static final String SMART_CARD_COMMUNICATION_ID = "setting_smartcard";
    private static final String AUTHENTICATION_ID = "setting_auth";
    private static final String BROADCAST_ID = "setting_broadcast";
    private static final String NFC_WRITE_ACCESS_ID = "setting_nfc_write_access";

    public UserSecuritySettingsImpl(String name, int currentInteractionMode, int[] allowedInteractionModes) {
        this(name, currentInteractionMode, allowedInteractionModes, false);
    }

    public UserSecuritySettingsImpl(String name, int currentInteractionMode, int[] allowedInteractionModes, boolean blanketPrompt) {
        this.name = name;
        this.setCurrentInteractionMode(currentInteractionMode);
        this.setAllowedInteractionModes(allowedInteractionModes);
        this.blanketPrompt = blanketPrompt;
    }

    public String getName() {
        return this.name;
    }

    public static String getLocalizedName(String aSettingName) {
        if (resLoader == null) {
            resLoader = ResourceLoader.getInstance("javaapplicationsettings", "qtn_java_");
        }
        String id = "";
        if ("Net Access".equalsIgnoreCase(aSettingName)) {
            id = NET_ACCESS_ID;
        } else if ("Low Level Net Access".equalsIgnoreCase(aSettingName)) {
            id = LOW_LEVEL_NET_ACCESS_ID;
        } else if ("Messaging".equalsIgnoreCase(aSettingName)) {
            id = MESSAGING_ID;
        } else if ("Restricted Messaging".equalsIgnoreCase(aSettingName)) {
            id = RESTRICTED_MESSAGING_ID;
        } else if ("Call Control".equalsIgnoreCase(aSettingName)) {
            id = CALL_CONTROL_ID;
        } else if ("Local Connectivity".equalsIgnoreCase(aSettingName)) {
            id = LOCAL_CONNECTIVITY_ID;
        } else if ("Multimedia Recording".equalsIgnoreCase(aSettingName)) {
            id = MULTIMEDIA_RECORDING_ID;
        } else if ("Read User Data Access".equalsIgnoreCase(aSettingName)) {
            id = READ_USER_DATA_ACCESS_ID;
        } else if ("Write User Data Access".equalsIgnoreCase(aSettingName)) {
            id = WRITE_USER_DATA_ACCESS_ID;
        } else if ("Application Auto Invocation".equalsIgnoreCase(aSettingName)) {
            id = APPLICATION_AUTO_INVOCATION_ID;
        } else if ("Phone Call".equalsIgnoreCase(aSettingName)) {
            id = PHONE_CALL_ID;
        } else if ("NFC Write Access".equalsIgnoreCase(aSettingName)) {
            id = NFC_WRITE_ACCESS_ID;
        } else if ("Location".equalsIgnoreCase(aSettingName)) {
            id = LOCATION_ID;
        } else if ("Landmark".equalsIgnoreCase(aSettingName)) {
            id = LANDMARK_ID;
        } else if ("Smart Card Communication".equalsIgnoreCase(aSettingName)) {
            id = SMART_CARD_COMMUNICATION_ID;
        } else if ("Authentication".equalsIgnoreCase(aSettingName)) {
            id = AUTHENTICATION_ID;
        } else if ("Broadcast".equalsIgnoreCase(aSettingName)) {
            id = BROADCAST_ID;
        }
        return resLoader.format(id, null);
    }

    public int getCurrentInteractionMode() {
        return this.currentInteractionMode;
    }

    public int[] getAllowedInteractionModes() {
        return this.allowedInteractionModes;
    }

    public boolean getBlanketPrompt() {
        return this.blanketPrompt;
    }

    public boolean isInteractionModeAllowed(int interactionMode) {
        for (int i = 0; this.allowedInteractionModes != null && i < this.allowedInteractionModes.length; ++i) {
            if (this.allowedInteractionModes[i] != interactionMode) continue;
            return true;
        }
        return false;
    }

    public static UserSecuritySettings getPredefinedUserSecuritySettings(String preDefinedSettingsName) {
        int currentInteractionMode = 1;
        int[] allowedInteractionModes = new int[]{1};
        return new UserSecuritySettingsImpl("Net Access", currentInteractionMode, allowedInteractionModes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserSecuritySettings)) {
            return false;
        }
        UserSecuritySettings settings = (UserSecuritySettings)o;
        return this.getCurrentInteractionMode() == settings.getCurrentInteractionMode() && this.arraysEqual(this.getAllowedInteractionModes(), settings.getAllowedInteractionModes()) && (this.getName() == null && settings.getName() == null || this.getName() != null && this.getName().equals(settings.getName()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nSetting name:\"" + this.name + "\"");
        sb.append(" Settings current interaction mode:" + this.currentInteractionMode);
        sb.append(" Settings allowed interaction modes:");
        if (this.allowedInteractionModes != null) {
            for (int i = 0; i < this.allowedInteractionModes.length; ++i) {
                sb.append(this.allowedInteractionModes[i]);
                if (i >= this.allowedInteractionModes.length - 1) continue;
                sb.append(",");
            }
        } else {
            sb.append("NULL");
        }
        return sb.toString();
    }

    private boolean arraysEqual(int[] array1, int[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null && array2 != null || array1 != null && array2 == null || array1.length != array2.length) {
            return false;
        }
        int i = 0;
        if (i < array1.length) {
            boolean found = false;
            for (int j = 0; j < array2.length; ++j) {
                if (array1[i] != array2[j]) continue;
                found = true;
                break;
            }
            return found;
        }
        return true;
    }

    private void setCurrentInteractionMode(int currentInteractionMode) {
        this.currentInteractionMode = 4;
        if (this.interactionModeKnown(currentInteractionMode)) {
            this.currentInteractionMode = currentInteractionMode;
        }
    }

    private void setAllowedInteractionModes(int[] allowedInteractionModes) {
        Integer currentInteractionMode;
        Vector vAllowedSettings = new Vector();
        vAllowedSettings.addElement(new Integer(4));
        if (allowedInteractionModes != null) {
            for (int i = 0; i < allowedInteractionModes.length; ++i) {
                Integer allowedInteractionMode;
                if (!this.interactionModeKnown(allowedInteractionModes[i]) || vAllowedSettings.contains(allowedInteractionMode = new Integer(allowedInteractionModes[i]))) continue;
                vAllowedSettings.addElement(allowedInteractionMode);
            }
        }
        if (!vAllowedSettings.contains(currentInteractionMode = new Integer(this.currentInteractionMode))) {
            vAllowedSettings.addElement(currentInteractionMode);
        }
        this.allowedInteractionModes = new int[vAllowedSettings.size()];
        for (int i = 0; i < vAllowedSettings.size(); ++i) {
            this.allowedInteractionModes[i] = (Integer)vAllowedSettings.elementAt(i);
        }
    }

    private boolean interactionModeKnown(int interactionMode) {
        switch (interactionMode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }
}

