/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.storage;

import java.util.Vector;

public final class AuthenticationStorageData {
    private String protectionDomain;
    private String protectionDomainCategory;
    private String jarHashValue;
    private String rootHashValue;
    private int[] validatedChainIndexes;
    private String jarPath;
    private int securityWarningsMode;

    public AuthenticationStorageData(String protectionDomain, String protectionDomainCategory, String jarHashValue, String rootHashValue, String jarPath) {
        this(protectionDomain, protectionDomainCategory, jarHashValue, rootHashValue, null, jarPath, -1);
    }

    public AuthenticationStorageData(String protectionDomain, String protectionDomainCategory, String jarHashValue, String rootHashValue, Vector validatedChainIndexes) {
        this(protectionDomain, protectionDomainCategory, jarHashValue, rootHashValue, validatedChainIndexes, null, -1);
    }

    public AuthenticationStorageData(String protectionDomain, String protectionDomainCategory, String jarHashValue, String rootHashValue, Vector validatedChainIndexes, int securityWarningsMode) {
        this(protectionDomain, protectionDomainCategory, jarHashValue, rootHashValue, validatedChainIndexes, null, securityWarningsMode);
    }

    public AuthenticationStorageData(String protectionDomain, String protectionDomainCategory, String jarHashValue, String rootHashValue, Vector validatedChainIndexes, String jarPath) {
        this(protectionDomain, protectionDomainCategory, jarHashValue, rootHashValue, validatedChainIndexes, jarPath, -1);
    }

    public AuthenticationStorageData(String protectionDomain, String protectionDomainCategory, String jarHashValue, String rootHashValue, Vector validatedChainIndexes, String jarPath, int securityWarningsMode) {
        this.protectionDomain = protectionDomain;
        this.protectionDomainCategory = protectionDomainCategory;
        this.jarHashValue = jarHashValue;
        this.rootHashValue = rootHashValue;
        this.jarPath = jarPath;
        this.setValidatedChainIndexes(validatedChainIndexes);
        this.securityWarningsMode = securityWarningsMode;
    }

    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public String getProtectionDomainCategory() {
        return this.protectionDomainCategory;
    }

    public String getJarHashValue() {
        return this.jarHashValue;
    }

    public String getRootHashValue() {
        return this.rootHashValue;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public int getSecurityWarningsMode() {
        return this.securityWarningsMode;
    }

    public int[] getValidatedChainIndexes() {
        return this.validatedChainIndexes;
    }

    public void setJarHashValue(String jarHashValue) {
        this.jarHashValue = jarHashValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nDomain name:" + this.protectionDomain);
        sb.append("\nDomain category:" + this.protectionDomainCategory);
        sb.append("\nJar hash:" + this.jarHashValue);
        sb.append("\nRoot hash:" + this.rootHashValue);
        if (this.validatedChainIndexes != null && this.validatedChainIndexes.length > 0) {
            sb.append("\nValidated chain indexes:");
            for (int i = 0; i < this.validatedChainIndexes.length; ++i) {
                sb.append(this.validatedChainIndexes[i]);
                if (i >= this.validatedChainIndexes.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    private void setValidatedChainIndexes(Vector validatedChainIndexes) {
        if (validatedChainIndexes != null && validatedChainIndexes.size() > 0) {
            int i;
            Vector vIndexes = new Vector();
            for (i = 0; i < validatedChainIndexes.size(); ++i) {
                Integer index = (Integer)validatedChainIndexes.elementAt(i);
                if (vIndexes.contains(index)) continue;
                vIndexes.addElement(index);
            }
            this.validatedChainIndexes = new int[vIndexes.size()];
            for (i = 0; i < vIndexes.size(); ++i) {
                this.validatedChainIndexes[i] = (Integer)vIndexes.elementAt(i);
            }
        }
    }
}

