/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.storage;

import com.nokia.mj.impl.security.midp.common.AuthorizationRestriction;
import com.nokia.mj.impl.security.midp.common.AuthorizationRestrictionAttribute;
import com.nokia.mj.impl.security.midp.common.PolicyBasedPermission;
import com.nokia.mj.impl.security.midp.common.PolicyBasedPermissionImpl;
import com.nokia.mj.impl.security.midp.common.UserSecuritySettings;
import com.nokia.mj.impl.security.midp.common.UserSecuritySettingsImpl;
import com.nokia.mj.impl.security.midp.storage.AppAccessAuthorizationStorageData;
import com.nokia.mj.impl.security.midp.storage.AuthenticationStorageData;
import com.nokia.mj.impl.storage.StorageAttribute;
import com.nokia.mj.impl.storage.StorageEntry;
import com.nokia.mj.impl.storage.StorageException;
import com.nokia.mj.impl.storage.StorageFactory;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Tokenizer;
import com.nokia.mj.impl.utils.Uid;
import java.util.Hashtable;
import java.util.Vector;

public final class SecurityStorage {
    private StorageSession session = null;
    private boolean destroyStorageSession = true;
    private static final int NO_MASK = 1;
    private static final int BLANKET_MASK = 2;
    private static final int SESSION_MASK = 4;
    private static final int ONESHOT_MASK = 8;
    private static final int STORAGE_OPEN = 1;
    private static final int STORAGE_CLOSE = 2;
    private static final int STORAGE_SEARCH = 3;
    private static final int STORAGE_WRITE = 4;
    private static final int STORAGE_UPDATE = 5;
    private static final int STORAGE_REMOVE = 6;
    public static final int APP_ACCESS_AUTH_DOMAIN_QUERY = 1;
    public static final int APP_ACCESS_AUTH_VENDOR_QUERY = 2;
    public static final int APP_ACCESS_AUTH_SIGNERS_LIST_QUERY = 4;
    public static final int AUTHENTICATION_DOMAIN_NAME_QUERY = 1;
    public static final int AUTHENTICATION_DOMAIN_CATEGORY_QUERY = 2;
    public static final int AUTHENTICATION_ROOT_HASH_QUERY = 4;
    public static final int AUTHENTICATION_JAR_HASH_QUERY = 8;
    public static final int AUTHENTICATION_VALID_CERTS_QUERY = 16;
    private static final int NOT_FOUND = -2;
    private static final int REMOVED = -1;

    public SecurityStorage() {
        this.doStorageOpen();
    }

    public SecurityStorage(StorageSession session) {
        if (session != null) {
            this.destroyStorageSession = false;
            this.session = session;
        } else {
            this.doStorageOpen();
        }
    }

    public void close() {
        this.doStorageClose();
    }

    public StorageSession getStorageSession() {
        return this.session;
    }

    public AuthorizationRestriction[] readAuthorizationRestrictions(Uid appUID) {
        if (appUID == null) {
            return null;
        }
        Vector authRestrictions = new Vector();
        StorageEntry query = new StorageEntry();
        query.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
        int i = 1;
        while (true) {
            String mainAttrName = "MIDlet-Access-Auth-Type-" + i;
            StorageAttribute mainAttr = new StorageAttribute("NAME", mainAttrName);
            query.addAttribute(mainAttr);
            query.addAttribute(new StorageAttribute("VALUE", ""));
            StorageEntry[] entries = this.doStorageSearch("APPLICATION_PACKAGE_ATTRIBUTES", query);
            if (entries == null || entries.length <= 0) break;
            String mainAttrValue = this.getStorageAttributeValue(entries[0], "VALUE");
            String secondAttrName = "MIDlet-Access-Auth-Cert-" + i;
            query.removeAttribute(mainAttr);
            StorageAttribute secondAttr = new StorageAttribute("NAME", secondAttrName);
            query.addAttribute(secondAttr);
            entries = this.doStorageSearch("APPLICATION_PACKAGE_ATTRIBUTES", query);
            if (entries != null && entries.length > 0) {
                String secondAttrValue = this.getStorageAttributeValue(entries[0], "VALUE");
                authRestrictions.addElement(new AuthorizationRestrictionAttribute(mainAttrName, mainAttrValue, secondAttrName, secondAttrValue));
            } else {
                authRestrictions.addElement(new AuthorizationRestrictionAttribute(mainAttrName, mainAttrValue, null, null));
            }
            query.removeAttribute(secondAttr);
            ++i;
        }
        if (authRestrictions.size() == 0) {
            return null;
        }
        Object[] authorizationRestrictions = new AuthorizationRestriction[authRestrictions.size()];
        authRestrictions.copyInto(authorizationRestrictions);
        return authorizationRestrictions;
    }

    public AppAccessAuthorizationStorageData readAppAccessAuthorizationStorageData(Uid appUID) {
        return this.readAppAccessAuthorizationStorageData(appUID, 7);
    }

    public AppAccessAuthorizationStorageData readAppAccessAuthorizationStorageData(String aAppName, String aAppVersion, String aAppVendor, int readFilter) {
        return this.readAppAccessAuthorizationStorageData(null, aAppName, aAppVersion, aAppVendor, readFilter);
    }

    public AppAccessAuthorizationStorageData readAppAccessAuthorizationStorageData(Uid appUID, int readFilter) {
        return this.readAppAccessAuthorizationStorageData(appUID, null, null, null, readFilter);
    }

    public Vector readGrantedPermissions(Uid appUID) {
        int i;
        if (appUID == null) {
            return null;
        }
        StorageEntry query = new StorageEntry();
        query.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
        StorageEntry[] permEntries = this.doStorageSearch("MIDP_PERMISSIONS", query);
        Vector permissions = new Vector();
        Vector nonUserPermissions = new Vector();
        Hashtable fGroups = new Hashtable();
        if (permEntries != null && permEntries.length > 0) {
            for (i = 0; i < permEntries.length; ++i) {
                String className = this.getStorageAttributeValue(permEntries[i], "CLASS");
                String target = this.getStorageAttributeValue(permEntries[i], "NAME");
                String actionList = this.getStorageAttributeValue(permEntries[i], "ACTION");
                String fgName = this.getStorageAttributeValue(permEntries[i], "FUNCTION_GROUP");
                if (fgName != null) {
                    UserSecuritySettings cachedSettings = (UserSecuritySettings)fGroups.get(fgName);
                    if (cachedSettings != null) {
                        permissions.addElement(new PolicyBasedPermissionImpl(className, target, actionList, cachedSettings));
                    } else {
                        StorageEntry fgQuery = new StorageEntry();
                        fgQuery.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
                        fgQuery.addAttribute(new StorageAttribute("FUNCTION_GROUP", fgName));
                        fgQuery.addAttribute(new StorageAttribute("ALLOWED_SETTINGS", ""));
                        fgQuery.addAttribute(new StorageAttribute("CURRENT_SETTING", ""));
                        fgQuery.addAttribute(new StorageAttribute("BLANKET_PROMPT", ""));
                        StorageEntry[] fgEntries = this.doStorageSearch("MIDP_FUNCTION_GRP_SETTINGS", fgQuery);
                        if (fgEntries != null && fgEntries.length > 0) {
                            try {
                                int allowedSettings = Integer.valueOf(this.getStorageAttributeValue(fgEntries[0], "ALLOWED_SETTINGS"));
                                int currentSetting = Integer.valueOf(this.getStorageAttributeValue(fgEntries[0], "CURRENT_SETTING"));
                                String blanketPrompt = this.getStorageAttributeValue(fgEntries[0], "BLANKET_PROMPT");
                                UserSecuritySettingsImpl settings = new UserSecuritySettingsImpl(fgName, currentSetting, this.decodeAllowedSettings(allowedSettings), "1".equals(blanketPrompt));
                                permissions.addElement(new PolicyBasedPermissionImpl(className, target, actionList, settings));
                                fGroups.put(fgName, settings);
                            }
                            catch (NumberFormatException e) {}
                        }
                    }
                } else {
                    nonUserPermissions.addElement(new PolicyBasedPermissionImpl(className, target, actionList, null));
                }
                query.removeAttribute(fgName);
            }
        }
        for (i = 0; i < nonUserPermissions.size(); ++i) {
            permissions.addElement(nonUserPermissions.elementAt(i));
        }
        if (permissions.size() == 0) {
            return null;
        }
        return permissions;
    }

    public void writeGrantedPermissions(Uid appUID, Uid oldAppUID, Vector grantedPermissions, boolean preserveSettings) {
        if (grantedPermissions != null && grantedPermissions.size() > 0 && appUID != null) {
            if (oldAppUID != null) {
                this.updateGrantedPermissions(appUID, oldAppUID, grantedPermissions);
                return;
            }
            Vector fGroups = new Vector();
            for (int i = 0; i < grantedPermissions.size(); ++i) {
                UserSecuritySettings settings;
                PolicyBasedPermission p = (PolicyBasedPermission)grantedPermissions.elementAt(i);
                if (p == null) continue;
                StorageEntry permEntry = new StorageEntry();
                permEntry.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
                permEntry.addAttribute(new StorageAttribute("CLASS", p.getName()));
                permEntry.addAttribute(new StorageAttribute("NAME", p.getTarget()));
                if (p.getActionList() != null && p.getActionList().length() > 0) {
                    permEntry.addAttribute(new StorageAttribute("ACTION", p.getActionList()));
                }
                if ((settings = p.getUserSecuritySettings()) != null) {
                    StorageEntry fgEntry = new StorageEntry();
                    fgEntry.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
                    String fgName = settings.getName();
                    StorageAttribute fgAttribute = new StorageAttribute("FUNCTION_GROUP", fgName);
                    permEntry.addAttribute(fgAttribute);
                    if (!fGroups.contains(fgName)) {
                        fGroups.addElement(fgName);
                        if (!preserveSettings || this.readUserSecuritySettings(appUID, fgName) == null) {
                            fgEntry.addAttribute(new StorageAttribute("FUNCTION_GROUP", fgName));
                            fgEntry.addAttribute(new StorageAttribute("ALLOWED_SETTINGS", "" + this.encodeAllowedSettings(settings.getAllowedInteractionModes())));
                            fgEntry.addAttribute(new StorageAttribute("CURRENT_SETTING", "" + settings.getCurrentInteractionMode()));
                            fgEntry.addAttribute(new StorageAttribute("BLANKET_PROMPT", settings.getBlanketPrompt() ? "1" : "0"));
                            this.doStorageWrite("MIDP_FUNCTION_GRP_SETTINGS", fgEntry);
                        }
                    }
                }
                this.doStorageWrite("MIDP_PERMISSIONS", permEntry);
            }
        }
    }

    public void writeGrantedPermissions(Uid appUID, Uid oldAppUID, Vector grantedPermissions) {
        this.writeGrantedPermissions(appUID, oldAppUID, grantedPermissions, false);
    }

    public void removeGrantedPermissions(Uid appUid) {
        if (appUid != null) {
            this.doStorageRemove("MIDP_PERMISSIONS", appUid);
            this.doStorageRemove("MIDP_FUNCTION_GRP_SETTINGS", appUid);
        }
    }

    public AuthenticationStorageData readAuthenticationStorageData(String aAppName, String aAppVersion, String aAppVendor, int readFilter) {
        return this.readAuthenticationStorageData(null, aAppName, aAppVersion, aAppVendor, readFilter);
    }

    public AuthenticationStorageData readAuthenticationStorageData(Uid appUID) {
        return this.readAuthenticationStorageData(appUID, null, null, null, 31);
    }

    public String readProtectionDomain(Uid appUID) {
        if (appUID == null) {
            return null;
        }
        StorageEntry query = new StorageEntry();
        Object authData = null;
        query.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
        query.addAttribute(new StorageAttribute("SECURITY_DOMAIN", ""));
        StorageEntry[] entries = this.doStorageSearch("MIDP_PACKAGE", query);
        if (entries != null && entries.length > 0) {
            return this.getStorageAttributeValue(entries[0], "SECURITY_DOMAIN");
        }
        return null;
    }

    public String readProtectionDomainCategory(Uid appUID) {
        if (appUID == null) {
            return null;
        }
        StorageEntry query = new StorageEntry();
        Object authData = null;
        query.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
        query.addAttribute(new StorageAttribute("SECURITY_DOMAIN_CATEGORY", ""));
        StorageEntry[] entries = this.doStorageSearch("MIDP_PACKAGE", query);
        if (entries != null && entries.length > 0) {
            return this.getStorageAttributeValue(entries[0], "SECURITY_DOMAIN_CATEGORY");
        }
        return null;
    }

    public void writeAuthenticationStorageData(Uid appUID, AuthenticationStorageData data) {
        this.writeAuthenticationStorageData(appUID, data, false);
    }

    public void writeAuthenticationStorageData(Uid appUID, AuthenticationStorageData data, boolean update) {
        int securityWarningsMode;
        String validCerts;
        if (data == null || data.getProtectionDomain() == null) {
            return;
        }
        StorageEntry entry = new StorageEntry();
        entry.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
        entry.addAttribute(new StorageAttribute("SECURITY_DOMAIN", data.getProtectionDomain()));
        entry.addAttribute(new StorageAttribute("SECURITY_DOMAIN_CATEGORY", data.getProtectionDomainCategory()));
        if (data.getJarHashValue() != null && data.getJarHashValue().length() > 0) {
            entry.addAttribute(new StorageAttribute("HASH", data.getJarHashValue()));
        } else {
            entry.addAttribute(new StorageAttribute("HASH", null, 3));
        }
        if (data.getRootHashValue() != null && data.getRootHashValue().length() > 0) {
            entry.addAttribute(new StorageAttribute("CERT_HASH", data.getRootHashValue()));
        }
        if ((validCerts = this.encodeValidatedChainIndexes(data.getValidatedChainIndexes())) != null && validCerts.length() > 0) {
            entry.addAttribute(new StorageAttribute("VALID_CERTS", validCerts));
        }
        if ((securityWarningsMode = data.getSecurityWarningsMode()) == 2 || securityWarningsMode == 1) {
            entry.addAttribute(new StorageAttribute("SECURITY_WARNINGS", "" + securityWarningsMode));
        }
        if (update) {
            StorageEntry oldEntry = new StorageEntry();
            oldEntry.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
            this.doStorageUpdate("MIDP_PACKAGE", entry, oldEntry);
        } else {
            this.doStorageWrite("MIDP_PACKAGE", entry);
        }
    }

    public void removeAuthenticationStorageData(Uid appUid) {
        if (appUid != null) {
            this.doStorageRemove("MIDP_PACKAGE", appUid);
        }
    }

    public boolean readUserSecuritySettingsPromptFlag(Uid aAppUID, String aSettingsName) {
        String blanketPrompt;
        StorageEntry query = new StorageEntry();
        Object settings = null;
        query.addAttribute(new StorageAttribute("ID", aAppUID.getStringValue()));
        query.addAttribute(new StorageAttribute("FUNCTION_GROUP", aSettingsName));
        query.addAttribute(new StorageAttribute("BLANKET_PROMPT", ""));
        StorageEntry[] entries = this.doStorageSearch("MIDP_FUNCTION_GRP_SETTINGS", query);
        return entries != null && entries.length > 0 && (blanketPrompt = this.getStorageAttributeValue(entries[0], "BLANKET_PROMPT")) != null && blanketPrompt.equals("1");
    }

    public void writeUserSecuritySettingsPromptFlag(Uid aAppUID, String aSettingsName, boolean aPromptFlag) {
        StorageEntry query = new StorageEntry();
        StorageEntry newEntry = new StorageEntry();
        Object settings = null;
        query.addAttribute(new StorageAttribute("ID", aAppUID.getStringValue()));
        query.addAttribute(new StorageAttribute("FUNCTION_GROUP", aSettingsName));
        newEntry.addAttribute(new StorageAttribute("BLANKET_PROMPT", aPromptFlag ? "1" : "0"));
        this.doStorageUpdate("MIDP_FUNCTION_GRP_SETTINGS", newEntry, query);
    }

    public UserSecuritySettings readUserSecuritySettings(Uid msUID, String settingsName) {
        if (settingsName == null) {
            return null;
        }
        StorageEntry query = new StorageEntry();
        UserSecuritySettingsImpl settings = null;
        query.addAttribute(new StorageAttribute("ID", msUID.getStringValue()));
        query.addAttribute(new StorageAttribute("FUNCTION_GROUP", settingsName));
        query.addAttribute(new StorageAttribute("ALLOWED_SETTINGS", ""));
        query.addAttribute(new StorageAttribute("CURRENT_SETTING", ""));
        query.addAttribute(new StorageAttribute("BLANKET_PROMPT", ""));
        StorageEntry[] entries = this.doStorageSearch("MIDP_FUNCTION_GRP_SETTINGS", query);
        if (entries != null && entries.length > 0) {
            try {
                int allowedSettings = Integer.valueOf(this.getStorageAttributeValue(entries[0], "ALLOWED_SETTINGS"));
                int currentSetting = Integer.valueOf(this.getStorageAttributeValue(entries[0], "CURRENT_SETTING"));
                String blanketPrompt = this.getStorageAttributeValue(entries[0], "BLANKET_PROMPT");
                settings = new UserSecuritySettingsImpl(settingsName, currentSetting, this.decodeAllowedSettings(allowedSettings), "1".equals(blanketPrompt));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return settings;
    }

    public UserSecuritySettings[] readUserSecuritySettings(Uid msUID) {
        StorageEntry query = new StorageEntry();
        query.addAttribute(new StorageAttribute("ID", msUID.getStringValue()));
        query.addAttribute(new StorageAttribute("FUNCTION_GROUP", ""));
        StorageEntry[] entries = this.doStorageSearch("MIDP_PERMISSIONS", query);
        Vector vSettings = new Vector();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                UserSecuritySettings settings = this.readUserSecuritySettings(msUID, this.getStorageAttributeValue(entries[i], "FUNCTION_GROUP"));
                if (settings == null) continue;
                vSettings.addElement(settings);
            }
        }
        if (vSettings.size() == 0) {
            return null;
        }
        Object[] settings = new UserSecuritySettings[vSettings.size()];
        vSettings.copyInto(settings);
        return settings;
    }

    public void writeUserSecuritySettings(Uid msUID, String settingsName, int currentInteractionMode) {
        StorageEntry entry = new StorageEntry();
        entry.addAttribute(new StorageAttribute("ID", msUID.getStringValue()));
        entry.addAttribute(new StorageAttribute("FUNCTION_GROUP", settingsName));
        entry.addAttribute(new StorageAttribute("CURRENT_SETTING", "" + currentInteractionMode));
        this.updateFunctionGroupTable(msUID, entry);
    }

    public void writeUserSecuritySettings(Uid msUID, String settingsName, int currentInteractionMode, boolean blanketPromptShown) {
        StorageEntry entry = new StorageEntry();
        entry.addAttribute(new StorageAttribute("ID", msUID.getStringValue()));
        entry.addAttribute(new StorageAttribute("FUNCTION_GROUP", settingsName));
        entry.addAttribute(new StorageAttribute("CURRENT_SETTING", "" + currentInteractionMode));
        entry.addAttribute(new StorageAttribute("BLANKET_PROMPT", blanketPromptShown ? "1" : "0"));
        this.updateFunctionGroupTable(msUID, entry);
    }

    public void writeUserSecuritySettings(Uid msUID, int currentInteractionMode, boolean blanketPromptShown) {
        UserSecuritySettings[] settings = this.readUserSecuritySettings(msUID);
        if (settings != null) {
            for (int i = 0; i < settings.length; ++i) {
                this.writeUserSecuritySettings(msUID, settings[i].getName(), currentInteractionMode, blanketPromptShown);
            }
        }
    }

    public String readSuiteVersion(Uid appUID) {
        StorageEntry query = new StorageEntry();
        query.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
        StorageAttribute versionAttr = new StorageAttribute("NAME", "MicroEdition-Profile");
        query.addAttribute(versionAttr);
        query.addAttribute(new StorageAttribute("VALUE", ""));
        StorageEntry[] entries = this.doStorageSearch("APPLICATION_PACKAGE_ATTRIBUTES", query);
        if (entries != null && entries.length > 0) {
            return this.getStorageAttributeValue(entries[0], "VALUE");
        }
        return null;
    }

    public String readSuiteMediaId(Uid appUID) {
        StorageEntry query = new StorageEntry();
        query.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
        query.addAttribute(new StorageAttribute("MEDIA_ID", ""));
        StorageEntry[] entries = this.doStorageSearch("APPLICATION_PACKAGE", query);
        if (entries != null && entries.length > 0) {
            return this.getStorageAttributeValue(entries[0], "MEDIA_ID");
        }
        return null;
    }

    public String readNetworkRestrictions(Uid appUID) {
        StorageEntry query = new StorageEntry();
        query.addAttribute(new StorageAttribute("ID", appUID.getStringValue()));
        query.addAttribute(new StorageAttribute("NAME", "MIDlet-Operator-Allowed"));
        query.addAttribute(new StorageAttribute("VALUE", ""));
        StorageEntry[] entries = this.doStorageSearch("APPLICATION_PACKAGE_ATTRIBUTES", query);
        if (entries != null && entries.length > 0) {
            return this.getStorageAttributeValue(entries[0], "VALUE");
        }
        return null;
    }

    public int readSecurityWarningsMode(Uid appUid) {
        block5: {
            try {
                StorageEntry query = new StorageEntry();
                query.addAttribute(new StorageAttribute("ID", appUid.getStringValue()));
                query.addAttribute(new StorageAttribute("SECURITY_WARNINGS", ""));
                StorageEntry[] entries = this.doStorageSearch("MIDP_PACKAGE", query);
                if (entries == null || entries.length <= 0) break block5;
                try {
                    int value = Integer.valueOf(this.getStorageAttributeValue(entries[0], "SECURITY_WARNINGS"));
                    if (value == 2 || value == 1) {
                        return value;
                    }
                }
                catch (NumberFormatException e) {}
            }
            catch (StorageException storageException) {
                // empty catch block
            }
        }
        return 2;
    }

    public void writeSecurityWarningsMode(Uid appUid, int aSecurityWarningsMode) {
        try {
            switch (aSecurityWarningsMode) {
                case 1: 
                case 2: {
                    StorageEntry entry = new StorageEntry();
                    entry.addAttribute(new StorageAttribute("SECURITY_WARNINGS", "" + aSecurityWarningsMode));
                    StorageEntry oldEntry = new StorageEntry();
                    oldEntry.addAttribute(new StorageAttribute("ID", appUid.getStringValue()));
                    this.doStorageUpdate("MIDP_PACKAGE", entry, oldEntry);
                }
            }
        }
        catch (StorageException storageException) {
            // empty catch block
        }
    }

    private void updateGrantedPermissions(Uid newAppUID, Uid oldAppUID, Vector grantedPermissions) {
        int i;
        PolicyBasedPermission p;
        Vector newGrantedPermissions = new Vector();
        Vector oldPermissions = this.readGrantedPermissions(oldAppUID);
        if (oldPermissions != null) {
            int index = 0;
            block4: while (index < grantedPermissions.size()) {
                p = (PolicyBasedPermission)grantedPermissions.elementAt(index);
                int status = this.removeElement(oldPermissions, p);
                switch (status) {
                    case -2: {
                        ++index;
                        continue block4;
                    }
                    case -1: {
                        grantedPermissions.removeElementAt(index);
                        continue block4;
                    }
                }
                UserSecuritySettings oldSettings = ((PolicyBasedPermission)oldPermissions.elementAt(status)).getUserSecuritySettings();
                UserSecuritySettings newSettings = p.getUserSecuritySettings();
                if (oldSettings != null && newSettings != null) {
                    newGrantedPermissions.addElement(new PolicyBasedPermissionImpl(p.getName(), p.getTarget(), p.getActionList(), new UserSecuritySettingsImpl(newSettings.getName(), oldSettings.getCurrentInteractionMode(), newSettings.getAllowedInteractionModes(), oldSettings.getBlanketPrompt())));
                } else {
                    newGrantedPermissions.addElement(p);
                }
                grantedPermissions.removeElementAt(index);
            }
        }
        this.writeGrantedPermissions(newAppUID, null, grantedPermissions, true);
        for (i = 0; i < newGrantedPermissions.size(); ++i) {
            grantedPermissions.addElement(newGrantedPermissions.elementAt(i));
        }
        if (oldPermissions != null) {
            for (i = 0; i < oldPermissions.size(); ++i) {
                p = (PolicyBasedPermission)oldPermissions.elementAt(i);
                StorageEntry removePermissionQuery = new StorageEntry();
                removePermissionQuery.addAttribute(new StorageAttribute("ID", oldAppUID.getStringValue()));
                removePermissionQuery.addAttribute(new StorageAttribute("CLASS", p.getName()));
                removePermissionQuery.addAttribute(new StorageAttribute("NAME", p.getTarget()));
                if (p.getActionList() != null && p.getActionList().length() > 0) {
                    removePermissionQuery.addAttribute(new StorageAttribute("ACTION", p.getActionList()));
                }
                this.doStorageRemove("MIDP_PERMISSIONS", removePermissionQuery);
                UserSecuritySettings settings = p.getUserSecuritySettings();
                if (settings == null) continue;
                StorageEntry permissionsQuery = new StorageEntry();
                permissionsQuery.addAttribute(new StorageAttribute("ID", newAppUID.getStringValue()));
                permissionsQuery.addAttribute(new StorageAttribute("FUNCTION_GROUP", settings.getName()));
                StorageEntry[] permissions = this.doStorageSearch("MIDP_PERMISSIONS", permissionsQuery);
                if (permissions != null && (permissions == null || permissions.length != 0)) continue;
                StorageEntry removeSettingsQuery = new StorageEntry();
                removeSettingsQuery.addAttribute(new StorageAttribute("ID", newAppUID.getStringValue()));
                removeSettingsQuery.addAttribute(new StorageAttribute("FUNCTION_GROUP", settings.getName()));
                this.doStorageRemove("MIDP_FUNCTION_GRP_SETTINGS", removeSettingsQuery);
            }
        }
        this.writeGrantedPermissions(newAppUID, null, newGrantedPermissions, true);
    }

    private AuthenticationStorageData readAuthenticationStorageData(Uid appUID, String aAppName, String aAppVersion, String aAppVendor, int readFilter) {
        StorageEntry[] entries;
        boolean readValidCerts;
        if (appUID == null && (aAppName == null || aAppVersion == null || aAppVendor == null)) {
            return null;
        }
        boolean readDomainName = (readFilter & 1) != 0;
        boolean readDomainCategory = (readFilter & 2) != 0;
        boolean readRootHash = (readFilter & 4) != 0;
        boolean readJarHash = (readFilter & 8) != 0;
        boolean bl = readValidCerts = (readFilter & 0x10) != 0;
        if (!(readDomainName || readDomainCategory || readRootHash || readJarHash || readValidCerts)) {
            return null;
        }
        StorageAttribute ID = null;
        if (appUID != null) {
            ID = new StorageAttribute("ID", appUID.getStringValue());
        } else {
            ID = this.readApplicationID(aAppName, aAppVersion, aAppVendor);
            if (ID == null) {
                return null;
            }
        }
        StorageEntry query = new StorageEntry();
        query.addAttribute(ID);
        AuthenticationStorageData authData = null;
        if (readDomainName) {
            query.addAttribute(new StorageAttribute("SECURITY_DOMAIN", ""));
        }
        if (readDomainCategory) {
            query.addAttribute(new StorageAttribute("SECURITY_DOMAIN_CATEGORY", ""));
        }
        if (readJarHash) {
            query.addAttribute(new StorageAttribute("HASH", ""));
        }
        if (readRootHash) {
            query.addAttribute(new StorageAttribute("CERT_HASH", ""));
        }
        if (readValidCerts) {
            query.addAttribute(new StorageAttribute("VALID_CERTS", ""));
        }
        if ((entries = this.doStorageSearch("MIDP_PACKAGE", query)) != null && entries.length > 0) {
            try {
                authData = new AuthenticationStorageData(this.getStorageAttributeValue(entries[0], "SECURITY_DOMAIN"), this.getStorageAttributeValue(entries[0], "SECURITY_DOMAIN_CATEGORY"), this.getStorageAttributeValue(entries[0], "HASH"), this.getStorageAttributeValue(entries[0], "CERT_HASH"), this.decodeValidatedChainIndexes(this.getStorageAttributeValue(entries[0], "VALID_CERTS")));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return authData;
    }

    private AppAccessAuthorizationStorageData readAppAccessAuthorizationStorageData(Uid appUID, String aAppName, String aAppVersion, String aAppVendor, int readFilter) {
        boolean readSignersList;
        if (appUID == null && (aAppName == null || aAppVersion == null || aAppVendor == null)) {
            return null;
        }
        boolean readDomain = (readFilter & 1) != 0;
        boolean readVendor = (readFilter & 2) != 0;
        boolean bl = readSignersList = (readFilter & 4) != 0;
        if (!(readDomain || readVendor || readSignersList)) {
            return null;
        }
        StorageAttribute ID = null;
        if (appUID != null) {
            ID = new StorageAttribute("ID", appUID.getStringValue());
        } else {
            ID = this.readApplicationID(aAppName, aAppVersion, aAppVendor);
            if (ID == null) {
                return null;
            }
        }
        StorageEntry query = new StorageEntry();
        query.addAttribute(ID);
        StorageEntry[] entries = null;
        String vendorName = null;
        String domainName = null;
        Object[] signersList = null;
        if (readVendor) {
            if (aAppVendor != null) {
                vendorName = aAppVendor;
            } else {
                query.addAttribute(new StorageAttribute("VENDOR", ""));
                entries = this.doStorageSearch("APPLICATION_PACKAGE", query);
                if (entries != null && entries.length > 0) {
                    vendorName = this.getStorageAttributeValue(entries[0], "VENDOR");
                }
            }
        }
        if (readDomain || readSignersList) {
            query.removeAll();
            query.addAttribute(ID);
            if (readDomain) {
                query.addAttribute(new StorageAttribute("SECURITY_DOMAIN", ""));
            }
            if (readSignersList) {
                query.addAttribute(new StorageAttribute("VALID_CERTS", ""));
            }
            if ((entries = this.doStorageSearch("MIDP_PACKAGE", query)) != null && entries.length > 0) {
                domainName = this.getStorageAttributeValue(entries[0], "SECURITY_DOMAIN");
                Vector validatedChainIndexes = this.decodeValidatedChainIndexes(this.getStorageAttributeValue(entries[0], "VALID_CERTS"));
                if (validatedChainIndexes != null) {
                    Vector vSignersList = new Vector();
                    for (int i = 0; i < validatedChainIndexes.size(); ++i) {
                        String attrName = "MIDlet-Certificate-" + (Integer)validatedChainIndexes.elementAt(i) + "-1";
                        query.removeAll();
                        query.addAttribute(ID);
                        query.addAttribute(new StorageAttribute("NAME", attrName));
                        query.addAttribute(new StorageAttribute("VALUE", ""));
                        entries = this.doStorageSearch("APPLICATION_PACKAGE_ATTRIBUTES", query);
                        if (entries == null || entries.length <= 0) continue;
                        vSignersList.addElement(this.getStorageAttributeValue(entries[0], "VALUE"));
                    }
                    if (vSignersList.size() > 0) {
                        signersList = new String[vSignersList.size()];
                        vSignersList.copyInto(signersList);
                    }
                }
            }
        }
        if (domainName == null && vendorName == null && signersList == null) {
            return null;
        }
        return new AppAccessAuthorizationStorageData(vendorName, domainName, (String[])signersList);
    }

    private StorageAttribute readApplicationID(String aAppName, String aAppVersion, String aAppVendor) {
        StorageEntry query = new StorageEntry();
        StorageAttribute NAME = new StorageAttribute("PACKAGE_NAME", aAppName);
        StorageAttribute VERSION = new StorageAttribute("VERSION", aAppVersion);
        StorageAttribute VENDOR = new StorageAttribute("VENDOR", aAppVendor);
        query.addAttribute(NAME);
        query.addAttribute(VERSION);
        query.addAttribute(VENDOR);
        query.addAttribute(new StorageAttribute("ID", ""));
        StorageEntry[] entries = this.doStorageSearch("APPLICATION_PACKAGE", query);
        if (entries != null && entries.length > 0) {
            return entries[0].getAttribute("ID");
        }
        return null;
    }

    private void updateFunctionGroupTable(Uid msUID, StorageEntry entry) {
        StorageEntry oldEntry = new StorageEntry();
        oldEntry.addAttribute(new StorageAttribute("ID", msUID.getStringValue()));
        oldEntry.addAttribute(new StorageAttribute("FUNCTION_GROUP", this.getStorageAttributeValue(entry, "FUNCTION_GROUP")));
        this.doStorageUpdate("MIDP_FUNCTION_GRP_SETTINGS", entry, oldEntry);
    }

    private void doStorageOpen() {
        this.doStorageOperation(1, null, null, null, null);
    }

    private void doStorageClose() {
        this.doStorageOperation(2, null, null, null, null);
    }

    private StorageEntry[] doStorageSearch(String tableName, StorageEntry entry) {
        return this.doStorageOperation(3, tableName, entry, null, null);
    }

    private void doStorageWrite(String tableName, StorageEntry entry) {
        this.doStorageOperation(4, tableName, entry, null, null);
    }

    private void doStorageUpdate(String tableName, StorageEntry newEntry, StorageEntry oldEntry) {
        this.doStorageOperation(5, tableName, newEntry, oldEntry, null);
    }

    private void doStorageRemove(String tableName, StorageEntry removeEntry) {
        this.doStorageOperation(6, tableName, null, removeEntry, null);
    }

    private void doStorageRemove(String tableName, Uid removeKey) {
        this.doStorageOperation(6, tableName, null, null, removeKey);
    }

    private StorageEntry[] doStorageOperation(int opID, String tableName, StorageEntry newEntry, StorageEntry oldEntry, Uid removeKey) {
        switch (opID) {
            case 1: {
                this.session = StorageFactory.createSession();
                this.session.open();
                break;
            }
            case 2: {
                if (!this.destroyStorageSession) break;
                this.session.close();
                this.session.destroySession();
                break;
            }
            case 3: {
                return this.session.search(tableName, newEntry);
            }
            case 4: {
                this.session.write(tableName, newEntry);
                break;
            }
            case 5: {
                this.session.update(tableName, newEntry, oldEntry);
                break;
            }
            case 6: {
                if (removeKey != null) {
                    this.session.remove(tableName, removeKey);
                    break;
                }
                this.session.remove(tableName, oldEntry);
            }
        }
        return null;
    }

    private String encodeValidatedChainIndexes(int[] validatedChainIndexes) {
        String strValidatedChainIndexes = null;
        if (validatedChainIndexes != null && validatedChainIndexes.length > 0) {
            strValidatedChainIndexes = "";
            for (int i = 0; i < validatedChainIndexes.length - 1; ++i) {
                strValidatedChainIndexes = strValidatedChainIndexes + validatedChainIndexes[i] + ",";
            }
            strValidatedChainIndexes = strValidatedChainIndexes + validatedChainIndexes[validatedChainIndexes.length - 1];
        }
        return strValidatedChainIndexes;
    }

    private Vector decodeValidatedChainIndexes(String strValidatedChainIndexes) throws NumberFormatException {
        if (strValidatedChainIndexes == null || strValidatedChainIndexes.length() == 0) {
            return null;
        }
        String[] tokens = Tokenizer.split(strValidatedChainIndexes, ",");
        Vector validatedChainIndexes = null;
        if (tokens != null && tokens.length > 0) {
            validatedChainIndexes = new Vector();
            for (int i = 0; i < tokens.length; ++i) {
                validatedChainIndexes.addElement(Integer.valueOf(tokens[i]));
            }
        }
        return validatedChainIndexes;
    }

    private int[] decodeAllowedSettings(int allowedSettings) {
        Vector vAllowedSettings = new Vector();
        int tmp = allowedSettings & 2;
        if (tmp > 0) {
            vAllowedSettings.addElement(new Integer(3));
        }
        if ((tmp = allowedSettings & 4) > 0) {
            vAllowedSettings.addElement(new Integer(2));
        }
        if ((tmp = allowedSettings & 8) > 0) {
            vAllowedSettings.addElement(new Integer(1));
        }
        if ((tmp = allowedSettings & 1) > 0) {
            vAllowedSettings.addElement(new Integer(4));
        }
        int[] settings = new int[vAllowedSettings.size()];
        for (int i = 0; i < vAllowedSettings.size(); ++i) {
            settings[i] = (Integer)vAllowedSettings.elementAt(i);
        }
        return settings;
    }

    private int encodeAllowedSettings(int[] allowedSettings) {
        int settings = 0;
        if (allowedSettings != null) {
            block6: for (int i = 0; i < allowedSettings.length; ++i) {
                switch (allowedSettings[i]) {
                    case 4: {
                        settings |= 1;
                        continue block6;
                    }
                    case 1: {
                        settings |= 8;
                        continue block6;
                    }
                    case 2: {
                        settings |= 4;
                        continue block6;
                    }
                    case 3: {
                        settings |= 2;
                    }
                }
            }
        }
        return settings;
    }

    private String getStorageAttributeValue(StorageEntry entry, String attrName) {
        String tmp;
        String attrValue = null;
        StorageAttribute attr = entry.getAttribute(attrName);
        if (attr != null && (tmp = attr.getValue()) != null && tmp.length() > 0) {
            attrValue = tmp;
            return attrValue;
        }
        return attrValue;
    }

    private int removeElement(Vector elements, PolicyBasedPermission element) {
        PolicyBasedPermissionImpl p1 = new PolicyBasedPermissionImpl(element.getName(), element.getTarget(), element.getActionList(), null);
        for (int i = 0; i < elements.size(); ++i) {
            PolicyBasedPermission tmp = (PolicyBasedPermission)elements.elementAt(i);
            PolicyBasedPermissionImpl p2 = new PolicyBasedPermissionImpl(tmp.getName(), tmp.getTarget(), tmp.getActionList(), null);
            if (!p1.equals(p2)) continue;
            UserSecuritySettings s1 = element.getUserSecuritySettings();
            UserSecuritySettings s2 = tmp.getUserSecuritySettings();
            if (s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2)) {
                elements.removeElementAt(i);
                return -1;
            }
            return i;
        }
        return -2;
    }
}

