/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.sensor;

import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.sensor.ChannelImpl;
import com.nokia.mj.impl.sensor.DataImpl;
import com.nokia.mj.impl.sensor.SensorInfoImpl;
import com.nokia.mj.impl.sensor.SensorManagerImpl;
import java.io.IOException;
import javax.microedition.sensor.Channel;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;

public class SensorConnectionImpl
implements SensorConnection {
    private static final String CONNECTION_CLOSED = "Connection closed";
    static final String PROP_PERMISSION = "com.nokia.permission";
    private SensorInfo iSensorInfo;
    private ChannelImpl[] iChannels = null;
    private int state = 1;
    private Finalizer iFinalizer;
    private int iHandle = 0;
    private SensorServer iServer;
    private DataListener iDataListener;
    private ObjectWait iGetDataSync = new ObjectWait();
    private boolean iListeningConditions = false;

    public SensorConnectionImpl(String aUrl) throws IOException {
        this.iServer = new SensorServer();
        SensorInfo[] infos = SensorManagerImpl.getInstance().findSensors(aUrl);
        if (infos == null || infos.length < 1) {
            throw new IllegalArgumentException("Cannot find sensor for URL: " + aUrl);
        }
        SensorInfoImpl sensor = (SensorInfoImpl)infos[0];
        this.iSensorInfo = sensor;
        this.iHandle = this.iServer.startServer(sensor.iIndex);
        this.iFinalizer = this.registerForFinalization();
    }

    public Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                SensorConnectionImpl.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        if (this.getState() == 4) {
            return;
        }
        this.removeDataListener();
        this.state = 4;
        this._stopServer(this.iHandle);
    }

    public Channel getChannel(ChannelInfo info) {
        if (info == null) {
            throw new NullPointerException("Retrieving Channel failed: channelInfo is null");
        }
        ChannelInfo[] channelInfos = this.getSensorInfo().getChannelInfos();
        if (this.iChannels == null) {
            this.iChannels = new ChannelImpl[channelInfos.length];
        }
        int index = 0;
        int l = 0;
        l = channelInfos.length;
        for (index = 0; index < l && info != channelInfos[index]; ++index) {
            if (index != l - 1) continue;
            throw new IllegalArgumentException("Retrieving Channel failed: ChannelInfo object not found");
        }
        if (this.iChannels[index] != null) {
            return this.iChannels[index];
        }
        this.iChannels[index] = new ChannelImpl(this, info, this.iHandle, index);
        return this.iChannels[index];
    }

    public Data[] getData(int bufferSize) throws IOException {
        return this.getData(bufferSize, -1L, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data[] getData(int bufferSize, long bufferingPeriod, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) throws IOException {
        if (this.state == 4) {
            throw new IOException("Retrieving data failed: sensor is unavailable or SensorConnection is closed");
        }
        if (this.state != 1) {
            throw new IllegalStateException("Retrieving data failed: SensorConnection is in STATE_LISTENING state");
        }
        if (bufferSize < 1) {
            if (bufferingPeriod < 1L) {
                throw new IllegalArgumentException("Retrieving data failed: bufferSize and bufferPeriod values are less than 1");
            }
            bufferSize = this.getSensorInfo().getMaxBufferSize();
        }
        if (bufferSize > this.getSensorInfo().getMaxBufferSize()) {
            throw new IllegalArgumentException("Retrieving data failed: bufferSize exceeds maximum size " + bufferSize);
        }
        ChannelInfo[] channels = this.iSensorInfo.getChannelInfos();
        Data[] data = new DataImpl[channels.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new DataImpl(channels[i]);
            data[i].prepareData(isUncertaintyIncluded);
        }
        this.iGetDataSync.iIsNotified = false;
        this._startDataListening(this.iHandle, data, bufferSize, bufferingPeriod, isTimestampIncluded, isValidityIncluded, true, channels[0].getDataType());
        ObjectWait objectWait = this.iGetDataSync;
        synchronized (objectWait) {
            try {
                if (!this.iGetDataSync.iIsNotified) {
                    this.iGetDataSync.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return data;
    }

    public SensorInfo getSensorInfo() {
        return this.iSensorInfo;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void removeDataListener() {
        this.closeCheck("Removing DataListener ");
        this._cancelDataListening(this.iHandle);
        this.iDataListener = null;
        this.state = 1;
    }

    public void setDataListener(DataListener listener, int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Setting DataListener failed: bufferSize value is less than 1");
        }
        this.setDataListener(listener, bufferSize, -1L, false, false, false);
    }

    public synchronized void setDataListener(DataListener listener, int bufferSize, long bufferingPeriod, boolean isTimestampIncluded, boolean isUncertaintyIncluded, boolean isValidityIncluded) {
        this.closeCheck("Setting DataListener ");
        if (listener == null) {
            throw new NullPointerException();
        }
        if (bufferSize < 1) {
            if (bufferingPeriod < 1L) {
                throw new IllegalArgumentException("Setting DataListener failed: bufferSize and bufferPeriod are less than 1");
            }
            bufferSize = this.iSensorInfo.getMaxBufferSize();
        }
        if (bufferSize > this.getSensorInfo().getMaxBufferSize()) {
            throw new IllegalArgumentException("Setting DataListener failed: bufferSize exceeds maximum size " + bufferSize);
        }
        if (this.state == 2) {
            this._cancelDataListening(this.iHandle);
        }
        ChannelInfo[] channels = this.iSensorInfo.getChannelInfos();
        Data[] data = new DataImpl[channels.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new DataImpl(channels[i]);
            data[i].prepareData(isUncertaintyIncluded);
        }
        this.iDataListener = listener;
        this._startDataListening(this.iHandle, data, bufferSize, bufferingPeriod, isTimestampIncluded, isValidityIncluded, false, channels[0].getDataType());
        this.state = 2;
    }

    public int[] getErrorCodes() {
        return new int[0];
    }

    public String getErrorText(int errorCode) {
        throw new IllegalArgumentException("No error codes supported");
    }

    private void closeCheck(String aReason) {
        if (this.state == 4) {
            throw new IllegalStateException(aReason + "failed: SensorConnection is already closed");
        }
    }

    protected void startConditionListening(int aListeningType) {
        if (!this.iListeningConditions) {
            this.iListeningConditions = true;
            this._startConditionListening(this.iHandle, aListeningType);
        }
    }

    protected void stopConditionListening() {
        boolean stop = true;
        for (int i = 0; i < this.iChannels.length; ++i) {
            if (this.iChannels[i] == null || !this.iChannels[i].hasConditions()) continue;
            stop = false;
            break;
        }
        if (stop) {
            this._stopConditionListening(this.iHandle);
            this.iListeningConditions = false;
        }
    }

    private native int _createSensorConnection(int var1, int var2);

    private native int _startDataListening(int var1, Data[] var2, int var3, long var4, boolean var6, boolean var7, boolean var8, int var9);

    private native int _cancelDataListening(int var1);

    private native void _removeConnection(int var1, int var2);

    protected native void _startConditionListening(int var1, int var2);

    protected native void _stopConditionListening(int var1);

    private native void _startServer(int var1);

    private native void _stopServer(int var1);

    protected void conditionMet(int aChannel, int aCondition, double aValue, long aTimeStamp) {
        this.iChannels[aChannel].conditionMet(aCondition, aValue, aTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dataReceived(Data[] aData, boolean aIsDataLost) {
        if (this.state == 2) {
            this.iDataListener.dataReceived(this, aData, aIsDataLost);
        } else if (this.state == 1) {
            ObjectWait objectWait = this.iGetDataSync;
            synchronized (objectWait) {
                this.iGetDataSync.iIsNotified = true;
                this.iGetDataSync.notify();
            }
        }
    }

    class SensorServer
    extends Thread {
        private int iHandle;
        private int iSensorIndex;
        private Object iLock = new Object();

        SensorServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int startServer(int aSensorIndex) throws IOException {
            this.iSensorIndex = aSensorIndex;
            this.start();
            Object object = this.iLock;
            synchronized (object) {
                try {
                    if (this.iHandle == 0) {
                        this.iLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.iHandle <= 0) {
                throw new IOException("Could not connect to sensor");
            }
            return this.iHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.iHandle = SensorConnectionImpl.this._createSensorConnection(SensorManagerImpl.getInstance().sSensorConnectionList, this.iSensorIndex);
            Object object = this.iLock;
            synchronized (object) {
                this.iLock.notify();
            }
            if (this.iHandle < 0) {
                return;
            }
            SensorConnectionImpl.this._startServer(this.iHandle);
            SensorConnectionImpl.this._removeConnection(SensorManagerImpl.getInstance().sSensorConnectionList, this.iHandle);
        }
    }

    private class ObjectWait {
        protected boolean iIsNotified = false;

        private ObjectWait() {
        }
    }
}

