/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.socket;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.gcf.utils.UrlParser;
import com.nokia.mj.impl.socket.SocketConnectionImpl;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.StreamConnection;

public class ServerSocketConnectionImpl
implements ServerSocketConnection {
    private int iMode;
    private int iNativeHandle;
    private int iPort;
    private UrlParser iUri;
    private boolean iConnectionOpen = false;
    private int iSockDesc;
    private int iSocketServerFactoryHandle;
    private ConnectionManager cminstance = null;
    private AccessPoint apn = null;

    public ServerSocketConnectionImpl(UrlParser aUri, int aMode) throws IOException {
        Logger.LOG(14, 4, " + ServerSocketConnectionImpl: ServerSocketConnectionImpl");
        this.iMode = aMode;
        this.iPort = aUri.port == -1 ? 0 : aUri.port;
        this.iUri = aUri;
        int[] ret = new int[1];
        this.iNativeHandle = this._createSocketServerNativePeer(this.iUri.toString(), aMode, this.iPort, ret);
        this.iSocketServerFactoryHandle = ret[0];
        Logger.LOG(14, 4, " iSocketServerFactory returned is " + this.iSocketServerFactoryHandle);
        if (this.iNativeHandle == 0) {
            throw new IOException("Unable to open serversocket connection: failed to create native peer");
        }
        this.iSockDesc = this._openServerSocket(this.iNativeHandle, this.iSocketServerFactoryHandle, this.iUri.toString());
        Logger.LOG(14, 4, "SocketDescriptor returned is " + this.iSockDesc);
        if (this.iSockDesc < 0) {
            throw new IOException("Unable to open serversocket connection. POSIX error code: " + this.iSockDesc);
        }
        this.iConnectionOpen = true;
        Logger.LOG(14, 4, " - ServerSocketConnectionImpl: ServerSocketConnectionImpl");
    }

    public String getLocalAddress() throws IOException {
        Logger.LOG(14, 4, "+SocketServerConnectionImpl::getLocalAddress \n");
        String[] addr = new String[1];
        if (!this.iConnectionOpen) {
            throw new IOException("getLocalAddress failed: connection is already closed");
        }
        int retValue = this._getLocalAddress(this.iNativeHandle, this.iSockDesc, addr);
        if (retValue < 0) {
            throw new IOException("getLocalAddress failed. POSIX error code: " + retValue);
        }
        Logger.LOG(14, 4, "-SocketServerConnectionImpl::getLocalAddress()");
        return addr[0];
    }

    public int getLocalPort() throws IOException {
        Logger.LOG(14, 4, "+SocketServerConnectionImpl::getLocalPort\n");
        if (!this.iConnectionOpen) {
            throw new IOException("getLocalPort failed: connection is already closed");
        }
        int result = this._getLocalPort(this.iNativeHandle, this.iSockDesc);
        if (result < 0) {
            throw new IOException("getLocalPort failed. POSIX error code: " + result);
        }
        Logger.LOG(14, 4, "-SocketServerConnectionImpl::getLocalPort\n");
        return result;
    }

    public synchronized StreamConnection acceptAndOpen() throws IOException {
        Logger.LOG(14, 4, "+ServerSocketConnectionImpl::acceptAndOpen \n");
        if (!this.iConnectionOpen) {
            throw new IOException("acceptAndOpen failed: connection is already closed");
        }
        int sockDesc = -1;
        sockDesc = this._accept(this.iNativeHandle);
        if (sockDesc < 0) {
            throw new IOException("acceptAndOpen failed. POSIX error code: " + sockDesc);
        }
        if (this.iPort == 0) {
            this.iPort = this.getLocalPort();
        }
        Logger.LOG(14, 4, "+ServerSocketConnectionImpl::acceptAndOpen - dynamic port = " + this.iPort);
        SocketConnectionImpl con = new SocketConnectionImpl(this.iUri, this.iMode, sockDesc, this.cminstance, this.apn);
        Logger.LOG(14, 4, "sockDesc:" + sockDesc);
        Logger.LOG(14, 4, "-SocketServerConnectionImpl::acceptAndOpen \n");
        return con;
    }

    public void close() throws IOException {
        if (!this.iConnectionOpen) {
            return;
        }
        Logger.LOG(14, 4, "+SocketServerConnectionImpl::Close \n");
        int ret = this._close(this.iNativeHandle, this.iSocketServerFactoryHandle, this.iUri.toString(), this.iSockDesc);
        if (ret != 0) {
            throw new IOException("Close failed. POSIX error code:: " + ret);
        }
        this.iConnectionOpen = false;
        Logger.LOG(14, 4, "-SocketServerConnectionImpl::Close \n");
    }

    private native int _createSocketServerNativePeer(String var1, int var2, int var3, int[] var4);

    private native int _getLocalPort(int var1, int var2);

    private native int _accept(int var1);

    private native int _getLocalAddress(int var1, int var2, String[] var3);

    private native int _close(int var1, int var2, String var3, int var4);

    private native int _openServerSocket(int var1, int var2, String var3);
}

