/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.storage;

import com.nokia.mj.impl.storage.StorageAttribute;
import com.nokia.mj.impl.storage.StorageConnection;
import com.nokia.mj.impl.storage.StorageEntry;
import com.nokia.mj.impl.storage.StorageException;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Tokenizer;
import java.util.Enumeration;

final class MessageDispatcher {
    private static final String APP_DELIM = ";#\n;";
    private static final String ATTR_DELIM = ";\n;";
    private StorageConnection iStorageConn = new StorageConnection();

    MessageDispatcher() {
    }

    String createAndSendMessage(int aMsgId, String aHeaders, String aStorageName) throws StorageException {
        String receivedMessage = "";
        String headers = this.createHeaders(aMsgId, aHeaders);
        switch (aMsgId) {
            case 1: {
                receivedMessage = this.iStorageConn.open(headers, aStorageName);
                break;
            }
            case 2: {
                this.iStorageConn.close(headers);
                break;
            }
            case 3: {
                this.iStorageConn.execute(headers, "BEGIN;");
                break;
            }
            case 4: {
                this.iStorageConn.execute(headers, "COMMIT;");
                break;
            }
            case 5: {
                this.iStorageConn.execute(headers, "ROLLBACK;");
                break;
            }
            case 13: {
                this.iStorageConn.closeSession();
                break;
            }
        }
        return receivedMessage;
    }

    StorageEntry[] createAndSendMessage(int aMsgId, String aHeaders, String aTableName, StorageEntry aEntry) throws StorageException {
        this.ensureNonEmpty(aTableName);
        StorageEntry[] responseEntry = null;
        StringBuffer sqlStatement = new StringBuffer();
        String headers = this.createHeaders(aMsgId, aHeaders);
        switch (aMsgId) {
            case 8: {
                this.createSearchStatement(aEntry, aTableName, sqlStatement);
                String response = this.iStorageConn.execute(headers, sqlStatement.toString());
                if (response.length() <= APP_DELIM.length()) break;
                responseEntry = this.populateEntries(response);
                break;
            }
            case 7: {
                this.createWriteStatement(aEntry, aTableName, sqlStatement);
                this.iStorageConn.execute(headers, sqlStatement.toString());
                break;
            }
            case 9: {
                sqlStatement.append("DELETE FROM ").append(aTableName);
                if (aEntry != null && aEntry.size() > 0) {
                    this.createWhereStatement(aEntry, sqlStatement);
                } else {
                    sqlStatement.append(";");
                }
                String response = this.iStorageConn.execute(headers, sqlStatement.toString());
                try {
                    int removedEntries = Integer.parseInt(response);
                    responseEntry = new StorageEntry[removedEntries];
                }
                catch (NumberFormatException nfe) {
                    Logger.ELOG(11, "Failed to parse amount of removed entries:" + response);
                }
                break;
            }
            case 11: {
                this.ensureNonEmpty(aEntry);
                String statementPrefix = "ALTER TABLE " + aTableName + " ADD ";
                Enumeration attrs = aEntry.elements();
                while (attrs.hasMoreElements()) {
                    StorageAttribute attribute = (StorageAttribute)attrs.nextElement();
                    sqlStatement.append(statementPrefix).append(attribute.getName());
                    if (attribute.getType() == 1) {
                        sqlStatement.append(" INT;");
                    } else {
                        sqlStatement.append(" VARCHAR;");
                    }
                    this.iStorageConn.execute(headers, sqlStatement.toString());
                    sqlStatement.delete(0, sqlStatement.length());
                }
                break;
            }
        }
        return responseEntry;
    }

    void handleUpdate(String aHeaders, String aTableName, StorageEntry aUpdate, StorageEntry aMatch) throws StorageException {
        this.ensureNonEmpty(aTableName);
        this.ensureNonEmpty(aUpdate);
        this.ensureNonEmpty(aMatch);
        String headers = this.createHeaders(12, aHeaders);
        StringBuffer sqlStatement = new StringBuffer();
        sqlStatement.append("UPDATE ").append(aTableName).append(" SET ");
        Enumeration updateAttrs = aUpdate.elements();
        while (updateAttrs.hasMoreElements()) {
            StorageAttribute attribute = (StorageAttribute)updateAttrs.nextElement();
            sqlStatement.append(attribute.getName()).append(" = ");
            this.appendQuoted(sqlStatement, attribute.getEscapedValue(), "'", attribute.getType() == 2);
            this.appendCond(sqlStatement, ", ", updateAttrs.hasMoreElements());
        }
        this.createWhereStatement(aMatch, sqlStatement);
        this.iStorageConn.execute(headers, sqlStatement.toString());
    }

    void handleCreateTable(String aHeaders, String aTableName, StorageEntry aTableColumns, StorageAttribute aPrimaryKey) throws StorageException {
        this.ensureNonEmpty(aTableName);
        if ((aTableColumns == null || aTableColumns.size() == 0) && aPrimaryKey == null) {
            throw new StorageException("Invalid argument");
        }
        if (aTableColumns == null) {
            aTableColumns = new StorageEntry();
        }
        String headers = this.createHeaders(12, aHeaders);
        StringBuffer sqlStatement = new StringBuffer();
        StringBuffer primaryKeyStmt = new StringBuffer();
        StringBuffer columnStmt = new StringBuffer();
        sqlStatement.append("CREATE TABLE ").append(aTableName).append(" (");
        if (aPrimaryKey != null) {
            if (aPrimaryKey.getType() == 1) {
                primaryKeyStmt.append(aPrimaryKey.getName()).append(" INT PRIMARY KEY");
            } else {
                primaryKeyStmt.append(aPrimaryKey.getName()).append(" VARCHAR PRIMARY KEY");
            }
        }
        Enumeration attrs = aTableColumns.elements();
        while (attrs.hasMoreElements()) {
            StorageAttribute attribute = (StorageAttribute)attrs.nextElement();
            columnStmt.append(attribute.getName());
            if (attribute.getType() == 1) {
                columnStmt.append(" INT");
            } else {
                columnStmt.append(" VARCHAR");
            }
            this.appendCond(columnStmt, ", ", attrs.hasMoreElements());
        }
        this.appendCond(sqlStatement, primaryKeyStmt.toString(), primaryKeyStmt.length() > 0);
        if (columnStmt.length() > 0) {
            this.appendCond(sqlStatement, ", ", primaryKeyStmt.length() > 0);
            sqlStatement.append(columnStmt.toString());
        }
        sqlStatement.append(");");
        this.iStorageConn.execute(headers, sqlStatement.toString());
    }

    private StorageEntry[] populateEntries(String aReceivedMessage) throws StorageException {
        if (aReceivedMessage == null || aReceivedMessage.length() <= APP_DELIM.length()) {
            throw new StorageException("Internal Error: Cannot populate received entry");
        }
        StorageEntry[] populatedEntries = null;
        String[] entries = Tokenizer.split(aReceivedMessage = aReceivedMessage.substring(APP_DELIM.length()), APP_DELIM);
        if (entries == null) {
            return null;
        }
        populatedEntries = new StorageEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            StorageEntry entry = new StorageEntry();
            String[] attributes = Tokenizer.split(entries[i], ATTR_DELIM);
            for (int j = 0; j < attributes.length; ++j) {
                int split;
                if (attributes[j].length() <= 0 || (split = attributes[j].indexOf(61)) == -1) continue;
                String name = attributes[j].substring(0, split);
                String value = attributes[j].substring(split + 1);
                StorageAttribute attr = new StorageAttribute(name, value);
                entry.addAttribute(attr);
            }
            populatedEntries[i] = entry;
        }
        return populatedEntries;
    }

    private void createWhereStatement(StorageEntry aEntry, StringBuffer aWhereStatement) throws StorageException {
        aWhereStatement.append(" WHERE ");
        Enumeration attrs = aEntry.elements();
        while (attrs.hasMoreElements()) {
            StorageAttribute attr = (StorageAttribute)attrs.nextElement();
            aWhereStatement.append(attr.getName()).append("=");
            this.appendQuoted(aWhereStatement, attr.getEscapedValue(), "'", attr.getType() == 2);
            this.appendCond(aWhereStatement, " AND ", attrs.hasMoreElements());
        }
        aWhereStatement.append(";");
    }

    private void createSearchStatement(StorageEntry aEntry, String aTableName, StringBuffer aSqlStatement) {
        StringBuffer selectStmt = new StringBuffer();
        StringBuffer whereStmt = new StringBuffer();
        if (aEntry == null) {
            aEntry = new StorageEntry();
        }
        Enumeration attrs = aEntry.elements();
        while (attrs.hasMoreElements()) {
            StorageAttribute attribute = (StorageAttribute)attrs.nextElement();
            if (attribute.getValue().equals("")) {
                selectStmt.append(attribute.getName()).append(',');
                continue;
            }
            whereStmt.append(attribute.getName()).append("=");
            this.appendQuoted(whereStmt, attribute.getEscapedValue(), "'", attribute.getType() == 2);
            whereStmt.append(" AND ");
        }
        this.removeCond(selectStmt, selectStmt.length() - 1, selectStmt.length(), selectStmt.length() > 0);
        this.removeCond(whereStmt, whereStmt.length() - 5, whereStmt.length(), whereStmt.length() > 0);
        this.appendCond(selectStmt, "*", selectStmt.length() == 0);
        aSqlStatement.append("SELECT ").append(selectStmt.toString()).append(" FROM ").append(aTableName);
        this.appendCond(aSqlStatement, " WHERE " + whereStmt.toString(), whereStmt.length() > 0);
        aSqlStatement.append(";");
    }

    private void createWriteStatement(StorageEntry aEntry, String aTableName, StringBuffer aSqlStatement) {
        this.ensureNonEmpty(aEntry);
        aSqlStatement.append("INSERT INTO ").append(aTableName).append(" (");
        StringBuffer values = new StringBuffer();
        Enumeration attrs = aEntry.elements();
        while (attrs.hasMoreElements()) {
            StorageAttribute attribute = (StorageAttribute)attrs.nextElement();
            aSqlStatement.append(attribute.getName());
            this.appendCond(aSqlStatement, ", ", attrs.hasMoreElements());
            this.appendQuoted(values, attribute.getEscapedValue(), "'", attribute.getType() == 2);
            this.appendCond(values, ", ", attrs.hasMoreElements());
        }
        aSqlStatement.append(')');
        aSqlStatement.append("VALUES (").append(values.toString()).append(");");
    }

    private String createHeaders(int aMsgId, String aHeaders) {
        StringBuffer headers = new StringBuffer();
        String reqID = String.valueOf(aMsgId);
        headers.append(String.valueOf(reqID.length()));
        headers.append(reqID);
        headers.append(aHeaders);
        return headers.toString();
    }

    private void ensureNonEmpty(StorageEntry aEntry) {
        if (aEntry == null || aEntry.size() < 1) {
            throw new StorageException("Invalid argument");
        }
    }

    private void ensureNonEmpty(String aValue) {
        if (aValue == null || aValue.equals("")) {
            throw new StorageException("Invalid argument");
        }
    }

    private void appendQuoted(StringBuffer aBuffer, String aValue, String aQuote, boolean aCondition) {
        if (aCondition) {
            aBuffer.append(aQuote).append(aValue).append(aQuote);
        } else {
            aBuffer.append(aValue);
        }
    }

    private void appendCond(StringBuffer aBuffer, String aValue, boolean aCondition) {
        if (aCondition) {
            aBuffer.append(aValue);
        }
    }

    private void removeCond(StringBuffer aBuffer, int aStart, int aEnd, boolean aCondition) {
        if (aCondition) {
            aBuffer.delete(aStart, aEnd);
        }
    }
}

