/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.storage;

import com.nokia.mj.impl.storage.StorageException;
import com.nokia.mj.impl.storage.StorageNames;

public final class StorageAttribute
implements StorageNames {
    private static final char ESCAPE_CHAR_SQUOTE = '\'';
    private String iName;
    private String iValue;
    private int iType;
    public static final int INT_TYPE = 1;
    public static final int STRING_TYPE = 2;
    public static final int NULL_TYPE = 3;

    private StorageAttribute() {
    }

    public StorageAttribute(String aName, String aValue) throws StorageException {
        this.setAttribute(aName, aValue, 2);
    }

    public StorageAttribute(String aName, String aValue, int aAttributeType) throws StorageException {
        this.setAttribute(aName, aValue, aAttributeType);
    }

    public void setAttribute(String aName, String aValue, int aAttributeType) throws StorageException {
        if (aName == null || aName.equals("")) {
            throw new StorageException("Invalid name argument");
        }
        if (aAttributeType < 1 || aAttributeType > 3) {
            throw new StorageException("Invalid type argument");
        }
        this.iName = aName;
        if (aValue == null || aAttributeType == 3) {
            this.iValue = "NULL";
            this.iType = 3;
        } else {
            this.iValue = aValue;
            this.iType = aAttributeType;
        }
    }

    public String getName() {
        return this.iName;
    }

    public String getValue() {
        if (this.iType != 3) {
            return this.iValue;
        }
        return null;
    }

    public int getType() {
        return this.iType;
    }

    public String toString() {
        return this.iName + "='" + this.iValue + "' Type: " + Integer.toString(this.iType);
    }

    public int hashCode() {
        return this.iName.hashCode() + this.iValue.hashCode() + this.iType;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof StorageAttribute)) {
            return false;
        }
        StorageAttribute attr = (StorageAttribute)aObj;
        return this.getName().equals(attr.getName()) && this.getValue().equals(attr.getValue()) && this.getType() == attr.getType();
    }

    String getEscapedValue() {
        if (this.iValue.indexOf(39) != -1) {
            return this.escape();
        }
        return this.iValue;
    }

    private String escape() {
        StringBuffer escapedVal = new StringBuffer(this.iValue);
        for (int i = 0; i < escapedVal.length(); ++i) {
            if (escapedVal.charAt(i) != '\'') continue;
            escapedVal.insert(i, '\'');
            ++i;
        }
        return escapedVal.toString();
    }
}

