/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.storage;

import com.nokia.mj.impl.storage.MessageDispatcher;
import com.nokia.mj.impl.storage.StorageAttribute;
import com.nokia.mj.impl.storage.StorageEntry;
import com.nokia.mj.impl.storage.StorageException;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;

final class StorageSessionImpl
implements StorageSession {
    static final int OPEN_CONN = 1;
    static final int CLOSE_CONN = 2;
    static final int START_TRANSACTION = 3;
    static final int COMMIT = 4;
    static final int ROLLBACK = 5;
    static final int READ = 6;
    static final int WRITE = 7;
    static final int SEARCH = 8;
    static final int REMOVE = 9;
    static final int CREATE_TABLE = 10;
    static final int APPEND_TABLE = 11;
    static final int UPDATE = 12;
    static final int DESTROY_SESSION = 13;
    private MessageDispatcher iMsgDispatcher = null;
    private String iSessionID = "";
    private boolean iConnectionOpen = false;
    private boolean iTransactionOpen = false;

    StorageSessionImpl() {
    }

    public void open() throws StorageException {
        this.open("JavaStorage");
    }

    public void open(String aStorageName) throws StorageException {
        if (this.iMsgDispatcher == null) {
            this.iMsgDispatcher = new MessageDispatcher();
        }
        this.ensureNonEmpty(aStorageName);
        this.assertState(this.iConnectionOpen, false);
        this.iSessionID = this.iMsgDispatcher.createAndSendMessage(1, "", aStorageName);
        this.iConnectionOpen = true;
        Logger.LOG(11, 16, "SessionID: " + this.iSessionID);
    }

    public void close() throws StorageException {
        this.assertState(this.iConnectionOpen, true);
        this.iMsgDispatcher.createAndSendMessage(2, this.iSessionID, "");
        this.iSessionID = "";
        this.iConnectionOpen = false;
        this.iTransactionOpen = false;
    }

    public void destroySession() {
        if (this.iMsgDispatcher != null) {
            try {
                this.iMsgDispatcher.createAndSendMessage(13, "", "");
            }
            catch (StorageException se) {
                Logger.ELOG(11, "DestroySession failed: " + se.toString());
            }
        }
        this.iConnectionOpen = false;
        this.iTransactionOpen = false;
    }

    public void startTransaction() throws StorageException {
        this.assertState(this.iConnectionOpen, true);
        this.assertState(this.iTransactionOpen, false);
        this.iMsgDispatcher.createAndSendMessage(3, this.iSessionID, "");
        this.iTransactionOpen = true;
    }

    public void commitTransaction() throws StorageException {
        this.assertState(this.iConnectionOpen, true);
        this.assertState(this.iTransactionOpen, true);
        this.iMsgDispatcher.createAndSendMessage(4, this.iSessionID, "");
        this.iTransactionOpen = false;
    }

    public void rollbackTransaction() throws StorageException {
        this.assertState(this.iConnectionOpen, true);
        this.assertState(this.iTransactionOpen, true);
        this.iMsgDispatcher.createAndSendMessage(5, this.iSessionID, "");
        this.iTransactionOpen = false;
    }

    public StorageEntry readEntry(String aTablename, Uid aUid) {
        StorageEntry[] entries = this.readEntries(aTablename, aUid);
        if (entries != null && entries.length > 0) {
            return entries[0];
        }
        return null;
    }

    public StorageEntry[] readEntries(String aTablename, Uid aUid) {
        this.assertState(this.iConnectionOpen, true);
        this.ensureNonEmpty(aUid);
        StorageEntry entry = new StorageEntry();
        entry.addAttribute(new StorageAttribute("ID", aUid.getStringValue()));
        return this.search(aTablename, entry);
    }

    public StorageEntry[] search(String aTablename, StorageEntry aSearchQuery) {
        this.assertState(this.iConnectionOpen, true);
        return this.iMsgDispatcher.createAndSendMessage(8, this.iSessionID, aTablename, aSearchQuery);
    }

    public void write(String aTablename, StorageEntry aEntry) throws StorageException {
        this.assertState(this.iConnectionOpen, true);
        this.iMsgDispatcher.createAndSendMessage(7, this.iSessionID, aTablename, aEntry);
    }

    public void update(String aTablename, StorageEntry aUpdate, StorageEntry aMatch) {
        this.assertState(this.iConnectionOpen, true);
        this.iMsgDispatcher.handleUpdate(this.iSessionID, aTablename, aUpdate, aMatch);
    }

    public int remove(String aTablename, Uid aUid) throws StorageException {
        this.ensureNonEmpty(aUid);
        StorageAttribute attribute = new StorageAttribute("ID", aUid.getStringValue());
        StorageEntry entry = new StorageEntry();
        entry.addAttribute(attribute);
        return this.remove(aTablename, entry);
    }

    public int remove(String aTablename, StorageEntry aEntry) throws StorageException {
        this.assertState(this.iConnectionOpen, true);
        StorageEntry[] entries = this.iMsgDispatcher.createAndSendMessage(9, this.iSessionID, aTablename, aEntry);
        if (entries != null) {
            return entries.length;
        }
        return -1;
    }

    public void createTable(String aTablename, StorageEntry aTableColumns, StorageAttribute aPrimaryKey) {
        this.assertState(this.iConnectionOpen, true);
        this.iMsgDispatcher.handleCreateTable(this.iSessionID, aTablename, aTableColumns, aPrimaryKey);
    }

    public void appendTable(String aTablename, StorageEntry aTableColumns) {
        this.assertState(this.iConnectionOpen, true);
        this.iMsgDispatcher.createAndSendMessage(11, this.iSessionID, aTablename, aTableColumns);
    }

    private void assertState(boolean aState, boolean aExpectedState) throws StorageException {
        if (aState != aExpectedState) {
            Logger.ELOG(11, "Wrong state: " + aState);
            throw new StorageException("Connection or transaction at wrong state: " + aState);
        }
    }

    private void ensureNonEmpty(String aValue) throws StorageException {
        if (aValue == null || aValue.equals("")) {
            Logger.ELOG(11, "Invalid argument");
            throw new StorageException("Invalid argument");
        }
    }

    private void ensureNonEmpty(Uid aUid) throws StorageException {
        if (aUid == null || aUid.equals("")) {
            Logger.ELOG(11, "Invalid argument");
            throw new StorageException("Invalid argument");
        }
    }
}

