/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.tckrunner;

import com.nokia.mj.impl.comms.CommsListener;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.comms.CommsServerEndpoint;
import com.nokia.mj.impl.comms.exception.CommsException;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.tckrunner.TckRunnerException;
import com.nokia.mj.impl.utils.Logger;

public class Installer {
    private CommsServerEndpoint iComms;
    private CommsMessage iRequest = null;

    public Installer(CommsListener aListener) {
        try {
            this.iComms = new CommsServerEndpoint();
            this.iComms.registerDefaultListener(aListener);
            this.iComms.start(10300);
        }
        catch (Exception e) {
            throw new TckRunnerException("Installer contructor failed", e);
        }
    }

    public void close() {
        try {
            this.iComms.unregisterDefaultListener();
            this.iComms.stop();
            this.iComms.destroy();
        }
        catch (Exception e) {
            Logger.LOG(18, 4, "Installer close failed", e);
        }
    }

    public void start(String[] aArgs) {
        int rc = this._launchJavaInstaller(aArgs);
        if (rc != 0) {
            throw new TckRunnerException("Starting Java Installer process failed");
        }
    }

    public void stop() {
        try {
            if (this.isReady()) {
                CommsMessage msg = new CommsMessage();
                msg.replyTo(this.iRequest);
                msg.setMessageId(501);
                msg.write(2);
                Logger.LOG(18, 4, "Stopping Java Installer");
                this.iComms.send(msg);
                this.iRequest = null;
            }
        }
        catch (CommsException ce) {
            Logger.LOG(18, 4, "Sending exit request to Java Installer failed", ce);
        }
    }

    public void saveRequest(CommsMessage aMsg) {
        this.iRequest = aMsg;
    }

    public boolean isReady() {
        return this.iRequest != null;
    }

    public void install(String aUrl) {
        try {
            CommsMessage msg = new CommsMessage();
            msg.replyTo(this.iRequest);
            msg.setMessageId(501);
            msg.write(0);
            msg.write(aUrl);
            Logger.LOG(18, 4, "Install Operation: url=" + aUrl);
            this.iComms.send(msg);
            this.iRequest = null;
        }
        catch (CommsException ce) {
            throw new TckRunnerException("Message sending to Java Installer failed", ce);
        }
    }

    public void uninstall(String aUid) {
        try {
            CommsMessage msg = new CommsMessage();
            msg.replyTo(this.iRequest);
            msg.setMessageId(501);
            msg.write(1);
            msg.write(aUid);
            Logger.LOG(18, 4, "Uninstall Operation: uid=" + aUid);
            this.iComms.send(msg);
            this.iRequest = null;
        }
        catch (CommsException ce) {
            throw new TckRunnerException("Message sending to Java Installer failed", ce);
        }
    }

    private native int _launchJavaInstaller(String[] var1);

    static {
        try {
            Jvm.loadSystemLibrary("tckrunner");
        }
        catch (Exception e) {
            Logger.ELOG(3, "Unable to load tckrunner library");
        }
    }
}

