/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.utils;

public class Attribute {
    private String iName = null;
    private String iValue = null;
    private boolean iTrusted = false;

    private Attribute() {
    }

    public Attribute(String aName, String aValue) {
        this(aName, aValue, false);
    }

    public Attribute(String aName, String aValue, boolean aTrusted) {
        if (aName == null) {
            throw new NullPointerException("Attribute name is null, value is " + aValue);
        }
        if (aValue == null) {
            throw new NullPointerException("Attribute value is null, name is " + aName);
        }
        this.iName = aName;
        this.iValue = aValue;
        this.iTrusted = aTrusted;
    }

    public String getName() {
        return this.iName;
    }

    public String getValue() {
        return this.iValue;
    }

    public int getIntValue() {
        return Integer.parseInt(this.iValue);
    }

    public boolean isTrusted() {
        return this.iTrusted;
    }

    public int hashCode() {
        return this.iName.hashCode() + this.iValue.hashCode();
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof Attribute)) {
            return false;
        }
        Attribute attr = (Attribute)aObj;
        return this.getName().equals(attr.getName()) && this.getValue().equals(attr.getValue()) && this.isTrusted() == attr.isTrusted();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append(": ").append(this.getValue());
        if (this.isTrusted()) {
            buf.append(" (trusted)");
        }
        return buf.toString();
    }
}

