/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.io.CharBuffer;
import com.ibm.oti.io.CharacterConverter;
import com.ibm.oti.io.NativeCharacterConverter;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    private InputStream in;
    CharacterConverter converter;
    private byte[] bytes = new byte[4096];
    private int pos;
    private int count;
    private int charsAvailable;
    private char[] buf = new char[4096];
    private int marklimit = -1;
    private int charCount;
    private int markpos = -1;
    private int charPos;

    public InputStreamReader(InputStream in) {
        super(in);
        this.in = in;
        String encoding = System.getProperty("microedition.encoding");
        if (encoding == null) {
            encoding = "ISO8859_1";
        }
        this.converter = CharacterConverter.getDefaultConverter(encoding);
    }

    public InputStreamReader(InputStream in, String enc) throws UnsupportedEncodingException {
        super(in);
        this.in = in;
        this.converter = CharacterConverter.getConverter(enc);
        if (this.converter == null) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bytes != null) {
                this.in.close();
                this.converter.close();
                this.converter = null;
                this.in = null;
                this.bytes = null;
                this.buf = null;
            }
        }
    }

    private int fillCharBuf() throws IOException {
        if (this.markpos == -1 || this.charPos - this.markpos >= this.marklimit) {
            int result = this.charRead(this.buf, 0, this.buf.length);
            if (result > 0) {
                this.markpos = -1;
                this.charPos = 0;
                this.charCount = result == -1 ? 0 : result;
            }
            return result;
        }
        if (this.markpos == 0 && this.marklimit > this.buf.length) {
            int newLength = this.buf.length * 2;
            if (newLength > this.marklimit) {
                newLength = this.marklimit;
            }
            char[] newbuf = new char[newLength];
            System.arraycopy((Object)this.buf, 0, (Object)newbuf, 0, this.buf.length);
            this.buf = newbuf;
        } else if (this.markpos > 0) {
            System.arraycopy((Object)this.buf, this.markpos, (Object)this.buf, 0, this.buf.length - this.markpos);
        }
        this.charPos -= this.markpos;
        this.markpos = 0;
        this.charCount = 0;
        int charsread = this.charRead(this.buf, this.charPos, this.buf.length - this.charPos);
        this.charCount = charsread == -1 ? this.charPos : this.charPos + charsread;
        return charsread;
    }

    private int fillbuf() throws IOException {
        int result;
        if (this.count > 0 && this.pos > 0) {
            this.count -= this.pos;
            if (this.count > 0) {
                System.arraycopy((Object)this.bytes, this.pos, (Object)this.bytes, 0, this.count);
            }
            this.pos = 0;
        }
        if ((result = this.in.read(this.bytes, this.count, this.bytes.length - this.count)) >= 0) {
            this.count += result;
            this.charsAvailable = 0;
        } else if (this.count > 0) {
            throw new IOException();
        }
        return result;
    }

    private int convert(char[] buffer, int offset, int length) throws IOException {
        if (this.converter instanceof NativeCharacterConverter) {
            int charsRead = length;
            if (length > 0) {
                CharBuffer charBuffer = new CharBuffer(buffer, offset, length);
                int result = this.converter.convert(this.bytes, this.pos, this.count - this.pos, charBuffer);
                if (result == -1) {
                    throw new IOException();
                }
                this.pos = result;
                charsRead = charBuffer.getPos() - offset;
            }
            return charsRead;
        }
        if (this.charsAvailable <= 0) {
            this.charsAvailable = this.converter.countChars(this.bytes, this.pos, this.count - this.pos);
        }
        if (this.charsAvailable != -1) {
            int toCopy = this.charsAvailable;
            if (toCopy > 0) {
                if (toCopy > length) {
                    toCopy = length;
                }
                this.pos = this.converter.convert(this.bytes, this.pos, buffer, offset, toCopy);
                this.charsAvailable -= toCopy;
            }
            return toCopy;
        }
        throw new IOException();
    }

    public boolean markSupported() {
        if (this.in != null) {
            return this.in.markSupported();
        }
        return false;
    }

    private boolean isOpen() {
        return this.buf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) throws IOException {
        if (readLimit >= 0) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isOpen() || this.in == null || !this.in.markSupported()) {
                    throw new IOException(Msg.getString("K0070"));
                }
                this.marklimit = readLimit;
                this.markpos = this.charPos;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.markpos == -1) {
                    throw new IOException(Msg.getString("K005c"));
                }
            } else {
                throw new IOException(Msg.getString("K0070"));
            }
            this.charPos = this.markpos;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long count) throws IOException {
        if (count < 0L) throw new IllegalArgumentException();
        Object object = this.lock;
        synchronized (object) {
            block8: {
                if (!this.isOpen()) throw new IOException(Msg.getString("K0070"));
                if (count >= 1L) break block8;
                return 0L;
            }
            if ((long)(this.charCount - this.charPos) >= count) {
                this.charPos = (int)((long)this.charPos + count);
                return count;
            }
            long read = this.charCount - this.charPos;
            this.charPos = this.charCount;
            while (read < count) {
                if (this.fillCharBuf() == -1) {
                    return read;
                }
                if ((long)(this.charCount - this.charPos) >= count - read) {
                    this.charPos = (int)((long)this.charPos + (count - read));
                    return count;
                }
                read += (long)(this.charCount - this.charPos);
                this.charPos = this.charCount;
            }
            return count;
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.isOpen()) break block5;
                if (this.charPos < this.charCount || this.fillCharBuf() != -1) {
                    return this.buf[this.charPos++];
                }
                return -1;
            }
            throw new IOException(Msg.getString("K0070"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] buffer, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int required;
            int bufLen;
            block16: {
                if (!this.isOpen()) throw new IOException(Msg.getString("K0070"));
                bufLen = buffer.length;
                if (length != 0) break block16;
                return 0;
            }
            if (offset < 0) throw new ArrayIndexOutOfBoundsException();
            if (offset > bufLen) throw new ArrayIndexOutOfBoundsException();
            if (length <= 0) throw new ArrayIndexOutOfBoundsException();
            if (length > bufLen - offset) throw new ArrayIndexOutOfBoundsException();
            if (this.charPos < this.charCount) {
                int copylength = this.charCount - this.charPos >= length ? length : this.charCount - this.charPos;
                System.arraycopy((Object)this.buf, this.charPos, (Object)buffer, offset, copylength);
                this.charPos += copylength;
                if (copylength == length) return copylength;
                if (!this.byteReady()) {
                    return copylength;
                }
                offset += copylength;
                required = length - copylength;
            } else {
                required = length;
            }
            while (true) {
                int read;
                if (this.markpos == -1 && required >= this.buf.length) {
                    read = this.charRead(buffer, offset, required);
                    if (read == -1) {
                        if (required == length) {
                            return -1;
                        }
                        int n = length - required;
                        return n;
                    }
                } else {
                    if (this.fillCharBuf() == -1) {
                        if (required == length) {
                            return -1;
                        }
                        int n = length - required;
                        return n;
                    }
                    read = this.charCount - this.charPos >= required ? required : this.charCount - this.charPos;
                    System.arraycopy((Object)this.buf, this.charPos, (Object)buffer, offset, read);
                    this.charPos += read;
                }
                if ((required -= read) == 0) {
                    return length;
                }
                if (!this.byteReady()) {
                    return length - required;
                }
                offset += read;
            }
        }
    }

    private int charRead(char[] buf, int offset, int length) throws IOException {
        int copylength = 0;
        int newoffset = offset;
        int converted = 0;
        if (this.pos < this.count) {
            converted = this.convert(buf, offset, length);
            copylength += converted;
        }
        int available = 1;
        while (copylength < length) {
            newoffset += converted;
            if (copylength > 0 && available <= 0 && (available = this.in.available()) <= 0) break;
            int read = -1;
            read = this.fillbuf();
            if (read == -1) {
                return copylength == 0 ? -1 : copylength;
            }
            available -= read;
            converted = this.convert(buf, newoffset, length - copylength);
            copylength += converted;
        }
        return copylength;
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bytes != null && this.isOpen()) {
                return this.charCount - this.charPos > 0 || this.in.available() > 0;
            }
            throw new IOException(Msg.getString("K0070"));
        }
    }

    private boolean byteReady() throws IOException {
        return this.pos < this.count || this.in.available() > 0;
    }
}

