/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.io.CharacterConverter;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class OutputStreamWriter
extends Writer {
    private OutputStream out;
    CharacterConverter converter;

    public OutputStreamWriter(OutputStream out) {
        super(out);
        this.out = out;
        String encoding = System.getProperty("microedition.encoding");
        if (encoding == null) {
            encoding = "ISO8859_1";
        }
        this.converter = CharacterConverter.getDefaultConverter(encoding);
    }

    public OutputStreamWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        super(out);
        this.out = out;
        this.converter = CharacterConverter.getConverter(enc);
        if (this.converter == null) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                byte[] bytes = this.converter.getClosingBytes();
                if (bytes.length > 0) {
                    this.writeBytes(bytes);
                }
                this.out.close();
                this.converter.close();
                this.converter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException(Msg.getString("K0073"));
            }
            this.out.flush();
        }
    }

    private boolean isOpen() {
        return this.converter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= buf.length && count >= 0 && count <= buf.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isOpen()) {
                    throw new IOException(Msg.getString("K0073"));
                }
                byte[] converted = this.converter.convert(buf, offset, count);
                this.writeBytes(converted);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private void writeBytes(byte[] converted) throws IOException {
        this.out.write(converted, 0, converted.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException(Msg.getString("K0073"));
            }
            char[] convert = new char[]{(char)oneChar};
            byte[] converted = this.converter.convert(convert, 0, 1);
            this.out.write(converted, 0, converted.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= str.length() && count >= 0 && count <= str.length() - offset) {
            Object object = this.lock;
            synchronized (object) {
                char[] convert = new char[count];
                str.getChars(offset, offset + count, convert, 0);
                this.write(convert, 0, convert.length);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }
}

