/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.OutputStream;

public class PrintStream
extends OutputStream {
    OutputStream out;
    private Object lock = new Object();
    boolean ioError = false;
    boolean autoflush = false;
    private final String lineSeparator = System.getProperty("line.separator");

    public PrintStream(OutputStream out) {
        this.out = out;
        if (out == null) {
            throw new NullPointerException();
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.ioError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            if (this.out != null) {
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (IOException iOException) {
                    this.setError();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                try {
                    this.out.flush();
                    return;
                }
                catch (IOException iOException) {}
            }
        }
        this.setError();
    }

    private void newline() {
        this.print(this.lineSeparator);
    }

    public void print(char[] charArray) {
        this.print(new String(charArray, 0, charArray.length));
    }

    public void print(char ch) {
        this.print(String.valueOf(ch));
    }

    public void print(double dnum) {
        this.print(String.valueOf(dnum));
    }

    public void print(float fnum) {
        this.print(String.valueOf(fnum));
    }

    public void print(int inum) {
        this.print(String.valueOf(inum));
    }

    public void print(long lnum) {
        this.print(String.valueOf(lnum));
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String str) {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                this.setError();
                return;
            }
            if (str == null) {
                this.print("null");
                return;
            }
            try {
                this.write(str.getBytes());
            }
            catch (IOException iOException) {
                this.setError();
            }
        }
    }

    public void print(boolean bool) {
        this.print(String.valueOf(bool));
    }

    public void println() {
        this.newline();
    }

    public void println(char[] charArray) {
        this.println(new String(charArray, 0, charArray.length));
    }

    public void println(char ch) {
        this.println(String.valueOf(ch));
    }

    public void println(double dnum) {
        this.println(String.valueOf(dnum));
    }

    public void println(float fnum) {
        this.println(String.valueOf(fnum));
    }

    public void println(int inum) {
        this.println(String.valueOf(inum));
    }

    public void println(long lnum) {
        this.println(String.valueOf(lnum));
    }

    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String str) {
        Object object = this.lock;
        synchronized (object) {
            this.print(str);
            this.newline();
        }
    }

    public void println(boolean bool) {
        this.println(String.valueOf(bool));
    }

    protected void setError() {
        this.ioError = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buffer, int offset, int count) {
        if (buffer != null) {
            if (offset >= 0 && offset <= buffer.length && count >= 0 && count <= buffer.length - offset) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.out == null) {
                        this.setError();
                        return;
                    }
                    try {
                        this.out.write(buffer, offset, count);
                        if (this.autoflush) {
                            this.flush();
                        }
                    }
                    catch (IOException iOException) {
                        this.setError();
                    }
                }
            }
            throw new ArrayIndexOutOfBoundsException(Msg.getString("K002f"));
        }
        throw new NullPointerException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneByte) {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                this.setError();
                return;
            }
            try {
                this.out.write(oneByte);
                if (this.autoflush && (oneByte & 0xFF) == 10) {
                    this.flush();
                }
            }
            catch (IOException iOException) {
                this.setError();
            }
        }
    }
}

