/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;

    private Math() {
    }

    public static double abs(double d) {
        long bits = Double.doubleToLongBits(d);
        return Double.longBitsToDouble(bits &= Long.MAX_VALUE);
    }

    public static float abs(float f) {
        int bits = Float.floatToIntBits(f);
        return Float.intBitsToFloat(bits &= Integer.MAX_VALUE);
    }

    public static int abs(int i) {
        return i >= 0 ? i : -i;
    }

    public static long abs(long l) {
        return l >= 0L ? l : -l;
    }

    public static native double ceil(double var0);

    public static native double cos(double var0);

    public static native double floor(double var0);

    public static double max(double d1, double d2) {
        if (d1 > d2) {
            return d1;
        }
        if (d1 < d2) {
            return d2;
        }
        if (d1 != d2) {
            return Double.NaN;
        }
        if (d1 == 0.0 && (Double.doubleToLongBits(d1) & Double.doubleToLongBits(d2) & Long.MIN_VALUE) == 0L) {
            return 0.0;
        }
        return d1;
    }

    public static float max(float f1, float f2) {
        if (f1 > f2) {
            return f1;
        }
        if (f1 < f2) {
            return f2;
        }
        if (f1 != f2) {
            return Float.NaN;
        }
        if (f1 == 0.0f && (Float.floatToIntBits(f1) & Float.floatToIntBits(f2) & Integer.MIN_VALUE) == 0) {
            return 0.0f;
        }
        return f1;
    }

    public static int max(int i1, int i2) {
        return i1 > i2 ? i1 : i2;
    }

    public static long max(long l1, long l2) {
        return l1 > l2 ? l1 : l2;
    }

    public static double min(double d1, double d2) {
        if (d1 > d2) {
            return d2;
        }
        if (d1 < d2) {
            return d1;
        }
        if (d1 != d2) {
            return Double.NaN;
        }
        if (d1 == 0.0 && ((Double.doubleToLongBits(d1) | Double.doubleToLongBits(d2)) & Long.MIN_VALUE) != 0L) {
            return -0.0;
        }
        return d1;
    }

    public static float min(float f1, float f2) {
        if (f1 > f2) {
            return f2;
        }
        if (f1 < f2) {
            return f1;
        }
        if (f1 != f2) {
            return Float.NaN;
        }
        if (f1 == 0.0f && ((Float.floatToIntBits(f1) | Float.floatToIntBits(f2)) & Integer.MIN_VALUE) != 0) {
            return -0.0f;
        }
        return f1;
    }

    public static int min(int i1, int i2) {
        return i1 < i2 ? i1 : i2;
    }

    public static long min(long l1, long l2) {
        return l1 < l2 ? l1 : l2;
    }

    public static native double sin(double var0);

    public static native double sqrt(double var0);

    public static native double tan(double var0);

    public static double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }
}

