/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.io.NativeCharacterConverter;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.ThreadEventHook;
import com.ibm.oti.util.ThreadEventListener;

public class Thread
implements Runnable {
    static Object activeCountLock = new Object();
    static int activeCount = 0;
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    private static int createCount = -1;
    private static final int NANOS_MAX = 999999;
    static final long NO_REF = 0L;
    long threadRef;
    long stackSize = 0L;
    private volatile boolean started;
    private String name = null;
    private int priority = 5;
    private boolean isDaemon = false;
    Object threadGroup = null;
    private Runnable runnable = null;
    private Throwable stopThrowable = null;
    private Object contextClassLoader;
    private Object localStorage;
    private Object accessControlContext;
    Object lock = new Object();
    private Object slot1;
    private Object slot2;
    private Object slot3;
    private long longSlot1;
    NativeCharacterConverter cachedConverter;
    private static boolean booting = true;

    public Thread() {
        this(Thread.newName());
    }

    private Thread(String vmName, Object vmThreadGroup, int vmPriority, boolean vmIsDaemon) {
        this.name = vmName == null ? Thread.newName() : vmName;
        this.isDaemon = vmIsDaemon;
        this.priority = vmPriority;
        Object group = null;
        this.initialize(group, null);
        if (booting) {
            booting = false;
            System.completeInitialization();
        }
    }

    void completeInitialization() {
    }

    public Thread(Runnable runnable) {
        this.name = Thread.newName();
        this.runnable = runnable;
        Thread currentThread = Thread.currentThread();
        ThreadEventListener listener = ThreadEventHook.getListener();
        if (listener != null) {
            listener.threadStarting(this, currentThread);
        }
        this.initialize(null, currentThread);
        this.setPriority(currentThread.getPriority());
    }

    public Thread(Runnable runnable, String threadName) {
        this.name = threadName;
        this.runnable = runnable;
        Thread currentThread = Thread.currentThread();
        ThreadEventListener listener = ThreadEventHook.getListener();
        if (listener != null) {
            listener.threadStarting(this, currentThread);
        }
        this.initialize(null, currentThread);
        this.setPriority(currentThread.getPriority());
    }

    public Thread(String threadName) {
        this(null, threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Object group, Thread parentThread) {
        this.threadGroup = group;
        Object object = activeCountLock;
        synchronized (object) {
            ++activeCount;
        }
    }

    public static int activeCount() {
        return activeCount;
    }

    public static native Thread currentThread();

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final int getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object = this.lock;
        synchronized (object) {
            this.interruptImpl();
        }
    }

    private native void interruptImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAlive() {
        Object object = this.lock;
        synchronized (object) {
            return this.threadRef != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDead() {
        Object object = this.lock;
        synchronized (object) {
            return this.started && this.threadRef == 0L;
        }
    }

    public final synchronized void join() throws InterruptedException {
        if (this.started) {
            while (!this.isDead()) {
                this.wait(0L);
            }
        }
    }

    private static synchronized String newName() {
        if (createCount == -1) {
            ++createCount;
            return "main";
        }
        return "Thread-" + createCount++;
    }

    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int priority) {
        if (1 <= priority && priority <= 10) {
            int finalPriority;
            this.priority = finalPriority = priority;
            Object object = this.lock;
            synchronized (object) {
                this.setPriorityImpl(finalPriority);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private native void setPriorityImpl(int var1);

    public static void sleep(long time) throws InterruptedException {
        Thread.sleep(time, 0);
    }

    static native void sleep(long var0, int var2) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalThreadStateException(Msg.getString("K0341"));
            }
            this.startImpl();
        }
    }

    private native void startImpl();

    public String toString() {
        return "Thread[" + this.name + "," + this.priority + "]";
    }

    public static native void yield();

    private void uncaughtException(Throwable e) {
        ThreadEventListener listener = ThreadEventHook.getListener();
        if (listener != null) {
            listener.uncaughtException(this, e);
        }
    }
}

