/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class Calendar {
    boolean areFieldsSet;
    protected int[] fields;
    protected boolean[] isSet = new boolean[15];
    boolean isTimeSet;
    protected long time;
    transient int lastTimeFieldSet;
    private TimeZone zone;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_WEEK = 7;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int AM = 0;
    public static final int PM = 1;
    static final int FIELD_COUNT = 15;

    protected Calendar() {
        this.fields = new int[15];
        this.setTimeZone(TimeZone.getDefault());
    }

    public boolean after(Object calendar) {
        if (!(calendar instanceof Calendar)) {
            return false;
        }
        return this.getTimeInMillis() > ((Calendar)calendar).getTimeInMillis();
    }

    public boolean before(Object calendar) {
        if (!(calendar instanceof Calendar)) {
            return false;
        }
        return this.getTimeInMillis() < ((Calendar)calendar).getTimeInMillis();
    }

    void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        if (this.areFieldsSet) {
            int i = 0;
            while (i < this.isSet.length) {
                this.isSet[i] = true;
                ++i;
            }
        } else {
            this.computeFields();
            this.areFieldsSet = true;
        }
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar cal = (Calendar)object;
        return this.getTimeInMillis() == cal.getTimeInMillis() && this.getTimeZone().equals(cal.getTimeZone());
    }

    public final int get(int field) {
        if (field >= 7) {
            this.complete();
        }
        return this.fields[field];
    }

    public static synchronized Calendar getInstance() {
        return new GregorianCalendar();
    }

    public static synchronized Calendar getInstance(TimeZone timezone) {
        return new GregorianCalendar(timezone);
    }

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    protected long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        return this.time;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public int hashCode() {
        long time = this.getTimeInMillis();
        return this.getTimeZone().hashCode() + (int)(time >> 32) + (int)time;
    }

    public final void set(int field, int value) {
        if (field == 10 || field == 11 || this.fields[field] != value) {
            this.fields[field] = value;
            this.areFieldsSet = false;
            if (field == 10 || field == 11) {
                this.lastTimeFieldSet = field;
            }
            this.isSet[field] = true;
            this.isTimeSet = false;
        }
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    protected void setTimeInMillis(long milliseconds) {
        this.time = milliseconds;
        this.isTimeSet = true;
        this.areFieldsSet = false;
        this.complete();
    }

    public void setTimeZone(TimeZone timezone) {
        this.zone = timezone;
        this.areFieldsSet = false;
    }
}

