/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.TimeZoneTable;

class GregorianCalendar
extends Calendar {
    static final int BC = 0;
    static final int AD = 1;
    private static final long gregorianCutover = -12219292800000L;
    private static final int changeYear = 1582;
    private static final int julianSkew = -1 + GregorianCalendar.julianError() - -4;
    private int dst_offset;
    static byte[] DaysInMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static int[] DaysInYear;
    private static final int CACHED_YEAR = 0;
    private static final int CACHED_MONTH = 1;
    private static final int CACHED_DATE = 2;
    private static final int CACHED_DAY_OF_WEEK = 3;
    private static final int CACHED_TZ_OFFSET = 4;
    private transient boolean isCached = false;
    private transient int[] cachedFields;
    private transient long nextMidnightMillis = 0L;
    private transient long lastMidnightMillis = 0L;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        DaysInYear = nArray;
    }

    public GregorianCalendar() {
        this.setTimeInMillis(System.currentTimeMillis());
    }

    GregorianCalendar(long milliseconds) {
        this.setTimeInMillis(milliseconds);
    }

    public GregorianCalendar(TimeZone timezone) {
        this.setTimeZone(timezone);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    GregorianCalendar(boolean ignored) {
    }

    private final int fullFieldsCalc(long time, int orgMillis, int offset, boolean getOffset) {
        long days = time / 86400000L;
        long zoneMillis = (long)orgMillis + (long)offset;
        while (zoneMillis < 0L) {
            zoneMillis += 86400000L;
            --days;
        }
        while (zoneMillis >= 86400000L) {
            zoneMillis -= 86400000L;
            ++days;
        }
        int millis = (int)zoneMillis;
        int dayOfYear = this.computeYearAndDay(days, time + (long)offset);
        int month = dayOfYear / 32;
        boolean leapYear = this.isLeapYear(this.fields[1]);
        int date = dayOfYear - this.daysInYear(leapYear, month);
        if (date > this.daysInMonth(leapYear, month)) {
            date -= this.daysInMonth(leapYear, month);
            ++month;
        }
        this.fields[7] = this.mod7(days - 3L) + 1;
        int tzOffset = offset;
        if (getOffset) {
            int dstOffset = tzOffset = this.fields[1] <= 0 ? 0 : this.getTimeZone().getOffset(1, this.fields[1], month, date, this.fields[7], millis);
            if (this.fields[1] > 0) {
                dstOffset -= offset;
            }
            this.dst_offset = dstOffset;
            if (dstOffset != 0) {
                long oldDays = days--;
                if ((millis += dstOffset) < 0) {
                    millis += 86400000;
                } else if (millis >= 86400000) {
                    millis -= 86400000;
                    ++days;
                }
                if (oldDays != days) {
                    dayOfYear = this.computeYearAndDay(days, time - (long)offset + (long)dstOffset);
                    month = dayOfYear / 32;
                    leapYear = this.isLeapYear(this.fields[1]);
                    date = dayOfYear - this.daysInYear(leapYear, month);
                    if (date > this.daysInMonth(leapYear, month)) {
                        date -= this.daysInMonth(leapYear, month);
                        ++month;
                    }
                    this.fields[7] = this.mod7(days - 3L) + 1;
                }
            }
        } else {
            int dstOffset;
            TimeZoneTable zone = (TimeZoneTable)this.getTimeZone();
            boolean inDaylight = zone.inDaylightTime(new Date(time));
            this.dst_offset = dstOffset = inDaylight ? zone.getDSTSavings() : 0;
        }
        this.fields[14] = millis % 1000;
        this.fields[13] = (millis /= 1000) % 60;
        this.fields[12] = (millis /= 60) % 60;
        this.fields[11] = (millis /= 60) % 24;
        millis /= 24;
        this.fields[9] = this.fields[11] > 11 ? 1 : 0;
        this.fields[10] = this.fields[11] % 12;
        if (this.fields[1] <= 0) {
            this.fields[1] = -this.fields[1] + 1;
        }
        this.fields[2] = month;
        this.fields[5] = date;
        return tzOffset;
    }

    private final void updateCachedFields() {
        this.fields[1] = this.cachedFields[0];
        this.fields[2] = this.cachedFields[1];
        this.fields[5] = this.cachedFields[2];
        this.fields[7] = this.cachedFields[3];
    }

    protected void computeFields() {
        this.actualComputeFields();
        int i = 0;
        while (i < 15) {
            this.isSet[i] = true;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void actualComputeFields() {
        block19: {
            block22: {
                block21: {
                    block20: {
                        if (this.cachedFields == null) {
                            this.cachedFields = new int[6];
                        }
                        savedMillis = millis = (int)(this.time % 86400000L);
                        dstOffset = this.dst_offset;
                        if (this.getTimeZone() instanceof TimeZoneTable) {
                            checkDaylightSavings = false;
                            offset = ((TimeZoneTable)this.getTimeZone()).getOffset(this.time);
                        } else {
                            checkDaylightSavings = true;
                            offset = this.getTimeZone().getRawOffset() + dstOffset;
                        }
                        newTime = this.time + (long)offset;
                        if (this.time > 0L && newTime < 0L && offset > 0) {
                            newTime = 0x7FFFFFFFFFFFFFFFL;
                        } else if (this.time < 0L && newTime > 0L && offset < 0) {
                            newTime = -9223372036854775808L;
                        }
                        if (!this.isCached) break block19;
                        if (offset == this.cachedFields[4] && offset > -86400000 && offset < 86400000) break block20;
                        this.isCached = false;
                        break block19;
                    }
                    if (millis < 0) {
                        millis += 86400000;
                    }
                    if ((millis += offset) < 0) {
                        millis += 86400000;
                    } else if (millis >= 86400000) {
                        millis -= 86400000;
                    }
                    if (newTime < this.nextMidnightMillis && newTime > this.lastMidnightMillis) break block21;
                    this.isCached = false;
                    break block19;
                }
                if (!checkDaylightSavings) ** GOTO lbl-1000
                if (!this.getTimeZone().useDaylightTime()) break block22;
                checkMillis = millis - dstOffset;
                if (checkMillis < 0) {
                    checkMillis += 86400000;
                }
                v0 = checkOffset = this.cachedFields[0] <= 0 ? 0 : this.getTimeZone().getOffset(1, this.cachedFields[0], this.cachedFields[1], this.cachedFields[2], this.cachedFields[3], checkMillis);
                if (checkOffset == offset) ** GOTO lbl-1000
                this.isCached = false;
                break block19;
            }
            if (dstOffset != 0) {
                this.isCached = false;
            } else lbl-1000:
            // 3 sources

            {
                this.updateCachedFields();
                this.fields[14] = millis % 1000;
                this.fields[13] = (millis /= 1000) % 60;
                this.fields[12] = (millis /= 60) % 60;
                this.fields[11] = (millis /= 60) % 24;
                millis /= 24;
                this.fields[9] = this.fields[11] > 11 ? 1 : 0;
                this.fields[10] = this.fields[11] % 12;
            }
        }
        if (!this.isCached) {
            newOffset = this.fullFieldsCalc(this.time, savedMillis, checkDaylightSavings != false ? this.getTimeZone().getRawOffset() : offset, checkDaylightSavings);
            if (checkDaylightSavings && newOffset != offset) {
                newTime = this.time + (long)newOffset;
                if (this.time > 0L && newTime < 0L && offset > 0) {
                    newTime = 0x7FFFFFFFFFFFFFFFL;
                } else if (this.time < 0L && newTime > 0L && offset < 0) {
                    newTime = -9223372036854775808L;
                }
            }
            offset = newOffset;
        }
        if (!this.isCached && newTime != 0x7FFFFFFFFFFFFFFFL && newTime != -9223372036854775808L && (!this.getTimeZone().useDaylightTime() || this.getTimeZone() instanceof SimpleTimeZone || this.getTimeZone() instanceof TimeZoneTable)) {
            cacheMillis = 0;
            this.cachedFields[0] = this.fields[1];
            this.cachedFields[1] = this.fields[2];
            this.cachedFields[2] = this.fields[5];
            this.cachedFields[3] = this.fields[7];
            this.cachedFields[4] = offset;
            cacheMillis += (23 - this.fields[11]) * 60 * 60 * 1000;
            cacheMillis += (59 - this.fields[12]) * 60 * 1000;
            this.nextMidnightMillis = newTime + (long)(cacheMillis += (59 - this.fields[13]) * 1000);
            cacheMillis = this.fields[11] * 60 * 60 * 1000;
            cacheMillis += this.fields[12] * 60 * 1000;
            this.lastMidnightMillis = newTime - (long)(cacheMillis += this.fields[13] * 1000);
            this.isCached = true;
        }
    }

    protected void computeTime() {
        if (this.isSet[2] && (this.fields[2] < 0 || this.fields[2] > 11)) {
            throw new IllegalArgumentException();
        }
        int hour = 0;
        if (this.isSet[11] && this.lastTimeFieldSet != 10) {
            hour = this.fields[11];
        } else if (this.isSet[10]) {
            hour = this.fields[9] * 12 + this.fields[10];
        }
        long time = hour * 3600000;
        if (this.isSet[12]) {
            time += (long)(this.fields[12] * 60000);
        }
        if (this.isSet[13]) {
            time += (long)(this.fields[13] * 1000);
        }
        if (this.isSet[14]) {
            time += (long)this.fields[14];
        }
        int year = this.isSet[1] ? this.fields[1] : 1970;
        this.lastTimeFieldSet = 0;
        time %= 86400000L;
        int month = this.isSet[2] ? this.fields[2] : 0;
        boolean leapYear = this.isLeapYear(year);
        long days = this.daysFromBaseYear(year) + (long)this.daysInYear(leapYear, month);
        if (this.isSet[5]) {
            if (this.fields[5] < 1 || this.fields[5] > this.daysInMonth(leapYear, month)) {
                throw new IllegalArgumentException();
            }
            days += (long)(this.fields[5] - 1);
        }
        if (year == 1582 && (time += days * 86400000L) >= -12219292800000L + (long)(GregorianCalendar.julianError() * 86400000)) {
            time -= (long)(GregorianCalendar.julianError() * 86400000);
        }
        int offset1 = this.getOffset(time);
        this.time = time -= (long)offset1;
        if (!this.areFieldsSet) {
            this.actualComputeFields();
            this.areFieldsSet = true;
        }
    }

    private int computeYearAndDay(long dayCount, long localTime) {
        int approxYears;
        int year = 1970;
        long days = dayCount;
        if (localTime < -12219292800000L) {
            days -= (long)julianSkew;
        }
        while ((approxYears = (int)(days / 365L)) != 0) {
            days = dayCount - this.daysFromBaseYear(year += approxYears);
        }
        if (days < 0L) {
            days = days + 365L + (long)(this.isLeapYear(--year) ? 1 : 0);
            if (year == 1582 && localTime < -12219292800000L) {
                days -= (long)GregorianCalendar.julianError();
            }
        }
        this.fields[1] = year;
        return (int)days + 1;
    }

    private long daysFromBaseYear(int year) {
        if (year >= 1970) {
            long days = (long)(year - 1970) * 365L + (long)((year - 1969) / 4);
            days = year > 1582 ? (days -= (long)((year - 1901) / 100 - (year - 1601) / 400)) : (days += (long)julianSkew);
            return days;
        }
        if (year <= 1582) {
            return (long)(year - 1970) * 365L + (long)((year - 1972) / 4) + (long)julianSkew;
        }
        return (long)(year - 1970) * 365L + (long)((year - 1972) / 4) - (long)((year - 2000) / 100) + (long)((year - 2000) / 400);
    }

    private int daysInMonth(boolean leapYear, int month) {
        if (leapYear && month == 1) {
            return DaysInMonth[month] + 1;
        }
        return DaysInMonth[month];
    }

    private int daysInYear(boolean leapYear, int month) {
        if (leapYear && month > 1) {
            return DaysInYear[month] + 1;
        }
        return DaysInYear[month];
    }

    int getOffset(long localTime) {
        int approxYears;
        TimeZone timeZone = this.getTimeZone();
        if (!(timeZone instanceof TimeZoneTable) && !timeZone.useDaylightTime()) {
            return timeZone.getRawOffset();
        }
        long dayCount = localTime / 86400000L;
        int millis = (int)(localTime % 86400000L);
        if (millis < 0) {
            millis += 86400000;
            --dayCount;
        }
        int year = 1970;
        long days = dayCount;
        if (localTime < -12219292800000L) {
            days -= (long)julianSkew;
        }
        while ((approxYears = (int)(days / 365L)) != 0) {
            days = dayCount - this.daysFromBaseYear(year += approxYears);
        }
        if (days < 0L) {
            days = days + 365L + (long)(this.isLeapYear(--year) ? 1 : 0);
            if (year == 1582 && localTime < -12219292800000L) {
                days -= (long)GregorianCalendar.julianError();
            }
        }
        if (year <= 0) {
            return timeZone.getRawOffset();
        }
        int dayOfYear = (int)days + 1;
        int month = dayOfYear / 32;
        boolean leapYear = this.isLeapYear(year);
        int date = dayOfYear - this.daysInYear(leapYear, month);
        if (date > this.daysInMonth(leapYear, month)) {
            date -= this.daysInMonth(leapYear, month);
            ++month;
        }
        int dayOfWeek = this.mod7(dayCount - 3L) + 1;
        int offset = timeZone.getOffset(1, year, month, date, dayOfWeek, millis);
        return offset;
    }

    boolean isLeapYear(int year) {
        if (year > 1582) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    private static int julianError() {
        return 10;
    }

    private int mod7(long num1) {
        int rem = (int)(num1 % 7L);
        if (num1 < 0L && rem < 0) {
            return rem + 7;
        }
        return rem;
    }

    public void setTimeZone(TimeZone timezone) {
        super.setTimeZone(timezone);
        this.isCached = false;
    }
}

