/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.TimeZones;

public abstract class TimeZone {
    private static Hashtable AvailableZones;
    private static TimeZone Default;
    static final TimeZone GMT;

    static {
        GMT = new SimpleTimeZone(0, "GMT");
    }

    private static void initializeAvailable() {
        TimeZone[] zones = TimeZones.getTimeZones();
        AvailableZones = new Hashtable((zones.length + 1) * 4 / 3);
        AvailableZones.put(GMT.getID(), GMT);
        int i = 0;
        while (i < zones.length) {
            AvailableZones.put(zones[i].getID(), zones[i]);
            ++i;
        }
    }

    public static synchronized String[] getAvailableIDs() {
        if (AvailableZones == null) {
            TimeZone.initializeAvailable();
        }
        int length = AvailableZones.size();
        String[] answer = new String[length];
        Enumeration zones = AvailableZones.elements();
        int i = 0;
        while (i < length) {
            answer[i] = ((TimeZone)zones.nextElement()).getID();
            ++i;
        }
        return answer;
    }

    public static synchronized TimeZone getDefault() {
        if (Default == null) {
            TimeZone.setDefault(null);
        }
        return Default;
    }

    public String getID() {
        return null;
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public static synchronized TimeZone getTimeZone(String name) {
        TimeZone zone;
        if (AvailableZones == null) {
            TimeZone.initializeAvailable();
        }
        if ((zone = (TimeZone)AvailableZones.get(name)) == null) {
            char sign;
            if (name.startsWith("GMT") && name.length() > 3 && ((sign = name.charAt(3)) == '+' || sign == '-')) {
                int[] position = new int[1];
                String formattedName = TimeZone.formatTimeZoneName(name, 4);
                if (formattedName == null) {
                    return GMT;
                }
                int hour = TimeZone.parseNumber(formattedName, 4, position);
                if (hour < 0 || hour > 23) {
                    return GMT;
                }
                int index = position[0];
                if (index != -1) {
                    int raw = hour * 3600000;
                    if (index < formattedName.length() && formattedName.charAt(index) == ':') {
                        int minute = TimeZone.parseNumber(formattedName, index + 1, position);
                        if (position[0] == -1 || minute < 0 || minute > 59) {
                            return GMT;
                        }
                        raw += minute * 60000;
                    } else if (hour >= 30 || index > 6) {
                        raw = hour / 100 * 3600000 + hour % 100 * 60000;
                    }
                    if (sign == '-') {
                        raw = -raw;
                    }
                    return new SimpleTimeZone(raw, formattedName);
                }
            }
            zone = GMT;
        }
        return zone;
    }

    private static String formatTimeZoneName(String name, int offset) {
        StringBuffer buf = new StringBuffer();
        int index = offset;
        int length = name.length();
        buf.append(name.substring(0, offset));
        int colonIndex = -1;
        while (index < length) {
            char c = name.charAt(index);
            if ('0' <= c && c <= '9') {
                buf.append(c);
                if (length - (index + 1) == 2) {
                    if (colonIndex != -1) {
                        return null;
                    }
                    colonIndex = buf.length();
                    buf.append(':');
                }
            } else if (c == ':') {
                if (colonIndex != -1) {
                    return null;
                }
                colonIndex = buf.length();
                buf.append(':');
            } else {
                return null;
            }
            ++index;
        }
        if (colonIndex == -1) {
            colonIndex = buf.length();
            buf.append(":00");
        }
        if (colonIndex == 5) {
            buf.insert(4, '0');
        }
        return buf.toString();
    }

    private static int parseNumber(String string, int offset, int[] position) {
        int digit;
        int index = offset;
        int length = string.length();
        int result = 0;
        while (index < length && (digit = Character.digit(string.charAt(index), 10)) != -1) {
            ++index;
            result = result * 10 + digit;
        }
        position[0] = index == offset ? -1 : index;
        return result;
    }

    private static void setDefault(TimeZone timezone) {
        if (timezone != null) {
            Default = timezone;
            return;
        }
        String zone = System.getProperty("user.timezone");
        if (zone == null) {
            int[] tzinfo = new int[10];
            boolean[] isCustomTimeZone = new boolean[1];
            String zoneId = TimeZone.getCustomTimeZone(tzinfo, isCustomTimeZone);
            if (isCustomTimeZone[0]) {
                switch (tzinfo[1]) {
                    case 0: {
                        Default = new SimpleTimeZone(tzinfo[0], zoneId);
                        break;
                    }
                    default: {
                        Default = new SimpleTimeZone(tzinfo[0], zoneId, tzinfo[5], tzinfo[4], tzinfo[3], tzinfo[2], tzinfo[9], tzinfo[8], tzinfo[7], tzinfo[6], tzinfo[1]);
                        break;
                    }
                }
            } else {
                Default = TimeZone.getTimeZone(zoneId);
            }
        } else {
            Default = TimeZone.getTimeZone(zone);
        }
    }

    public abstract boolean useDaylightTime();

    private static native String getCustomTimeZone(int[] var0, boolean[] var1);
}

