/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.pki;

import com.nokia.mj.impl.rt.support.Jvm;
import javax.microedition.pki.UserCredentialManagerException;
import javax.microedition.securityservice.CMSMessageSignatureServiceException;

public final class UserCredentialManager {
    public static final String ALGORITHM_DSA = "1.2.840.10040.4.1";
    public static final String ALGORITHM_RSA = "1.2.840.113549.1.1";
    public static final int KEY_USAGE_AUTHENTICATION = 0;
    public static final int KEY_USAGE_NON_REPUDIATION = 1;
    private static UserCredentialManager sInstance;
    private int iManagerHandle = this._createUCManager();
    private static final int NO_ERROR = 0;
    private static final int NOT_COMPLETED = 1;
    private static final int ERR_NOT_FOUND = -1;
    private static final int ERR_CANCEL = -3;
    private static final int ERR_NOT_SUPPORTED = -5;
    private static final int ERR_ARGUMENT = -6;
    private static final String ERR_ARGUMENT_STRING = "Argument is out of range";
    private static final int ERR_ALREADY_EXISTS = -11;
    private static final int ERR_NOT_READY = -18;
    private static final int ERR_CORRUPT = -20;
    private static final int ERR_LOCKED = -22;
    private static final String ERR_LOCKED_STRING = "False PIN code: not authorized to access certificate store";
    private static final int ERR_BAD_NAME = -28;
    private static final String ERR_BAD_NAME_STRING = "Certificate Display Name must be in standard format";
    private static final int ERR_KEY_USAGE = -11007;
    private static final String ERR_KEY_USAGE_STRING = "Invalid keyUsage type";
    private static final int ERR_SE_NOT_FOUND = -4001;
    private static final int ERR_SE_NO_KEYS = -4002;
    private static final int ERR_ALREADY_REGISTERED = -4003;
    private static final String ERR_ALREADY_REGISTERED_STRING = "Certificate Display Name or PKIPath is already registered";
    private static final int ERR_INVALID_CA_NAME = -4004;
    private static final String ERR_INVALID_CA_NAME_STRING = "Invalid CA name";
    private static final int ERR_INVALID_CHARACTERS_IN_CA_NAME = -4005;
    private static final String ERR_INVALID_CHARACTERS_IN_CA_NAME_STRING = "Invalid characters in CA name";
    private static final String ERR_UNEXPECTED = "Unexpected error: ";

    public static final boolean addCredential(String aCertDisplayName, byte[] aPkiPath, String aUri) throws UserCredentialManagerException {
        if (aCertDisplayName == null || aCertDisplayName == "" || aPkiPath == null) {
            throw new IllegalArgumentException("Certificate Display Name or PKIPath is null, or empty string is passed as argument");
        }
        int error = sInstance._addCredential(UserCredentialManager.sInstance.iManagerHandle, aCertDisplayName, aPkiPath);
        boolean retVal = false;
        switch (error) {
            case 0: {
                retVal = true;
                break;
            }
            case -3: 
            case 1: {
                break;
            }
            case -4003: {
                throw new IllegalArgumentException(ERR_ALREADY_REGISTERED_STRING);
            }
            case -6: {
                throw new IllegalArgumentException(ERR_ARGUMENT_STRING);
            }
            case -28: {
                throw new IllegalArgumentException(ERR_BAD_NAME_STRING);
            }
            default: {
                throw new UserCredentialManagerException(0);
            }
        }
        return retVal;
    }

    public static final byte[] generateCSR(String aNameInfo, String aAlgorithm, int aKeyLen, int aKeyUsage, String aSecurityElementID, String aSecurityElementPrompt, boolean aForceKeyGen) throws UserCredentialManagerException, CMSMessageSignatureServiceException {
        if (aNameInfo == "" || aAlgorithm == "" || aKeyLen <= 0) {
            throw new IllegalArgumentException(ERR_ARGUMENT_STRING);
        }
        String nameInfo = null;
        nameInfo = aNameInfo == null ? "" : aNameInfo;
        if (aForceKeyGen) {
            throw new UserCredentialManagerException(1);
        }
        int[] error = new int[1];
        byte[] retVal = sInstance._generateCSR(UserCredentialManager.sInstance.iManagerHandle, nameInfo, aAlgorithm, aKeyLen, aKeyUsage, aSecurityElementID, aSecurityElementPrompt, error);
        switch (error[0]) {
            case 0: {
                break;
            }
            case -3: {
                retVal = null;
                break;
            }
            case -4002: 
            case -20: 
            case -11: {
                throw new UserCredentialManagerException(2);
            }
            case -4001: {
                throw new UserCredentialManagerException(4);
            }
            case -11007: {
                throw new IllegalArgumentException(ERR_KEY_USAGE_STRING);
            }
            case -6: {
                throw new IllegalArgumentException(ERR_ARGUMENT_STRING);
            }
            case -4005: {
                throw new IllegalArgumentException(ERR_INVALID_CHARACTERS_IN_CA_NAME_STRING);
            }
            case -4004: {
                throw new IllegalArgumentException(ERR_INVALID_CA_NAME_STRING);
            }
            case -22: {
                throw new SecurityException(ERR_LOCKED_STRING);
            }
            default: {
                throw new OutOfMemoryError(ERR_UNEXPECTED + error[0]);
            }
        }
        return retVal;
    }

    public static final boolean removeCredential(String aCertDisplayName, byte[] aIssuerAndSerialNumber, String aSecurityElementID, String aSecurityElementPrompt) throws UserCredentialManagerException {
        if (aCertDisplayName == null || aCertDisplayName == "" || aIssuerAndSerialNumber == null) {
            throw new IllegalArgumentException("Certificate Display Name or IssuerAndSerialNumber is null, or an empty string is passed as argument");
        }
        int error = sInstance._removeCredential(UserCredentialManager.sInstance.iManagerHandle, aCertDisplayName, aIssuerAndSerialNumber, aSecurityElementID, aSecurityElementPrompt);
        boolean retVal = false;
        switch (error) {
            case 0: {
                retVal = true;
                break;
            }
            case -3: 
            case 1: {
                break;
            }
            case -1: {
                throw new UserCredentialManagerException(5);
            }
            case -6: {
                throw new IllegalArgumentException(ERR_ARGUMENT_STRING);
            }
            case -4001: {
                throw new UserCredentialManagerException(4);
            }
            default: {
                throw new OutOfMemoryError(ERR_UNEXPECTED + error);
            }
        }
        return retVal;
    }

    private UserCredentialManager() {
        if (this.iManagerHandle <= 0) {
            throw new OutOfMemoryError(ERR_UNEXPECTED + this.iManagerHandle);
        }
    }

    private native int _createUCManager();

    private native int _addCredential(int var1, String var2, byte[] var3);

    private native int _removeCredential(int var1, String var2, byte[] var3, String var4, String var5);

    private native byte[] _generateCSR(int var1, String var2, String var3, int var4, int var5, String var6, String var7, int[] var8);

    static {
        try {
            Jvm.loadSystemLibrary("javasatsa");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sInstance = new UserCredentialManager();
    }
}

