/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.securityservice;

import com.nokia.mj.impl.pki.SignaturePermission;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Jvm;
import java.io.UnsupportedEncodingException;
import javax.microedition.pki.UserCredentialManagerException;
import javax.microedition.securityservice.CMSMessageSignatureServiceException;

public final class CMSMessageSignatureService {
    public static final int SIG_INCLUDE_CERTIFICATE = 2;
    public static final int SIG_INCLUDE_CONTENT = 1;
    private static final String MIDP_PERMISSION = "javax.microedition.securityservice.CMSMessageSignatureService";
    private static CMSMessageSignatureService sInstance;
    private int iServiceHandle = this._createSignatureService();
    private static final int NO_ERROR = 0;
    private static final int NOT_FOUND = -1;
    private static final int ERR_ARGUMENT = -6;
    private static final String ERR_ARGUMENT_STRING = "Argument is out of range";
    private static final int ERR_LOCKED = -22;
    private static final String ERR_LOCKED_STRING = "False PIN code: not authorized to access certificate store";
    private static final String ERR_NULL_CA_NAME_STRING = "CA name is null or empty";
    private static final int ERR_INVALID_CA_NAME = -4004;
    private static final String ERR_INVALID_CA_NAME_STRING = "Invalid CA name";
    private static final int ERR_INVALID_CHARACTERS_IN_CA_NAME = -4005;
    private static final String ERR_INVALID_CHARACTERS_IN_CA_NAME_STRING = "Invalid characters in CA name";
    private static final String STRING_ENCODING = "UTF-8";
    private static final String ERR_UNEXPECTED = "Unexpected error: ";

    public static final byte[] authenticate(byte[] aByteArrayToAuthenticate, int aOptions, String[] aCaNames, String aSecurityElementPrompt) throws CMSMessageSignatureServiceException, UserCredentialManagerException {
        if (null == aCaNames) {
            aCaNames = new String[]{};
        }
        for (int i = 0; i < aCaNames.length; ++i) {
            if (aCaNames[i] != null && aCaNames[i] != "") continue;
            throw new IllegalArgumentException(ERR_NULL_CA_NAME_STRING);
        }
        if (aOptions < 0 || aOptions > 3) {
            throw new IllegalArgumentException("Options argument out of range in authenticate()");
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        SignaturePermission permission = new SignaturePermission("pki://*", "authenticate");
        appUtils.checkPermission(permission);
        int[] error = new int[1];
        byte[] retVal = sInstance._authenticate(CMSMessageSignatureService.sInstance.iServiceHandle, aByteArrayToAuthenticate, aOptions, aCaNames, aSecurityElementPrompt, false, error);
        CMSMessageSignatureService.checkError(error[0]);
        return retVal;
    }

    public static final byte[] authenticate(String aStringToAuthenticate, int aOptions, String[] aCaNames, String aSecurityElementPrompt) throws CMSMessageSignatureServiceException, UserCredentialManagerException {
        if (null == aCaNames) {
            aCaNames = new String[]{};
        }
        for (int i = 0; i < aCaNames.length; ++i) {
            if (aCaNames[i] != null && aCaNames[i] != "") continue;
            throw new IllegalArgumentException(ERR_NULL_CA_NAME_STRING);
        }
        if (aOptions < 0 || aOptions > 3) {
            throw new IllegalArgumentException("Options argument out of range in authenticate()");
        }
        int[] error = new int[1];
        byte[] bytesToAuthenticate = null;
        try {
            bytesToAuthenticate = aStringToAuthenticate.getBytes(STRING_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new CMSMessageSignatureServiceException(1);
        }
        byte[] retVal = sInstance._authenticate(CMSMessageSignatureService.sInstance.iServiceHandle, bytesToAuthenticate, aOptions, aCaNames, aSecurityElementPrompt, true, error);
        CMSMessageSignatureService.checkError(error[0]);
        return retVal;
    }

    public static final byte[] sign(String aStringToSign, int aOptions, String[] aCaNames, String aSecurityElementPrompt) throws CMSMessageSignatureServiceException, UserCredentialManagerException {
        if (null == aCaNames) {
            aCaNames = new String[]{};
        }
        for (int i = 0; i < aCaNames.length; ++i) {
            if (aCaNames[i] != null && aCaNames[i] != "") continue;
            throw new IllegalArgumentException(ERR_NULL_CA_NAME_STRING);
        }
        if (aOptions < 0 || aOptions > 3) {
            throw new IllegalArgumentException("Options argument out of range in sign(");
        }
        int[] error = new int[1];
        byte[] bytesToSign = null;
        try {
            bytesToSign = aStringToSign.getBytes(STRING_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new CMSMessageSignatureServiceException(1);
        }
        byte[] retVal = sInstance._sign(CMSMessageSignatureService.sInstance.iServiceHandle, bytesToSign, aOptions, aCaNames, aSecurityElementPrompt, error);
        CMSMessageSignatureService.checkError(error[0]);
        return retVal;
    }

    private CMSMessageSignatureService() {
        if (this.iServiceHandle <= 0) {
            throw new OutOfMemoryError(ERR_UNEXPECTED + this.iServiceHandle);
        }
    }

    private static void checkError(int aError) throws CMSMessageSignatureServiceException {
        switch (aError) {
            case 0: {
                break;
            }
            case -1: {
                throw new CMSMessageSignatureServiceException(8);
            }
            case -6: {
                throw new IllegalArgumentException(ERR_ARGUMENT_STRING);
            }
            case -22: {
                throw new SecurityException(ERR_LOCKED_STRING);
            }
            case -4004: {
                throw new IllegalArgumentException(ERR_INVALID_CA_NAME_STRING);
            }
            case -4005: {
                throw new IllegalArgumentException(ERR_INVALID_CHARACTERS_IN_CA_NAME_STRING);
            }
            default: {
                throw new CMSMessageSignatureServiceException(1);
            }
        }
    }

    private native int _createSignatureService();

    private native byte[] _authenticate(int var1, byte[] var2, int var3, String[] var4, String var5, boolean var6, int[] var7);

    private native byte[] _sign(int var1, byte[] var2, int var3, String[] var4, String var5, int[] var6);

    static {
        try {
            Jvm.loadSystemLibrary("javasatsa");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sInstance = new CMSMessageSignatureService();
    }
}

