/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.sensor;

import javax.microedition.sensor.Condition;

public final class RangeCondition
implements Condition {
    private final double lowerLimit;
    private final double upperLimit;
    private final String lowerOp;
    private final String upperOp;
    private final IsMetStrategy strategy;

    public RangeCondition(double lowerLimit, String lowerOp, double upperLimit, String upperOp) {
        if (upperLimit < lowerLimit) {
            throw new IllegalArgumentException(upperLimit + "<" + lowerLimit);
        }
        if (lowerLimit == upperLimit && (lowerOp != "ge" || upperOp != "le")) {
            throw new IllegalArgumentException(lowerOp + " == " + upperOp);
        }
        if (!(lowerOp == "gt" | lowerOp == "ge")) {
            throw new IllegalArgumentException("lowerOp is invalid:" + lowerOp);
        }
        if (!(upperOp == "lt" | upperOp == "le")) {
            throw new IllegalArgumentException("upperOp is invalid:" + upperOp);
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.upperOp = upperOp;
        this.lowerOp = lowerOp;
        this.strategy = IsMetStrategy.getStrategy(lowerOp, upperOp);
    }

    public final double getLowerLimit() {
        return this.lowerLimit;
    }

    public final String getLowerOp() {
        return this.lowerOp;
    }

    public final double getUpperLimit() {
        return this.upperLimit;
    }

    public final String getUpperOp() {
        return this.upperOp;
    }

    public boolean isMet(double doubleValue) {
        return this.strategy.isMet(this.lowerLimit, doubleValue, this.upperLimit);
    }

    public boolean isMet(Object value) {
        return false;
    }

    private static class HalfClosedRangeStrategy
    extends IsMetStrategy {
        private HalfClosedRangeStrategy() {
        }

        public boolean isMet(double lowerLimit, double value, double upperLimit) {
            return lowerLimit < value && value <= upperLimit;
        }
    }

    private static class HalfOpenRangeStrategy
    extends IsMetStrategy {
        private HalfOpenRangeStrategy() {
        }

        public boolean isMet(double lowerLimit, double value, double upperLimit) {
            return lowerLimit <= value && value < upperLimit;
        }
    }

    private static class OpenRangeStrategy
    extends IsMetStrategy {
        private OpenRangeStrategy() {
        }

        public boolean isMet(double lowerLimit, double value, double upperLimit) {
            return lowerLimit < value && value < upperLimit;
        }
    }

    private static class ClosedRangeStrategy
    extends IsMetStrategy {
        private ClosedRangeStrategy() {
        }

        public boolean isMet(double lowerLimit, double value, double upperLimit) {
            return lowerLimit <= value && value <= upperLimit;
        }
    }

    private static abstract class IsMetStrategy {
        private IsMetStrategy() {
        }

        static IsMetStrategy getStrategy(String lowerOp, String upperOp) {
            if (lowerOp == "gt" && upperOp == "lt") {
                return new OpenRangeStrategy();
            }
            if (lowerOp == "ge" && upperOp == "le") {
                return new ClosedRangeStrategy();
            }
            if (lowerOp == "gt" && upperOp == "le") {
                return new HalfClosedRangeStrategy();
            }
            if (lowerOp == "ge" && upperOp == "lt") {
                return new HalfOpenRangeStrategy();
            }
            return null;
        }

        abstract boolean isMet(double var1, double var3, double var5);
    }
}

