/*
* Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  javastoragetables
*
*/


#ifndef JAVASTORAGETABLES_H
#define JAVASTORAGETABLES_H

namespace java
{
namespace storage
{

const char APPLICATION_PACKAGE[] = "CREATE TABLE APPLICATION_PACKAGE ( \
ID VARCHAR(12) PRIMARY KEY, PACKAGE_NAME VARCHAR(50), VENDOR VARCHAR(50), \
VERSION VARCHAR(10), ROOT_PATH VARCHAR(256), MEDIA_ID INT(10), \
INITIAL_SIZE INT(15), JAD_PATH VARCHAR(256), JAR_PATH VARCHAR(256), \
JAD_URL VARCHAR, JAR_URL VARCHAR, ACCESS_POINT VARCHAR(256), CONTENT_INFO INT(2), \
CONTENT_ID VARCHAR(256));";

const char APPLICATION[] = "CREATE TABLE APPLICATION ( ID VARCHAR(12) \
PRIMARY KEY, PACKAGE_ID VARCHAR(12), NAME VARCHAR(50), MAIN_CLASS VARCHAR(50), \
AUTORUN INT(2));";

const char APPLICATION_PACKAGE_ATTRIBUTES[] = "CREATE TABLE \
APPLICATION_PACKAGE_ATTRIBUTES ( ID VARCHAR(12), NAME VARCHAR(50), \
VALUE VARCHAR(600), TRUSTED INT(2), PRIMARY KEY(ID, NAME));";

const char MIDP_PACKAGE[] = "CREATE TABLE MIDP_PACKAGE ( ID VARCHAR(12) \
PRIMARY KEY, TYPE VARCHAR(50), SECURITY_DOMAIN VARCHAR(50), \
SECURITY_DOMAIN_CATEGORY VARCHAR(10), HASH VARCHAR(40), CERT_HASH VARCHAR(10), \
RMS VARCHAR(256), VALID_CERTS VARCHAR(30), ON_SCREEN_KEYPAD INT(2), \
SECURITY_WARNINGS INT(2));";

const char MIDP_PERMISSIONS[] = "CREATE TABLE MIDP_PERMISSIONS ( ID \
VARCHAR(12), CLASS VARCHAR(100), NAME VARCHAR(50), ACTION VARCHAR(50), \
FUNCTION_GROUP VARCHAR(50));";

const char MIDP_FUNC_GRP_SETTINGS[] = "CREATE TABLE MIDP_FUNCTION_GRP_SETTINGS \
( ID VARCHAR(12), FUNCTION_GROUP VARCHAR(50), ALLOWED_SETTINGS INT(3), \
CURRENT_SETTING INT(3), BLANKET_PROMPT INT(3), PRIMARY KEY(ID, \
FUNCTION_GROUP));";

const char PUSH_REGISTRATIONS[] = "CREATE TABLE PUSH_REGISTRATIONS \
( ID VARCHAR(12), URL VARCHAR(256) PRIMARY KEY, NAME VARCHAR(50), \
FILTER VARCHAR(100), REGISTRATION_TYPE INT(1));";

const char ALARM_REGISTRATIONS[] = "CREATE TABLE ALARM_REGISTRATIONS \
( ID VARCHAR(12) PRIMARY KEY, ALARM_TIME VARCHAR(50));";

const char RUNTIME_SETTINGS[] = "CREATE TABLE RUNTIME_SETTINGS ( \
EXTENSIONS VARCHAR PRIMARY KEY);";

const char OTA_STATUS[] = "CREATE TABLE OTA_STATUS ( ID VARCHAR(12), \
CREATION_TIME VARCHAR(50), TYPE INT(2), OTA_CODE INT(4), URL VARCHAR(256), \
LATEST_RETRY_TIME VARCHAR(50), RETRY_COUNT INT(2));";

const char PREINSTALL[] = "CREATE TABLE PREINSTALL ( NAME VARCHAR(50), \
VENDOR VARCHAR(50), VERSION VARCHAR(50), INSTALL_STATE INT(1));";

const char JAVA_SOFTNOTE[] = "CREATE TABLE JAVA_SOFTNOTE ( \
SOFTNOTE_MIDLET_ID VARCHAR(12), SOFTNOTE_ID INT(10), \
SOFTNOTE_PRIMARY_TEXT VARCHAR(256), SOFTNOTE_SECONDARY_TEXT VARCHAR(256), \
SOFTNOTE_IMAGE_PATH VARCHAR(256), PRIMARY KEY(SOFTNOTE_MIDLET_ID,SOFTNOTE_ID));";

}    // java
}    // storage

#endif // JAVASTORAGETABLES_H

