/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class SimpleRMS
extends MIDlet
implements CommandListener {
    private Display display = Display.getDisplay((MIDlet)this);
    private Form fmMain = new Form("SimpleRMS v1.0");
    private Command cmdStore;
    private Command cmdExit;
    private StringItem bField;
    private StringItem tField;
    private TextField input;
    private int value = 0;
    private Store store = new Store();

    public SimpleRMS() {
        this.cmdStore = new Command("Store", 2, 1);
        this.cmdExit = new Command("Exit", 7, 1);
        this.value = this.store.readRecord();
        this.bField = new StringItem("Value: ", String.valueOf(this.value));
        this.input = new TextField("New value: ", "", 6, 2);
        this.fmMain.append((Item)this.bField);
        this.fmMain.append((Item)this.input);
        this.fmMain.addCommand(this.cmdStore);
        this.fmMain.addCommand(this.cmdExit);
        this.fmMain.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.fmMain);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdStore) {
            if (!this.input.getString().equals("")) {
                this.value = Integer.parseInt(this.input.getString());
                this.input.delete(0, this.input.size());
                this.store.changeRecord(this.value);
                this.bField.setText(String.valueOf(this.value));
            }
        } else if (command == this.cmdExit) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
    }

    class Store {
        private RecordStore rs = null;
        static final String REC_STORE = "TestDB_SimpleRMS";

        public void openRecStore() {
            try {
                this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
                if (this.rs.getNumRecords() == 0) {
                    this.writeRecord(0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void closeRecStore() {
            try {
                this.rs.closeRecordStore();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void deleteRecStore() {
            if (RecordStore.listRecordStores() != null) {
                try {
                    RecordStore.deleteRecordStore((String)REC_STORE);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void writeRecord(int n) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                for (int i = 0; i < 5000; ++i) {
                    dataOutputStream.writeInt(n);
                }
                dataOutputStream.flush();
                this.rs.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int readRecord() {
            int n = 0;
            try {
                RecordEnumeration recordEnumeration = this.rs.enumerateRecords(null, null, false);
                ByteArrayInputStream byteArrayInputStream = null;
                DataInputStream dataInputStream = null;
                while (recordEnumeration.hasNextElement()) {
                    byteArrayInputStream = new ByteArrayInputStream(recordEnumeration.nextRecord());
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    n = dataInputStream.readInt();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return n;
        }

        public void changeRecord(int n) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                RecordEnumeration recordEnumeration = this.rs.enumerateRecords(null, null, false);
                for (int i = 0; i < 5000; ++i) {
                    dataOutputStream.writeInt(n);
                }
                dataOutputStream.flush();
                while (recordEnumeration.hasNextElement()) {
                    this.rs.setRecord(recordEnumeration.nextRecordId(), byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Store() {
            this.openRecStore();
        }
    }
}

