/*
 * Decompiled with CFR 0.152.
 */
package bcexchanger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMItem;

public class AddressBook {
    public static Vector[] getNamesUIDLists() throws Exception {
        Vector[] namesUIDs = new Vector[]{new Vector(), new Vector()};
        PIM pim = PIM.getInstance();
        String[] listNames = pim.listPIMLists(1);
        if (listNames.length == 0) {
            throw new RuntimeException("No available Contact lists");
        }
        ContactList contactList = (ContactList)pim.openPIMList(1, 1, listNames[0]);
        if (!contactList.isSupportedField(117)) {
            throw new RuntimeException("Required field (UID) is not supported by the address book");
        }
        Vector<Integer> fieldOrder = new Vector<Integer>();
        fieldOrder.addElement(new Integer(105));
        fieldOrder.addElement(new Integer(0));
        fieldOrder.addElement(new Integer(1));
        fieldOrder.addElement(new Integer(106));
        Vector<Integer> supportedFieldOrder = new Vector<Integer>();
        int i = 0;
        while (i < fieldOrder.size()) {
            Integer field = (Integer)fieldOrder.elementAt(i);
            if (contactList.isSupportedField(field.intValue())) {
                supportedFieldOrder.addElement(field);
            }
            ++i;
        }
        if (supportedFieldOrder.size() == 0) {
            throw new RuntimeException("Required name field is not supported by the address book");
        }
        Enumeration e = contactList.items();
        while (e.hasMoreElements()) {
            Contact contact = (Contact)e.nextElement();
            try {
                String name = null;
                Enumeration e2 = supportedFieldOrder.elements();
                while (e2.hasMoreElements()) {
                    try {
                        int field = (Integer)e2.nextElement();
                        if (field == 106) {
                            String[] nameArray = contact.getStringArray(field, 0);
                            if (nameArray != null) {
                                name = nameArray[0];
                            }
                        } else {
                            name = contact.getString(field, 0);
                        }
                        if (name != null && name != "") break;
                        name = null;
                    }
                    catch (Exception exception) {
                        name = null;
                    }
                }
                if (name == null) continue;
                String uid = contact.getString(117, 0);
                namesUIDs[0].addElement(name);
                namesUIDs[1].addElement(uid);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return namesUIDs;
    }

    public static byte[] getVCard(String uid) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ContactList contactList = (ContactList)PIM.getInstance().openPIMList(1, 1);
        Contact searchPattern = contactList.createContact();
        searchPattern.addString(117, 0, uid);
        Enumeration e = contactList.items((PIMItem)searchPattern);
        if (!e.hasMoreElements()) {
            throw new RuntimeException("No contacts found");
        }
        Contact contact = (Contact)e.nextElement();
        PIM.getInstance().toSerialFormat((PIMItem)contact, (OutputStream)os, "UTF-8", "VCARD/2.1");
        return os.toByteArray();
    }

    public static void setVCard(byte[] vCard) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(vCard);
        PIMItem[] items = PIM.getInstance().fromSerialFormat((InputStream)in, "UTF-8");
        ContactList contactList = (ContactList)PIM.getInstance().openPIMList(1, 3);
        Contact newContact = contactList.importContact((Contact)items[0]);
        newContact.commit();
    }
}

