/*
 * Decompiled with CFR 0.152.
 */
package bcexchanger;

import bcexchanger.AddressBook;
import bcexchanger.Storage;
import bcexchanger.comm.ExchangeListener;
import bcexchanger.comm.ExchangerComm;
import bcexchanger.comm.ExchangerCommImpl;
import bcexchanger.ui.AddressBookScreen;
import bcexchanger.ui.AlertMessage;
import bcexchanger.ui.MainScreen;
import bcexchanger.ui.ProgressScreen;
import bcexchanger.ui.Screen;
import bcexchanger.ui.ServiceListScreen;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class BCExchangerMIDlet
extends MIDlet
implements ExchangeListener {
    private boolean commIsInitialized = false;
    private ExchangerComm comm;
    private int selectedServiceIndex;
    private MainScreen scr = new MainScreen(this);

    public void changeScreen(Screen screen) {
        screen.makeActive();
    }

    public void quit() {
        if (this.comm != null) {
            this.comm.cancelWaiting();
        }
        try {
            this.destroyApp(true);
            this.notifyDestroyed();
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            // empty catch block
        }
    }

    public void serviceSelected(int index) {
        this.selectedServiceIndex = index;
    }

    public void initComm() {
        if (!this.commIsInitialized) {
            this.comm = new ExchangerCommImpl(this);
            this.commIsInitialized = true;
        }
    }

    public ExchangerComm getExchanger() {
        return this.comm;
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }

    protected void startApp() throws MIDletStateChangeException {
        String uid = null;
        try {
            uid = Storage.getBCUID();
        }
        catch (Exception e) {
            this.changeScreen(new AlertMessage(this, "Cannot use the persistent storage. Application will exit"));
            return;
        }
        if (uid == null) {
            this.changeScreen(new AddressBookScreen(this));
        } else {
            this.changeScreen(this.scr);
        }
    }

    protected void pauseApp() {
    }

    public void onInquiryComplete(int code) {
        if (code == 0) {
            String text = "Searching for Business Card Exchange service...";
            this.changeScreen(new ProgressScreen(this, text));
        } else if (code == 2) {
            this.changeScreen(new AlertMessage(this, "Errors during inquiry", this.scr));
        } else if (code == 1) {
            this.changeScreen(new AlertMessage(this, "Inquiry is canceled", this.scr));
        } else {
            throw new RuntimeException("Internal error #26");
        }
    }

    public void onServiceDiscoveryComplete(int code) {
        if (code == 0) {
            String text = "Sending own business card...";
            this.changeScreen(new ProgressScreen(this, text));
        } else if (code == 3) {
            this.changeScreen(new AlertMessage(this, "Cannot find Business card exchange service on the devices", this.scr));
        } else if (code == 2) {
            this.changeScreen(new AlertMessage(this, "Errors during service discovery", this.scr));
        } else if (code == 1) {
            this.changeScreen(new AlertMessage(this, "Service discovery is canceled", this.scr));
        } else {
            throw new RuntimeException("Internal error #27");
        }
    }

    public synchronized int resolveMultipleServices(Vector friendlyNames) throws InterruptedException {
        this.changeScreen(new ServiceListScreen(this, friendlyNames));
        this.wait();
        return this.selectedServiceIndex;
    }

    public byte[] getOwnBC() throws Exception {
        byte[] vCard = null;
        try {
            String uid = Storage.getBCUID();
            vCard = AddressBook.getVCard(uid);
        }
        catch (Exception e) {
            throw new Exception("getOwnBC did not succeed");
        }
        return vCard;
    }

    public void onSendComplete(int code) {
        if (code == 0) {
            String text = "Send was successful!";
            this.changeScreen(new AlertMessage(this, text, this.scr));
        } else if (code == 1) {
            this.changeScreen(new AlertMessage(this, "Send is canceled ", this.scr));
        } else {
            this.changeScreen(new AlertMessage(this, "Errors during sending ", this.scr));
        }
    }

    public void onReceiveComplete(int code) {
        if (code == 0) {
            this.changeScreen(new AlertMessage(this, "Receiving was successful!", this.scr));
        } else if (code == 1) {
            this.changeScreen(new AlertMessage(this, "Receiving is canceled ", this.scr));
        } else {
            this.changeScreen(new AlertMessage(this, "Errors during receiving ", this.scr));
        }
    }

    public void onReceiveBC(byte[] vCard) throws Exception {
        AddressBook.setVCard(vCard);
    }

    public synchronized void unblock() {
        this.notify();
    }

    public void onGetComplete(int code) {
    }

    public void onPutComplete(int code) {
    }

    public void onServerError() {
        this.changeScreen(new AlertMessage(this, "Fatal Bluetooth error. Application will exit"));
    }
}

