/*
 * Decompiled with CFR 0.152.
 */
package bcexchanger.comm;

import bcexchanger.comm.ExchangerState;
import bcexchanger.comm.ExchangerStateParent;
import bcexchanger.comm.InquiryState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.Operation;

public class IdleState
extends ExchangerState {
    public IdleState(ExchangerStateParent _parent) {
        super(_parent);
    }

    public int onGet(Operation op) {
        try {
            OutputStream out = op.openOutputStream();
            byte[] vCard = this.parent.getListener().getOwnBC();
            int vlen = vCard.length;
            byte[] tmpBuf = new byte[vlen + 4];
            System.arraycopy(vCard, 0, tmpBuf, 4, vlen);
            tmpBuf[0] = (byte)(vlen >>> 24 & 0xFF);
            tmpBuf[1] = (byte)(vlen >>> 16 & 0xFF);
            tmpBuf[2] = (byte)(vlen >>> 8 & 0xFF);
            tmpBuf[3] = (byte)(vlen >>> 0 & 0xFF);
            out.write(tmpBuf);
            op.close();
            return 160;
        }
        catch (Exception e) {
            return 208;
        }
    }

    public int onPut(Operation op) {
        try {
            InputStream in = op.openInputStream();
            byte[] fullResult = null;
            byte[] buf = new byte[256];
            ByteArrayOutputStream bout = new ByteArrayOutputStream(2048);
            int len = in.read(buf);
            while (len >= 0) {
                bout.write(buf, 0, len);
                len = in.read(buf);
            }
            fullResult = bout.toByteArray();
            ByteArrayInputStream bin = new ByteArrayInputStream(fullResult);
            DataInputStream din = new DataInputStream(bin);
            int size = din.readInt();
            byte[] vCard = new byte[size];
            din.read(vCard);
            op.close();
            this.parent.getListener().onReceiveBC(vCard);
            return 160;
        }
        catch (Exception e) {
            return 208;
        }
    }

    public void startSending(int oper) throws Exception {
        this.parent.setState(new InquiryState(this.parent, oper));
    }

    public void cancelSending() {
    }
}

