/*
 * Decompiled with CFR 0.152.
 */
package bcexchanger.comm;

import bcexchanger.comm.ExchangerState;
import bcexchanger.comm.ExchangerStateParent;
import bcexchanger.comm.IdleState;
import bcexchanger.comm.ServiceDiscoveryState;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.obex.Operation;

public class InquiryState
extends ExchangerState
implements DiscoveryListener {
    private DiscoveryAgent agent;
    private Vector remoteDevices;
    private int operation = ServiceDiscoveryState.GET;

    public InquiryState(ExchangerStateParent _parent, int oper) throws IOException {
        super(_parent);
        this.operation = oper;
        this.remoteDevices = new Vector();
        LocalDevice local = LocalDevice.getLocalDevice();
        this.agent = local.getDiscoveryAgent();
        this.agent.startInquiry(10390323, (DiscoveryListener)this);
    }

    public void startSending(int op) throws IOException {
        throw new IOException("Inquiry is in progress. Inquiry has to be canceled before starting new sending process");
    }

    public void cancelSending() {
        this.agent.cancelInquiry((DiscoveryListener)this);
    }

    public void deviceDiscovered(RemoteDevice dev, DeviceClass devClass) {
        this.remoteDevices.addElement(dev);
    }

    public void inquiryCompleted(int code) {
        try {
            int completionCode = 2;
            switch (code) {
                case 0: {
                    completionCode = 0;
                    break;
                }
                case 5: {
                    completionCode = 1;
                    break;
                }
                case 7: {
                    completionCode = 2;
                }
            }
            this.parent.getListener().onInquiryComplete(completionCode);
            if (code == 0) {
                this.parent.setState(new ServiceDiscoveryState(this.parent, this.remoteDevices, this.operation));
            } else {
                this.parent.setState(new IdleState(this.parent));
            }
        }
        catch (Exception e) {
            this.parent.setState(new IdleState(this.parent));
        }
    }

    public void servicesDiscovered(int arg0, ServiceRecord[] arg1) {
        throw new RuntimeException("Internal error #4: InquiryState.servicesDiscovered() should not be called");
    }

    public void serviceSearchCompleted(int arg0, int arg1) {
        throw new RuntimeException("Internal error #5: InquiryState.serviceSearchCompleted() should not be called");
    }

    public int onGet(Operation op) {
        return 201;
    }

    public int onPut(Operation op) {
        return 201;
    }
}

