/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.serversocket;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.socket.Socket;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class Connection
extends Socket
implements CreateConnection,
StreamConnectionNotifier {
    static final int DEFAULT_TIMEOUT = 8000;
    private boolean closed = false;
    private int timeout = 0;
    private int backlog = 50;

    public Connection() {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
    }

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
        return this;
    }

    private void setParameters(String spec, String[][] equates, int access, boolean throwTimeout) throws IOException {
        int[] result = new int[1];
        int i = 0;
        while (i < equates.length) {
            String key = equates[i][0];
            equates[i][0] = equates[i][0].toLowerCase();
            if (ConnectionUtil.intParam("so_timeout", equates[i], 1, result)) {
                this.timeout = result[0];
            } else if (ConnectionUtil.intParam("backlog", equates[i], 1, result)) {
                this.backlog = result[0];
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", key));
            }
            ++i;
        }
        if (throwTimeout && this.timeout == 0) {
            this.timeout = 8000;
        }
        result[0] = 0;
        Socket.parseURL(spec, result, false, true);
        try {
            this.listenStreamImpl(result[0], this.backlog);
        }
        catch (IOException e) {
            this.socketClose();
            throw e;
        }
        this.socketOpen();
    }

    public void close() throws IOException {
        this.closed = true;
        this.socketClose();
    }

    public StreamConnection acceptAndOpen() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        com.ibm.oti.connection.socket.Connection socket = new com.ibm.oti.connection.socket.Connection(3);
        this.acceptStreamSocketImpl(socket, this.timeout);
        return socket;
    }

    native void listenStreamImpl(int var1, int var2) throws IOException;

    native void acceptStreamSocketImpl(Socket var1, int var2) throws IOException;

    public String getLocalAddress() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        boolean addressZero = true;
        int i = 0;
        while (i < this.address.length) {
            if (this.address[i] != 0) {
                addressZero = false;
                break;
            }
            ++i;
        }
        if (addressZero) {
            String hostName = System.getProperty("microedition.hostname");
            if (hostName != null) {
                if (hostName.length() > 0 && hostName.charAt(0) >= '0' && hostName.charAt(0) <= '9') {
                    return hostName;
                }
                try {
                    this.address = Socket.getHostByName(hostName);
                }
                catch (IOException iOException) {}
            }
            addressZero = true;
            int i2 = 0;
            while (i2 < this.address.length) {
                if (this.address[i2] != 0) {
                    addressZero = false;
                    break;
                }
                ++i2;
            }
            if (addressZero) {
                this.address = new byte[4];
                this.address[0] = 127;
                this.address[1] = 0;
                this.address[2] = 0;
                this.address[3] = 1;
            }
        }
        return Socket.addressToString(this.address);
    }

    public int getLocalPort() throws IOException {
        if (this.closed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.localport;
    }
}

