/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryListener;

public class DeviceInquiryThread
extends Thread {
    private BluetoothStack stack;
    private DeviceInquiryRunnable inquiryRunnable;
    private int accessCode;
    private DiscoveryListener listener;
    private BluetoothStateException startException;
    private boolean started = false;
    private boolean terminated = false;
    private Object inquiryStartedEvent = new Object();
    private static int threadNumber;

    private static synchronized int nextThreadNum() {
        return threadNumber++;
    }

    private DeviceInquiryThread(BluetoothStack stack, DeviceInquiryRunnable inquiryRunnable, int accessCode, DiscoveryListener listener) {
        super("DeviceInquiryThread-" + DeviceInquiryThread.nextThreadNum());
        this.stack = stack;
        this.inquiryRunnable = inquiryRunnable;
        this.accessCode = accessCode;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startInquiry(BluetoothStack stack, DeviceInquiryRunnable inquiryRunnable, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        DeviceInquiryThread t = new DeviceInquiryThread(stack, inquiryRunnable, accessCode, listener);
        UtilsJavaSE.threadSetDaemon(t);
        Object object = t.inquiryStartedEvent;
        synchronized (object) {
            t.start();
            while (!t.started && !t.terminated) {
                try {
                    t.inquiryStartedEvent.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
                if (t.startException == null) continue;
                throw t.startException;
            }
        }
        DebugLog.debug("startInquiry return", t.started);
        return t.started;
    }

    public static int getConfigDeviceInquiryDuration() {
        return BlueCoveImpl.getConfigProperty("bluecove.inquiry.duration", 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int discType = 7;
        try {
            BlueCoveImpl.setThreadBluetoothStack(this.stack);
            discType = this.inquiryRunnable.runDeviceInquiry(this, this.accessCode, this.listener);
        }
        catch (BluetoothStateException e) {
            DebugLog.debug("runDeviceInquiry throw", e);
            this.startException = e;
        }
        catch (Throwable e) {
            DebugLog.error("runDeviceInquiry", e);
        }
        finally {
            this.terminated = true;
            Object e = this.inquiryStartedEvent;
            synchronized (e) {
                this.inquiryStartedEvent.notifyAll();
            }
            DebugLog.debug("runDeviceInquiry ends");
            if (this.started) {
                Utils.j2meUsagePatternDellay();
                this.listener.inquiryCompleted(discType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceInquiryStartedCallback() {
        DebugLog.debug("deviceInquiryStartedCallback");
        this.started = true;
        Object object = this.inquiryStartedEvent;
        synchronized (object) {
            this.inquiryStartedEvent.notifyAll();
        }
    }
}

