/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.UtilsJavaSE;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.UUID;

public abstract class Utils {
    private static final String blueCoveImplPackage = Utils.getPackage((class$com$intel$bluetooth$MicroeditionConnector == null ? (class$com$intel$bluetooth$MicroeditionConnector = Utils.class$("com.intel.bluetooth.MicroeditionConnector")) : class$com$intel$bluetooth$MicroeditionConnector).getName());
    static /* synthetic */ Class class$com$intel$bluetooth$MicroeditionConnector;

    private Utils() {
    }

    private static String getPackage(String className) {
        int pStart = className.lastIndexOf(46);
        if (pStart == -1) {
            return "";
        }
        return className.substring(0, pStart);
    }

    public static byte[] UUIDToByteArray(String uuidStringValue) {
        byte[] uuidValue = new byte[16];
        if (uuidStringValue.indexOf(45) != -1) {
            throw new NumberFormatException("The '-' character is not allowed in UUID: " + uuidStringValue);
        }
        for (int i = 0; i < 16; ++i) {
            uuidValue[i] = (byte)Integer.parseInt(uuidStringValue.substring(i * 2, i * 2 + 2), 16);
        }
        return uuidValue;
    }

    public static byte[] UUIDToByteArray(UUID uuid) {
        return Utils.UUIDToByteArray(uuid.toString());
    }

    public static String UUIDByteArrayToString(byte[] uuidValue) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < uuidValue.length; ++i) {
            buf.append(Integer.toHexString(uuidValue[i] >> 4 & 0xF));
            buf.append(Integer.toHexString(uuidValue[i] & 0xF));
        }
        return buf.toString();
    }

    static long UUIDTo32Bit(UUID uuid) {
        if (uuid == null) {
            return -1L;
        }
        String str = uuid.toString().toUpperCase();
        int shortIdx = str.indexOf("00001000800000805F9B34FB");
        if (shortIdx != -1 && shortIdx + "00001000800000805F9B34FB".length() == str.length()) {
            return Long.parseLong(str.substring(0, shortIdx), 16);
        }
        return -1L;
    }

    static boolean is32Bit(UUID uuid) {
        return Utils.UUIDTo32Bit(uuid) != -1L;
    }

    public static int securityOpt(boolean authenticate, boolean encrypt) {
        int security = 0;
        if (authenticate) {
            security = encrypt ? 2 : 1;
        } else if (encrypt) {
            throw new IllegalArgumentException("Illegal encrypt configuration");
        }
        return security;
    }

    static boolean isStringSet(String str) {
        return str != null && str.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String loadString(InputStream inputstream) {
        if (inputstream == null) {
            return null;
        }
        try {
            byte[] buf = new byte[256];
            int len = inputstream.read(buf);
            String string = new String(buf, 0, len);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                inputstream.close();
            }
            catch (IOException iOException) {}
        }
    }

    static String getResourceProperty(Class owner, String resourceName) {
        try {
            int cr;
            String value = Utils.loadString(owner.getResourceAsStream("/" + resourceName));
            if (value != null && (cr = value.indexOf(10)) != -1) {
                value = value.substring(0, cr - 1);
            }
            return value;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static byte[] clone(byte[] value) {
        if (value == null) {
            return null;
        }
        int length = value.length;
        byte[] bClone = new byte[length];
        System.arraycopy((Object)value, 0, (Object)bClone, 0, length);
        return bClone;
    }

    public static Vector clone(Enumeration en) {
        Vector copy = new Vector();
        while (en.hasMoreElements()) {
            copy.addElement(en.nextElement());
        }
        return copy;
    }

    static String newStringUTF8(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (IllegalArgumentException e) {
            return new String(bytes);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    static byte[] getUTF8Bytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (IllegalArgumentException e) {
            return str.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }

    static String newStringASCII(byte[] bytes) {
        try {
            return new String(bytes, "US-ASCII");
        }
        catch (IllegalArgumentException e) {
            return new String(bytes);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    static byte[] getASCIIBytes(String str) {
        try {
            return str.getBytes("US-ASCII");
        }
        catch (IllegalArgumentException e) {
            return str.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }

    static Object[] vector2toArray(Vector vector, Object[] anArray) {
        vector.copyInto(anArray);
        return anArray;
    }

    public static String toHexString(long l) {
        StringBuffer buf = new StringBuffer();
        String lo = Integer.toHexString((int)l);
        if (l > 0xFFFFFFFFL) {
            String hi = Integer.toHexString((int)(l >> 32));
            buf.append(hi);
            for (int i = lo.length(); i < 8; ++i) {
                buf.append('0');
            }
        }
        buf.append(lo);
        return buf.toString();
    }

    static void j2meUsagePatternDellay() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static TimerThread schedule(long delay, Runnable run) {
        TimerThread t = new TimerThread(delay, run);
        UtilsJavaSE.threadSetDaemon(t);
        t.start();
        return t;
    }

    public static void isLegalAPICall(Vector fqcnSet) throws Error {
    }

    public static long hexStringToLong(String str) {
        return Long.parseLong(str, 16);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TimerThread
    extends Thread {
        long delay;
        Runnable run;

        public TimerThread(long delay, Runnable run) {
            this.delay = delay;
            this.run = run;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                this.run.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

