/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothServerConnection;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.UtilsJavaSE;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXServerOperation;
import com.intel.bluetooth.obex.OBEXServerOperationGet;
import com.intel.bluetooth.obex.OBEXServerOperationPut;
import com.intel.bluetooth.obex.OBEXSessionBase;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.io.StreamConnection;
import javax.obex.Authenticator;
import javax.obex.ServerRequestHandler;

class OBEXServerSessionImpl
extends OBEXSessionBase
implements Runnable,
BluetoothServerConnection {
    private ServerRequestHandler handler;
    private OBEXServerOperation operation;
    private boolean closeRequested = false;
    private volatile boolean delayClose = false;
    private Object canCloseEvent = new Object();
    private Object stackID;
    private Thread handlerThread;
    private static int threadNumber;
    static int errorCount;
    static /* synthetic */ Class class$com$intel$bluetooth$obex$OBEXServerSessionImpl;

    private static synchronized int nextThreadNum() {
        return threadNumber++;
    }

    OBEXServerSessionImpl(StreamConnection connection, ServerRequestHandler handler, Authenticator authenticator, OBEXConnectionParams obexConnectionParams) throws IOException {
        super(connection, obexConnectionParams);
        this.requestSent = true;
        this.handler = handler;
        this.authenticator = authenticator;
        this.stackID = BlueCoveImpl.getCurrentThreadBluetoothStackID();
        this.handlerThread = new Thread(this, "OBEXServerSessionThread-" + OBEXServerSessionImpl.nextThreadNum());
        UtilsJavaSE.threadSetDaemon(this.handlerThread);
    }

    void startSessionHandlerThread() {
        this.handlerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.yield();
        try {
            if (this.stackID != null) {
                BlueCoveImpl.setThreadBluetoothStackID(this.stackID);
            }
            while (!this.isClosed() && !this.closeRequested) {
                if (this.handleRequest()) continue;
                return;
            }
        }
        catch (Throwable e) {
            Class clazz = class$com$intel$bluetooth$obex$OBEXServerSessionImpl == null ? (class$com$intel$bluetooth$obex$OBEXServerSessionImpl = OBEXServerSessionImpl.class$("com.intel.bluetooth.obex.OBEXServerSessionImpl")) : class$com$intel$bluetooth$obex$OBEXServerSessionImpl;
            synchronized (clazz) {
                ++errorCount;
            }
            if (this.isConnected) {
                DebugLog.error("OBEXServerSession error", e);
            } else {
                DebugLog.debug("OBEXServerSession error", e);
            }
        }
        finally {
            DebugLog.debug("OBEXServerSession ends");
            try {
                super.close();
            }
            catch (IOException e) {
                DebugLog.debug("OBEXServerSession close error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.closeRequested = true;
        while (this.delayClose) {
            Object object = this.canCloseEvent;
            synchronized (object) {
                try {
                    if (this.delayClose) {
                        this.canCloseEvent.wait(700L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.delayClose = false;
            }
        }
        if (!this.isClosed()) {
            DebugLog.debug("OBEXServerSession close");
            if (this.operation != null) {
                this.operation.close();
                this.operation = null;
            }
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean handleRequest() throws IOException {
        DebugLog.debug("OBEXServerSession handleRequest");
        this.delayClose = false;
        try {
            b = this.readPacket();
        }
        catch (EOFException e) {
            if (this.isConnected) {
                throw e;
            }
            DebugLog.debug("OBEXServerSession got EOF");
            this.close();
            return false;
        }
        this.delayClose = true;
        try {
            opcode = b[0] & 255;
            v0 = finalPacket = (opcode & 128) != 0;
            if (finalPacket) {
                DebugLog.debug("OBEXServerSession got operation finalPacket");
            }
            switch (opcode) {
                case 128: {
                    this.processConnect(b);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 129: {
                    this.processDisconnect(b);
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 2: 
                case 130: {
                    this.processPut(b, finalPacket);
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 5: 
                case 133: {
                    this.processSetPath(b, finalPacket);
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                case 255: {
                    this.processAbort();
                    ** break;
lbl38:
                    // 1 sources

                    break;
                }
                case 3: 
                case 131: {
                    this.processGet(b, finalPacket);
                    ** break;
lbl42:
                    // 1 sources

                    break;
                }
                default: {
                    this.writePacket(209, null);
                    break;
                }
            }
        }
        finally {
            this.delayClose = false;
        }
        var2_4 = this.canCloseEvent;
        synchronized (var2_4) {
            this.canCloseEvent.notifyAll();
        }
        return true;
    }

    private void processConnect(byte[] b) throws IOException {
        int rc;
        DebugLog.debug("Connect operation");
        if (b[3] != 16) {
            throw new IOException("Unsupported client OBEX version " + b[3]);
        }
        if (b.length < 7) {
            throw new IOException("Corrupted OBEX data");
        }
        int requestedMTU = OBEXUtils.bytesToShort(b[5], b[6]);
        if (requestedMTU < 255) {
            throw new IOException("Invalid MTU " + requestedMTU);
        }
        this.mtu = requestedMTU;
        DebugLog.debug("mtu selected", this.mtu);
        OBEXHeaderSetImpl replyHeaders = OBEXServerSessionImpl.createOBEXHeaderSetImpl();
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 7);
        if (!this.handleAuthenticationResponse(requestHeaders)) {
            rc = 193;
        } else {
            this.handleAuthenticationChallenge(requestHeaders, replyHeaders);
            rc = 208;
            try {
                rc = this.handler.onConnect(requestHeaders, replyHeaders);
            }
            catch (Throwable e) {
                DebugLog.error("onConnect", e);
            }
        }
        byte[] connectResponse = new byte[]{16, 0, OBEXUtils.hiByte(this.obexConnectionParams.mtu), OBEXUtils.loByte(this.obexConnectionParams.mtu)};
        this.writePacketWithFlags(rc, connectResponse, replyHeaders);
        if (rc == 160) {
            this.isConnected = true;
        }
    }

    boolean handleAuthenticationResponse(OBEXHeaderSetImpl incomingHeaders) throws IOException {
        return this.handleAuthenticationResponse(incomingHeaders, this.handler);
    }

    private boolean validateConnection() throws IOException {
        if (this.isConnected) {
            return true;
        }
        this.writePacket(192, null);
        return false;
    }

    private void processDisconnect(byte[] b) throws IOException {
        DebugLog.debug("Disconnect operation");
        if (!this.validateConnection()) {
            return;
        }
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 3);
        OBEXHeaderSetImpl replyHeaders = OBEXServerSessionImpl.createOBEXHeaderSetImpl();
        int rc = 160;
        try {
            this.handler.onDisconnect(requestHeaders, replyHeaders);
        }
        catch (Throwable e) {
            rc = 211;
            DebugLog.error("onDisconnect", e);
        }
        this.isConnected = false;
        this.writePacket(rc, replyHeaders);
    }

    private void processDelete(OBEXHeaderSetImpl requestHeaders) throws IOException {
        DebugLog.debug("Delete operation");
        OBEXHeaderSetImpl replyHeaders = OBEXServerSessionImpl.createOBEXHeaderSetImpl();
        this.handleAuthenticationChallenge(requestHeaders, replyHeaders);
        int rc = 160;
        try {
            rc = this.handler.onDelete(requestHeaders, replyHeaders);
        }
        catch (Throwable e) {
            rc = 211;
            DebugLog.error("onDelete", e);
        }
        this.writePacket(rc, replyHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPut(byte[] b, boolean finalPacket) throws IOException {
        DebugLog.debug("Put/Delete operation");
        if (!this.validateConnection()) {
            return;
        }
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 3);
        if (!this.handleAuthenticationResponse(requestHeaders, this.handler)) {
            this.writePacket(193, null);
            return;
        }
        if (finalPacket && !requestHeaders.hasIncommingData()) {
            this.processDelete(requestHeaders);
            return;
        }
        DebugLog.debug("Put operation");
        this.operation = new OBEXServerOperationPut(this, requestHeaders, finalPacket);
        try {
            int rc = 160;
            try {
                rc = this.handler.onPut(this.operation);
            }
            catch (Throwable e) {
                rc = 211;
                DebugLog.error("onPut", e);
            }
            if (!this.operation.isAborted) {
                this.operation.writeResponse(rc);
            }
        }
        finally {
            this.operation.close();
            this.operation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGet(byte[] b, boolean finalPacket) throws IOException {
        DebugLog.debug("Get operation");
        if (!this.validateConnection()) {
            return;
        }
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 3);
        if (!this.handleAuthenticationResponse(requestHeaders, this.handler)) {
            this.writePacket(193, null);
            return;
        }
        this.operation = new OBEXServerOperationGet(this, requestHeaders, finalPacket);
        try {
            int rc = 160;
            try {
                rc = this.handler.onGet(this.operation);
            }
            catch (Throwable e) {
                rc = 211;
                DebugLog.error("onGet", e);
            }
            if (!this.operation.isAborted) {
                this.operation.writeResponse(rc);
            }
        }
        finally {
            this.operation.close();
            this.operation = null;
        }
    }

    private void processAbort() throws IOException {
        DebugLog.debug("Abort operation");
        if (!this.validateConnection()) {
            return;
        }
        if (this.operation != null) {
            this.operation.isAborted = true;
            this.operation.close();
            this.operation = null;
        }
        this.writePacket(160, null);
    }

    private void processSetPath(byte[] b, boolean finalPacket) throws IOException {
        DebugLog.debug("SetPath operation");
        if (!this.validateConnection()) {
            return;
        }
        if (b.length < 5) {
            throw new IOException("Corrupted OBEX data");
        }
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 5);
        boolean backup = (b[3] & 1) != 0;
        boolean create = (b[3] & 2) == 0;
        DebugLog.debug("setPath backup", backup);
        DebugLog.debug("setPath create", create);
        if (!this.handleAuthenticationResponse(requestHeaders, this.handler)) {
            this.writePacket(193, null);
            return;
        }
        OBEXHeaderSetImpl replyHeaders = OBEXServerSessionImpl.createOBEXHeaderSetImpl();
        this.handleAuthenticationChallenge(requestHeaders, replyHeaders);
        int rc = 160;
        try {
            rc = this.handler.onSetPath(requestHeaders, replyHeaders, backup, create);
        }
        catch (Throwable e) {
            rc = 211;
            DebugLog.error("onSetPath", e);
        }
        this.writePacket(rc, replyHeaders);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        errorCount = 0;
    }
}

