/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.iapinfo;

import com.nokia.mid.iapinfo.APNControl;
import com.nokia.mid.iapinfo.AccessPoint;
import com.nokia.mid.iapinfo.CommDBException;
import com.nokia.mid.iapinfo.ConnectionPreferencesTable;
import com.nokia.mid.iapinfo.DestinationNetwork;
import com.nokia.mid.iapinfo.IAPInfo;
import com.nokia.mid.iapinfo.IAPInfoException;
import com.nokia.mid.iapinfo.IAPTable;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;
import java.util.Vector;

class IAPInfoImpl
extends IAPInfo {
    private IAPTable iIAPTable = null;

    public IAPInfoImpl() throws IAPInfoException {
        try {
            this.iIAPTable = new IAPTable();
        }
        catch (CommDBException e) {
            e.printStackTrace();
            throw new IAPInfoException(e.getMessage());
        }
    }

    public AccessPoint[] getAccessPoints() throws IAPInfoException {
        AccessPoint[] _ac = null;
        try {
            this.iIAPTable.open();
            int _nr_of_access_points = this.iIAPTable.getRecordCount();
            _ac = new AccessPoint[_nr_of_access_points];
            for (int i = 0; i < _nr_of_access_points; ++i) {
                AccessPoint _c;
                _ac[i] = _c = new AccessPoint(this.iIAPTable.iRecordId, this.iIAPTable.iRecordName, this.iIAPTable.iBearerType, this.iIAPTable.iServiceType);
                if (i == _nr_of_access_points - 1) continue;
                this.iIAPTable.nextRecord();
            }
            this.iIAPTable.close();
        }
        catch (CommDBException _exception) {
            this.iIAPTable.close();
            throw new IAPInfoException(_exception.getMessage());
        }
        return _ac;
    }

    public AccessPoint getAccessPoint(int aID) throws IAPInfoException {
        AccessPoint _ac = null;
        try {
            this.iIAPTable.open();
            int _ret = this.iIAPTable.findById(aID);
            if (_ret != -3) {
                _ac = new AccessPoint(this.iIAPTable.iRecordId, this.iIAPTable.iRecordName, this.iIAPTable.iBearerType, this.iIAPTable.iServiceType);
            }
            this.iIAPTable.close();
        }
        catch (CommDBException _exception) {
            this.iIAPTable.close();
            throw new IAPInfoException(_exception.getMessage());
        }
        return _ac;
    }

    public AccessPoint getAccessPoint(String aName) throws IAPInfoException {
        if (aName == null) {
            throw new IAPInfoException("Parameter is NULL");
        }
        AccessPoint _ac = null;
        try {
            this.iIAPTable.open();
            int _ret = this.iIAPTable.findByName(aName);
            if (_ret != -3) {
                _ac = new AccessPoint(this.iIAPTable.iRecordId, this.iIAPTable.iRecordName, this.iIAPTable.iBearerType, this.iIAPTable.iServiceType);
            }
            this.iIAPTable.close();
        }
        catch (CommDBException _exception) {
            this.iIAPTable.close();
            throw new IAPInfoException(_exception.getMessage());
        }
        return _ac;
    }

    public AccessPoint getLastUsedAccessPoint() throws IAPInfoException {
        APNControl _control = new APNControl();
        int _lastIAP = _control.getLastIAP();
        AccessPoint _ac = null;
        int _nr_of_access_points = 0;
        try {
            this.iIAPTable.open();
            _nr_of_access_points = this.iIAPTable.getRecordCount();
            for (int i = 0; i < _nr_of_access_points; ++i) {
                if (this.iIAPTable.iRecordId == _lastIAP) {
                    _ac = new AccessPoint(this.iIAPTable.iRecordId, this.iIAPTable.iRecordName, this.iIAPTable.iBearerType, this.iIAPTable.iServiceType);
                    break;
                }
                if (i == _nr_of_access_points - 1) continue;
                this.iIAPTable.nextRecord();
            }
            this.iIAPTable.close();
        }
        catch (CommDBException _exception) {
            this.iIAPTable.close();
            throw new IAPInfoException(_exception.getMessage());
        }
        return _ac;
    }

    public DestinationNetwork[] getDestinationNetworks() throws IAPInfoException {
        DestinationNetwork[] _array = null;
        try {
            String[] _obj = IAPInfoImpl._getDestinationNetworks();
            if (_obj != null) {
                _array = new DestinationNetwork[_obj.length];
                for (int i = 0; i < _obj.length; ++i) {
                    _array[i] = this.parse(_obj[i]);
                }
            }
        }
        catch (IAPInfoException exception) {
            String message = exception.getMessage();
            int i = message.indexOf(58);
            throw new IAPInfoException(Integer.valueOf(message.substring(i + 2, message.length())), exception.getMessage());
        }
        return _array;
    }

    DestinationNetwork parse(String aString) {
        int index_1 = aString.indexOf(59);
        int dest_id = Integer.parseInt(aString.substring(0, index_1));
        int index_2 = aString.lastIndexOf(59);
        String dest_name = aString.substring(index_1 + 1, index_2);
        String _iaps = aString.substring(index_2 + 1, aString.length());
        int[] _iap_ids = this.parseString(_iaps);
        DestinationNetwork _dn = new DestinationNetwork(dest_id, dest_name, _iap_ids);
        return _dn;
    }

    public DestinationNetwork getDestinationNetwork(int aID) throws IAPInfoException {
        DestinationNetwork _network = null;
        try {
            String _returnedString = IAPInfoImpl._getDestinationNetworkById(aID);
            if (_returnedString != null) {
                _network = this.parse(_returnedString);
            }
        }
        catch (IAPInfoException exception) {
            String message = exception.getMessage();
            int i = message.indexOf(58);
            throw new IAPInfoException(Integer.valueOf(message.substring(i + 2, message.length())), exception.getMessage());
        }
        return _network;
    }

    public DestinationNetwork getDestinationNetwork(String aName) throws IAPInfoException {
        DestinationNetwork _network = null;
        try {
            String _returnedString = IAPInfoImpl._getDestinationNetworkByName(aName);
            if (_returnedString != null) {
                _network = this.parse(_returnedString);
            }
        }
        catch (IAPInfoException exception) {
            String message = exception.getMessage();
            int i = message.indexOf(58);
            throw new IAPInfoException(Integer.valueOf(message.substring(i + 2, message.length())), exception.getMessage());
        }
        return _network;
    }

    public AccessPoint[] getConnectionPreferences() throws IAPInfoException {
        ConnectionPreferencesTable _prefTable = null;
        AccessPoint[] _ac = null;
        try {
            int i;
            _prefTable = new ConnectionPreferencesTable();
            _prefTable.open();
            int recNr = _prefTable.getRecordCount();
            HelperObject[] hp = new HelperObject[recNr];
            for (int i2 = 0; i2 < recNr; ++i2) {
                HelperObject _o = new HelperObject();
                _o.Id = _prefTable.iDefaultIAP;
                _o.Pref = _prefTable.iRanking;
                hp[i2] = _o;
                if (i2 == recNr - 1) continue;
                _prefTable.nextRecord();
            }
            boolean stop = false;
            while (!stop) {
                stop = true;
                for (int j = 0; j < hp.length - 1; ++j) {
                    if (hp[j].Id <= hp[j + 1].Id) continue;
                    HelperObject tmp = hp[j];
                    hp[j] = hp[j + 1];
                    hp[j + 1] = tmp;
                    stop = false;
                }
            }
            this.iIAPTable.open();
            Vector apv = new Vector();
            for (i = 0; i < recNr; ++i) {
                int _ret = this.iIAPTable.findById(hp[i].Id);
                if (_ret == -3) continue;
                apv.addElement(new AccessPoint(this.iIAPTable.iRecordId, this.iIAPTable.iRecordName, this.iIAPTable.iBearerType, this.iIAPTable.iServiceType));
            }
            _ac = new AccessPoint[apv.size()];
            for (i = 0; i < apv.size(); ++i) {
                _ac[i] = (AccessPoint)apv.elementAt(i);
            }
            this.iIAPTable.close();
            _prefTable.close();
        }
        catch (CommDBException e) {
            _prefTable.close();
            this.iIAPTable.close();
            throw new IAPInfoException(e.getMessage());
        }
        return _ac;
    }

    int[] parseString(String aParameter) {
        int[] _returnArray = null;
        int _index1 = aParameter.indexOf(",");
        if (_index1 == -1) {
            return new int[0];
        }
        int _elementCounter = 0;
        int _helper = 0;
        while (_helper != -1) {
            _helper = aParameter.indexOf(",", _index1 + 1);
            if (_helper == -1) continue;
            ++_elementCounter;
            _index1 = _helper;
        }
        _returnArray = new int[_elementCounter + 1];
        _index1 = 0;
        _helper = 0;
        int i = 0;
        while (_helper != -1) {
            _helper = aParameter.indexOf(",", _index1);
            if (_helper == -1) continue;
            String _substr = aParameter.substring(_index1, _helper);
            _returnArray[i] = Integer.parseInt(_substr);
            _index1 = _helper + 1;
            ++i;
        }
        return _returnArray;
    }

    static native String[] _getDestinationNetworks() throws IAPInfoException;

    static native String _getDestinationNetworkById(int var0) throws IAPInfoException;

    static native String _getDestinationNetworkByName(String var0) throws IAPInfoException;

    static {
        try {
            Logger.LOG(14, 4, "loading javaiapinfo");
            Jvm.loadSystemLibrary("javaiapinfo");
            Logger.LOG(14, 4, "after loading javaiapinfo");
        }
        catch (Exception e) {
            Logger.LOG(14, 1, e.toString());
        }
    }

    class HelperObject {
        int Id;
        int Pref;

        HelperObject() {
        }
    }
}

