/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.bluetooth;

import com.nokia.mj.impl.bluetooth.BluetoothStackS60;
import com.nokia.mj.impl.bluetooth.utils.DebugLog;
import java.io.IOException;

public class BluetoothL2CAPSource {
    private BluetoothStackS60 iDataSource;
    private long iNativeHandle;
    private int iReadSize;
    private byte[] iReadBuffer;

    public BluetoothL2CAPSource(BluetoothStackS60 stack, long nativeHandle) {
        this.iNativeHandle = nativeHandle;
        this.iDataSource = stack;
        try {
            this.iReadSize = this.iDataSource.l2GetReceiveMTU(this.iNativeHandle);
        }
        catch (IOException ex) {
            this.iReadSize = 672;
            DebugLog.log("BluetoothL2CAPSource: Fetching receive MTU failed. Setting buffer to " + this.iReadSize);
        }
        this.iReadBuffer = new byte[this.iReadSize];
    }

    public BluetoothL2CAPSource(BluetoothStackS60 stack, long nativeHandle, int receiveMtu) {
        this.iNativeHandle = nativeHandle;
        this.iDataSource = stack;
        this.iReadSize = receiveMtu;
        this.iReadBuffer = new byte[this.iReadSize];
    }

    public int receive(long handle, byte[] inBuf) throws IOException {
        DebugLog.log("Java: BluetoothL2CAPSource: receive");
        int readBytes = this.iDataSource.clientReceive(handle, this.iReadBuffer);
        int lengthToCopy = readBytes < inBuf.length ? readBytes : inBuf.length;
        System.arraycopy((Object)this.iReadBuffer, 0, (Object)inBuf, 0, lengthToCopy);
        DebugLog.log("Java: BluetoothL2CAPSource: receive: Return " + lengthToCopy);
        return lengthToCopy;
    }
}

