/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import com.nokia.mj.impl.bluetooth.BTOBEXPermission;
import com.nokia.mj.impl.bluetooth.BTPermission;
import com.nokia.mj.impl.bluetooth.BTPlatformControl;
import com.nokia.mj.impl.bluetooth.BluetoothL2CAPSource;
import com.nokia.mj.impl.bluetooth.BluetoothPrefetchSource;
import com.nokia.mj.impl.bluetooth.BluetoothStreamer;
import com.nokia.mj.impl.bluetooth.utils.DebugLog;
import com.nokia.mj.impl.gcf.PushValidator;
import com.nokia.mj.impl.properties.bluetooth.BtDynamicPropertyHandler;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import com.nokia.mj.impl.security.common.PermissionBase;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

public class BluetoothStackS60
implements BluetoothStack,
DeviceInquiryRunnable,
SearchServicesRunnable {
    private static final int VERSION_MAJOR_1 = 2;
    private static final int VERSION_MAJOR_2 = 1;
    private static final int VERSION_MINOR = 0;
    private static final int VERSION_BUILD = 51;
    private static final int DATA_EOF = -1;
    private static final int RECEIVE_MTU_MAX = 672;
    private long iFunctionServer;
    private static final int SDP_IDLE = 0;
    private static final int SDP_DEVICE_INQUIRY = 1;
    private static final int SDP_SERVICE_SEARCH = 2;
    private static final int SDP_POPULATE_RECORD = 3;
    private int iServiceDiscoveryStatus;
    private int iDeviceDiscoveryStatus;
    private long iDiscoveryAgentHandle;
    private DiscoveryListener iDiscoveryListener;
    private DeviceInquiryThread iDeviceInquiryThread;
    private static final int UUID_SIZE_IN_BYTES = 16;
    private SearchServicesThread iServiceSearchThread;
    private Hashtable iInputStreamHash;
    private boolean iServiceClassBitsModified;

    public BluetoothStackS60() {
        DebugLog.debug("+ BluetoothStackS60: Constructor");
        this.iServiceClassBitsModified = false;
        this.iDiscoveryAgentHandle = 0L;
        this.iDeviceDiscoveryStatus = 0;
        this.iServiceDiscoveryStatus = 0;
        DebugLog.debug("- BluetoothStackS60: Constructor");
    }

    private synchronized void checkBluetoothRadio(boolean turnOnVisibility) throws BluetoothStateException {
        try {
            BTPlatformControl stateChecker = new BTPlatformControl();
            String appName = ApplicationInfo.getInstance().getName();
            boolean ready = true;
            if (!stateChecker.checkDevicePowerOn(appName, false)) {
                ready = false;
            }
            if (turnOnVisibility && !stateChecker.checkDeviceDiscoverability(appName, false)) {
                ready = false;
            }
            if (!ready) {
                throw new BluetoothStateException();
            }
        }
        catch (Exception ex) {
            throw new BluetoothStateException("Unable to switch bluetooth on");
        }
    }

    private void dispose() {
        DebugLog.debug("+ BluetoothStackS60:dispose");
        if (1 == this.iDeviceDiscoveryStatus) {
            this.cancelInquiry(this.iDiscoveryListener);
        }
        if (2 == this.iServiceDiscoveryStatus) {
            this.cancelServiceSearch(this.iServiceSearchThread.getTransID());
        } else if (3 == this.iServiceDiscoveryStatus) {
            this.cancelPopulateServicesRecordAttributeValues();
        }
        try {
            if (this.iServiceClassBitsModified) {
                this.setLocalDeviceServiceClasses(0);
            }
            this.iServiceClassBitsModified = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        DebugLog.debug("- BluetoothStackS60:dispose");
    }

    private native long _createFunctionServer();

    public boolean isNativeCodeLoaded() {
        return true;
    }

    public BluetoothStack.LibraryInformation[] requireNativeLibraries() {
        return null;
    }

    public int getLibraryVersion() throws BluetoothStateException {
        return 2010051;
    }

    public int detectBluetoothStack() {
        return 128;
    }

    public void enableNativeDebug(Class aNativeDebugCallback, boolean aOn) {
    }

    public void initialize() throws BluetoothStateException {
        this.iFunctionServer = this._createFunctionServer();
        this.iInputStreamHash = new Hashtable();
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                try {
                    BluetoothStackS60.this.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void destroy() {
    }

    public String getStackID() {
        return "S60";
    }

    public boolean isCurrentThreadInterruptedCallback() {
        return false;
    }

    public int getFeatureSet() {
        return 7;
    }

    public String getLocalDeviceBluetoothAddress() throws BluetoothStateException {
        DebugLog.debug("+ BluetoothStackS60:getLocalDeviceBluetoothAddress");
        return BTPlatformControl._getBluetoothAddress();
    }

    public String getLocalDeviceName() {
        DebugLog.debug("+ BluetoothStackS60:getLocalDeviceName");
        return BTPlatformControl._getBluetoothName();
    }

    public DeviceClass getLocalDeviceClass() {
        int result = 0;
        DebugLog.debug("+ BluetoothStackS60:getLocalDeviceClass");
        result = BTPlatformControl._getBluetoothDeviceClass();
        return new DeviceClass(result);
    }

    public void setLocalDeviceServiceClasses(int aServiceClassBits) {
        DebugLog.debug("+ BluetoothStackS60:setLocalDeviceServiceClasses " + Integer.toHexString(aServiceClassBits));
        int ret = BTPlatformControl._setServiceClasses(aServiceClassBits);
        if (0 != ret) {
            throw new RuntimeException("Unable to set device service class bits");
        }
        this.iServiceClassBitsModified = true;
        DebugLog.debug("- BluetoothStackS60:setLocalDeviceServiceClasses " + ret);
    }

    public boolean setLocalDeviceDiscoverable(int aMode) throws BluetoothStateException {
        boolean mode = false;
        DebugLog.debug("+ BluetoothStackS60:setLocalDeviceDiscoverable");
        return BTPlatformControl._setBluetoothDiscoverable(aMode);
    }

    public int getLocalDeviceDiscoverable() {
        DebugLog.debug("+ BluetoothStackS60:getLocalDeviceDiscoverable");
        return BTPlatformControl._getBluetoothDiscoverable();
    }

    public boolean isLocalDevicePowerOn() {
        DebugLog.debug("+ BluetoothStackS60:isLocalDevicePowerOn");
        return BTPlatformControl._isPowerOn();
    }

    public String getLocalDeviceProperty(String aProperty) {
        BtDynamicPropertyHandler btProperty = new BtDynamicPropertyHandler();
        DebugLog.debug("+ BluetoothStackS60:getLocalDeviceProperty");
        String propertyValue = btProperty.getProperty(aProperty);
        DebugLog.debug("- BluetoothStackS60: getLocalDeviceProperty " + aProperty + ":" + propertyValue);
        return propertyValue;
    }

    public boolean authenticateRemoteDevice(long aAddress) throws IOException {
        DebugLog.debug("+ BluetoothStackS60: authenticateRemoteDevice " + aAddress);
        return this._isAuthenticated(aAddress);
    }

    public Boolean isRemoteDeviceAuthenticated(long aAddress) {
        if (this._isAuthenticated(aAddress)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private native boolean _isAuthenticated(long var1);

    public boolean authenticateRemoteDevice(long aAddress, String aPasskey) throws IOException {
        return false;
    }

    public void removeAuthenticationWithRemoteDevice(long aAddress) throws IOException {
    }

    public Boolean isRemoteDeviceTrusted(long aAddress) {
        if (this._isTrusted(aAddress)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private native boolean _isTrusted(long var1);

    private void CreateDiscoveryAgent() {
        if (this.iDiscoveryAgentHandle == 0L) {
            this.iDiscoveryAgentHandle = this._createNativeDiscoveryAgent(this.iFunctionServer);
        }
    }

    private native long _createNativeDiscoveryAgent(long var1);

    public boolean startInquiry(int aAccessCode, DiscoveryListener aListener) throws BluetoothStateException {
        DebugLog.debug("+ BluetoothStackS60:startInquiry AccessCode:" + aAccessCode);
        if (0 != this.iDeviceDiscoveryStatus) {
            throw new BluetoothStateException("Bluetooth device is busy");
        }
        this.checkBluetoothRadio(false);
        this.iDiscoveryListener = aListener;
        this.CreateDiscoveryAgent();
        return DeviceInquiryThread.startInquiry(this, this, aAccessCode, aListener);
    }

    public boolean cancelInquiry(DiscoveryListener aListener) {
        boolean retVal = false;
        if (aListener != this.iDiscoveryListener) {
            return false;
        }
        DebugLog.debug("+ BluetoothStackS60:cancelInquiry");
        if (1 == this.iDeviceDiscoveryStatus) {
            retVal = this._cancelInquiry(this.iDiscoveryAgentHandle);
            this.iDeviceDiscoveryStatus = 0;
        }
        DebugLog.debug("- BluetoothStackS60:cancelInquiry");
        return retVal;
    }

    public String getRemoteDeviceFriendlyName(long aAddress) throws IOException {
        DebugLog.debug("+ BluetoothStackS60:getRemoteDeviceFriendlyName Device:" + aAddress);
        this.CreateDiscoveryAgent();
        return this._getRemoteDeviceFriendlyName(this.iDiscoveryAgentHandle, aAddress);
    }

    public RemoteDevice[] retrieveDevices(int aOption) {
        return null;
    }

    public int runDeviceInquiry(DeviceInquiryThread aStartedNotify, int aAccessCode, DiscoveryListener aListener) throws BluetoothStateException {
        DebugLog.debug("+ BluetootStackS60:runDeviceInquiry AccessCode:" + aAccessCode);
        this.iDeviceInquiryThread = aStartedNotify;
        this.iDeviceDiscoveryStatus = 1;
        int status = this._runDeviceInquiry(aAccessCode, this.iDiscoveryAgentHandle);
        this.iDeviceDiscoveryStatus = 0;
        DebugLog.debug("- BluetootStackS60:runDeviceInquiry status:" + status);
        return status;
    }

    public void deviceDiscoveredCallback(DiscoveryListener aListener, long aDeviceAddr, int aDeviceClass, String aDeviceName, boolean aPaired) {
    }

    public void deviceInquiryStartedCallback() {
        DebugLog.debug("+ BluetoothStackS60:deviceInquiryStartedCallback");
        RemoteDeviceHelper.clearDevicesCashed(this);
        this.iDeviceInquiryThread.deviceInquiryStartedCallback();
    }

    public void deviceDiscoveredCallBack(String aDeviceAddr, String aDeviceName, int aDeviceClass) {
        DebugLog.debug("+ BluetoothStackS60:deviceDiscoveredCallBack");
        long devAddr = Utils.hexStringToLong(aDeviceAddr);
        boolean paired = false;
        RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(this, devAddr, aDeviceName, paired);
        if (0 == this.iDeviceDiscoveryStatus || null == this.iDiscoveryListener) {
            return;
        }
        DeviceClass devClass = new DeviceClass(aDeviceClass);
        DebugLog.debug("  BluetoothStackS60:deviceDiscoveredCallback Device Name:" + aDeviceName);
        DebugLog.debug("  BluetoothStackS60:deviceDiscoveredCallback Device Addr:" + aDeviceAddr);
        DebugLog.debug("  BluetoothStackS60:deviceDiscoveredCallback deviceClass:" + devClass);
        this.iDiscoveryListener.deviceDiscovered(remoteDevice, devClass);
        DebugLog.debug("- BluetoothStackS60:deviceDiscoveredCallback");
    }

    private native int _runDeviceInquiry(int var1, long var2) throws BluetoothStateException;

    private native boolean _cancelInquiry(long var1);

    private native String _getRemoteDeviceFriendlyName(long var1, long var3);

    public int searchServices(int[] aAttrSet, UUID[] aUuidSet, RemoteDevice aDevice, DiscoveryListener aListener) throws BluetoothStateException {
        DebugLog.debug("+ BluetoothStackS60:searchServices()");
        DebugLog.debug("  searchServices(): Checking Listeners");
        if (aListener == null || aDevice == null) {
            DebugLog.debug("  searchServices(): No Listeners!!");
            throw new NullPointerException("DiscoveryListener is null");
        }
        if (0 != this.iServiceDiscoveryStatus) {
            throw new BluetoothStateException("Bluetooth device is busy");
        }
        if (aAttrSet == null) {
            aAttrSet = new int[]{0, 1, 4};
        }
        DebugLog.debug("  searchServices(): Checking UUID Set");
        int uuidLen = aUuidSet.length;
        if (uuidLen == 0) {
            DebugLog.debug("  searchServices(): UUID set length can not be zero");
            throw new IllegalArgumentException("UUID set length can not be zero");
        }
        for (int index = 0; index < uuidLen; ++index) {
            UUID uuid = aUuidSet[index];
            for (int index2 = index + 1; index2 < uuidLen; ++index2) {
                if (!uuid.equals(aUuidSet[index2])) continue;
                DebugLog.debug("  searchServices(): Duplication of one or more UUIDs!!");
                throw new IllegalArgumentException("One or more UUIDs are duplicated");
            }
        }
        this.checkBluetoothRadio(false);
        this.CreateDiscoveryAgent();
        DebugLog.debug("  searchServices(): Calling SearchServicesThread.startSearchServices");
        return SearchServicesThread.startSearchServices(this, this, aAttrSet, aUuidSet, aDevice, aListener);
    }

    public boolean cancelServiceSearch(int aTransID) {
        boolean retVal = false;
        if (2 == this.iServiceDiscoveryStatus) {
            retVal = this._cancelServiceSearch(this.iDiscoveryAgentHandle);
            this.iServiceDiscoveryStatus = 0;
        }
        return retVal;
    }

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl aServiceRecord, int[] aAttrIDs) throws IOException {
        if (0 != this.iServiceDiscoveryStatus) {
            throw new BluetoothStateException("Bluetooth device is busy");
        }
        this.CreateDiscoveryAgent();
        this.iServiceDiscoveryStatus = 3;
        long remoteDeviceAddress = RemoteDeviceHelper.getAddress(aServiceRecord.getHostDevice());
        int retVal = this._populateServiceRecordAttributeValues(remoteDeviceAddress, aServiceRecord.getHandle(), aAttrIDs, aServiceRecord, this.iDiscoveryAgentHandle);
        this.iServiceDiscoveryStatus = 0;
        return retVal != 3 && retVal != 2 && retVal != 4 && retVal != 6;
    }

    public int runSearchServices(SearchServicesThread aSst, int[] aAttrSet, UUID[] aUuidSet, RemoteDevice aRemoteDevice, DiscoveryListener aListener) throws BluetoothStateException {
        DebugLog.debug("+ BluetoothStackS60:runSearchServices()");
        int status = 0;
        this.iServiceSearchThread = aSst;
        this.iServiceDiscoveryStatus = 2;
        String remoteDevAddrStr = aRemoteDevice.getBluetoothAddress();
        long remoteDeviceAddress = Long.parseLong(remoteDevAddrStr, 16);
        byte[] uuidBytes = BluetoothStackS60.UUIDArrayToBytesArray(aUuidSet);
        status = this._runSearchServices(remoteDeviceAddress, uuidBytes, aSst.getAttrSet(), this.iDiscoveryAgentHandle);
        DebugLog.debug("  runSearchServices():After _runSearchServices: status: " + status);
        if (0 == this.iServiceDiscoveryStatus) {
            DebugLog.debug("  runSearchServices(): status = DiscoveryListener.SERVICE_SEARCH_TERMINATED");
            status = 2;
        } else if (status == 1) {
            Vector records = this.iServiceSearchThread.getServicesRecords();
            if (records.size() != 0) {
                DebugLog.debug("  runSearchServices(): status = DiscoveryListener.SERVICE_SEARCH_COMPLETED");
                DebugLog.debug("  runSearchServices(): Records Count:" + records.size());
                Object[] servRecordArray = new ServiceRecord[records.size()];
                records.copyInto(servRecordArray);
                this.iServiceSearchThread.getListener().servicesDiscovered(this.iServiceSearchThread.getTransID(), (ServiceRecord[])servRecordArray);
                status = 1;
            } else {
                DebugLog.debug("  runSearchServices(): status = DiscoveryListener.SERVICE_SEARCH_NO_RECORDS");
                status = 4;
            }
        }
        this.iServiceDiscoveryStatus = 0;
        return status;
    }

    public ServiceRecordImpl createServiceRecord(long aHandle) {
        DebugLog.debug("+ BluetoothStackS60:createServiceRecord()");
        return new ServiceRecordImpl(this, this.iServiceSearchThread.getDevice(), aHandle);
    }

    public void serviceDiscoveredCallback(ServiceRecordImpl aServiceRecord) {
        DebugLog.debug("+ BluetoothStackS60:serviceDiscoveredCallback()");
        this.iServiceSearchThread.addServicesRecords(aServiceRecord);
    }

    public void serviceSearchStartedCallback() {
        DebugLog.debug("+ BluetoothStackS60:serviceSearchStartedCallback()");
        this.iServiceSearchThread.searchServicesStartedCallback();
    }

    private void cancelPopulateServicesRecordAttributeValues() {
        if (3 == this.iServiceDiscoveryStatus) {
            this._cancelPopulateServicesRecordAttributeValues(this.iDiscoveryAgentHandle);
        }
    }

    private static byte[] UUIDArrayToBytesArray(UUID[] aUuidSet) {
        DebugLog.debug("+ BluetoothStackS60:convertUUIDArrayToBytesArray()");
        int numUUIDs = aUuidSet.length;
        int byteArrayLength = numUUIDs * 16;
        byte[] uuidBytes = new byte[byteArrayLength];
        int bytesSoFar = 0;
        for (int index = 0; index < numUUIDs; ++index) {
            UUID uuid = aUuidSet[index];
            System.arraycopy((Object)Utils.UUIDToByteArray(uuid), 0, (Object)uuidBytes, bytesSoFar, 16);
            bytesSoFar += 16;
        }
        DebugLog.debug("- convertUUIDArrayToBytesArray()::uuids:", uuidBytes);
        return uuidBytes;
    }

    private native boolean _cancelServiceSearch(long var1);

    private native int _populateServiceRecordAttributeValues(long var1, long var3, int[] var5, ServiceRecordImpl var6, long var7) throws IOException;

    private native int _runSearchServices(long var1, byte[] var3, int[] var4, long var5);

    private native void _cancelPopulateServicesRecordAttributeValues(long var1);

    public long connectionRfOpenClientConnection(BluetoothConnectionParams aParams) throws IOException {
        PermissionBase permission;
        DebugLog.debug("BluetoothStackS60: connectionRfOpenClientConnection");
        DebugLog.debug("BluetoothStackS60: connectionRfOpenClientConnection: Address: " + aParams.address);
        DebugLog.debug("BluetoothStackS60: connectionRfOpenClientConnection: Channel: " + aParams.channel);
        DebugLog.debug("BluetoothStackS60: connectionRfOpenClientConnection: Authenticate: " + aParams.authenticate);
        DebugLog.debug("BluetoothStackS60: connectionRfOpenClientConnection: Encrypt: " + aParams.encrypt);
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        if (aParams.isBtGOEP) {
            permission = new BTOBEXPermission("*", "client");
            appUtils.checkPermission(permission);
        } else {
            permission = new BTPermission("*", "client");
            appUtils.checkPermission(permission);
        }
        this.checkBluetoothRadio(false);
        long nativeHandle = this._rfClientOpen(aParams.address, aParams.channel, aParams.authenticate, aParams.encrypt, this.iFunctionServer);
        BluetoothStreamer streamer = new BluetoothStreamer(this, nativeHandle);
        InputStream stream = streamer.openInputStream();
        this.iInputStreamHash.put(new Long(nativeHandle), new BluetoothPrefetchSource(streamer, stream));
        return nativeHandle;
    }

    private native long _rfClientOpen(long var1, int var3, boolean var4, boolean var5, long var6);

    public int rfGetSecurityOpt(long aHandle, int aExpected) throws IOException {
        DebugLog.debug("BluetoothStackS60: rfGetSecurityOpt");
        return aExpected;
    }

    public void connectionRfCloseClientConnection(long aHandle) throws IOException {
        DebugLog.debug("BluetoothStackS60:connectionRfCloseClientConnection(): Closing Client");
        BluetoothPrefetchSource dataSource = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
        InputStream source = dataSource.getInputStream();
        DebugLog.debug("BluetoothStackS60: connectionRfCloseClientConnection: After closing Streamer inputstream");
        try {
            source.close();
            source = null;
        }
        catch (Exception e) {
            DebugLog.debug("BluetoothStackS60: connectionRfCloseClientConnection: Exception thrown during close");
        }
        DebugLog.debug("BluetoothStackS60: connectionRfCloseClientConnection: After closing client connection ");
        BluetoothStreamer streamer = dataSource.getStreamer();
        DebugLog.debug("BluetoothStackS60: connectionRfCloseClientConnection: Closing Streamer");
        streamer.close();
        streamer = null;
        DebugLog.debug("BluetoothStackS60: connectionRfCloseClientConnection: Close complete");
        this.iInputStreamHash.remove(new Long(aHandle));
    }

    public void connectionRfCloseServerConnection(long aHandle) throws IOException {
        DebugLog.debug("+ BluetoothStackS60: connectionRfCloseServerConnection()");
        this.clientClose(aHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rfServerOpen(BluetoothConnectionNotifierParams aParams, ServiceRecordImpl aServiceRecord) throws IOException {
        String baseUri;
        DebugLog.debug("+ BluetoothStackS60:rfServerOpen()");
        Uid suiteUid = ApplicationInfo.getInstance().getSuiteUid();
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        if (aParams.obex) {
            baseUri = "btgoep://localhost:" + aParams.uuid;
            if (PushValidator.isRegisteredPushUriStartingWith(baseUri, suiteUid, "javacaptain")) {
                throw new IOException("URI is reserved by other application");
            }
            BTOBEXPermission permission = new BTOBEXPermission("*", "server");
            appUtils.checkPermission(permission);
        } else {
            baseUri = "btspp://localhost:" + aParams.uuid;
            if (PushValidator.isRegisteredPushUriStartingWith(baseUri, suiteUid, "javacaptain")) {
                throw new IOException("URI is reserved by other application");
            }
            BTPermission permission = new BTPermission("*", "server");
            appUtils.checkPermission(permission);
        }
        this.checkBluetoothRadio(true);
        long handle = this._rfServerOpen(aParams.iUrl, aParams.authorize, aParams.authenticate, aParams.encrypt, aParams.obex);
        boolean success = false;
        try {
            int channel = this._rfGetChannel(handle);
            aServiceRecord.populateRFCOMMAttributes(0L, channel, aParams.uuid, aParams.name, aParams.obex);
            if (!this._isRfServerAlreadyRunning(handle)) {
                DebugLog.debug("  BluetoothStackS60:rfServerOpen(): Register SDP record with: ");
                DebugLog.debug("  BluetoothStackS60:rfServerOpen():     Channel: " + channel);
                DebugLog.debug("  BluetoothStackS60:rfServerOpen():     UUID: " + Utils.UUIDToByteArray(aParams.uuid));
                DebugLog.debug("  BluetoothStackS60:rfServerOpen():     Name : " + aParams.name);
                this._rfcommRegisterSDPRecord(handle, channel, Utils.UUIDToByteArray(aParams.uuid), aParams.name, aParams.obex);
            }
            this._restoreRfServiceRecord(handle, aServiceRecord);
            success = true;
            DebugLog.debug("- BluetoothStackS60:rfServerOpen()");
            long l = handle;
            return l;
        }
        finally {
            if (!success) {
                this._rfServerClose(handle);
            }
        }
    }

    private native boolean _isRfServerAlreadyRunning(long var1);

    private native void _restoreRfServiceRecord(long var1, ServiceRecordImpl var3);

    private native long _rfServerOpen(String var1, boolean var2, boolean var3, boolean var4, boolean var5) throws IOException;

    public native void _rfcommRegisterSDPRecord(long var1, int var3, byte[] var4, String var5, boolean var6) throws IOException;

    public native int _rfGetChannel(long var1);

    public native int _rfServerGetServiceRecord(long var1);

    public void rfServerUpdateServiceRecord(long aHandle, ServiceRecordImpl aServiceRecord, boolean aAcceptAndOpen) throws ServiceRegistrationException {
        if (aAcceptAndOpen) {
            int srvRecHandle = this._rfServerGetServiceRecord(aHandle);
            aServiceRecord.populateServiceRecordHandle(srvRecHandle);
        } else {
            this.sdpUpdateServiceRecord("btspp", aHandle, aServiceRecord);
        }
    }

    public long rfServerAcceptAndOpenRfServerConnection(long aHandle) throws IOException {
        DebugLog.debug("+ BluetoothStackS60: rfServerAcceptAndOpenRfServerConnection()");
        long nativeHandle = this._rfServerAcceptAndOpenServerConnection(aHandle);
        BluetoothStreamer streamer = new BluetoothStreamer(this, nativeHandle);
        InputStream stream = streamer.openInputStream();
        this.iInputStreamHash.put(new Long(nativeHandle), new BluetoothPrefetchSource(streamer, stream));
        return nativeHandle;
    }

    public native long _rfServerAcceptAndOpenServerConnection(long var1) throws IOException;

    public void rfServerClose(long aHandle, ServiceRecordImpl aServiceRecord) throws IOException {
        this._rfServerClose(aHandle);
    }

    public native int _rfServerClose(long var1) throws IOException;

    public long getConnectionRfRemoteAddress(long aHandle) throws IOException {
        return this.getRemoteAddress(aHandle);
    }

    public boolean rfEncrypt(long aAddress, long aHandle, boolean aOn) throws IOException {
        return false;
    }

    public int connectionRfReadAvailable(long aHandle) throws IOException {
        DebugLog.debug("+ BluetoothStackS60::connectionRfReadAvailable");
        BluetoothPrefetchSource dataSource = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
        InputStream source = dataSource.getInputStream();
        int ret = source.available();
        DebugLog.debug("- BluetoothStackS60:: connectionRfReadAvailable: " + ret);
        return ret;
    }

    public int connectionRfRead(long aHandle) throws IOException {
        DebugLog.debug("+ BluetoothStackS60::connectionRfRead() ");
        BluetoothPrefetchSource dataSource = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
        InputStream source = dataSource.getInputStream();
        int ret = source.read();
        DebugLog.debug("- BluetoothStackS60::connectionRfRead() ");
        return ret;
    }

    public int connectionRfRead(long aHandle, byte[] aBytes, int aOffset, int aLength) throws IOException {
        DebugLog.debug("+ BluetoothStackS60::connectionRfRead Handle:" + Long.toString(aHandle, 16) + " Offset:" + aOffset + " Length:" + aLength);
        BluetoothPrefetchSource dataSource = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
        InputStream source = dataSource.getInputStream();
        return source.read(aBytes, aOffset, aLength);
    }

    public void connectionRfWrite(long aHandle, int aByte) throws IOException {
        byte[] singleByte = new byte[]{(byte)(aByte & 0xFF)};
        this.connectionRfWrite(aHandle, singleByte, 0, 1);
    }

    public void connectionRfWrite(long aHandle, byte[] aBytes, int aOffset, int aLength) throws IOException {
        int bytesToWrite = aLength;
        byte[] toWrite = new byte[aLength];
        System.arraycopy((Object)aBytes, aOffset, (Object)toWrite, 0, aLength);
        this.clientSend(aHandle, toWrite);
    }

    public void connectionRfFlush(long aHandle) throws IOException {
    }

    public long l2OpenClientConnection(BluetoothConnectionParams aParams, int aReceiveMTU, int aTransmitMTU) throws IOException {
        DebugLog.debug("BluetoothStackS60: l2OpenClientConnection");
        DebugLog.debug("BluetoothStackS60: l2OpenClientConnection: Address: " + aParams.address);
        DebugLog.debug("BluetoothStackS60: l2OpenClientConnection: Channel: " + aParams.channel);
        DebugLog.debug("BluetoothStackS60: l2OpenClientConnection: Authenticate: " + aParams.authenticate);
        DebugLog.debug("BluetoothStackS60: l2OpenClientConnection: Encrypt: " + aParams.encrypt);
        DebugLog.debug("BluetoothStackS60: l2OpenClientConnection: RMTU: " + aReceiveMTU);
        DebugLog.debug("BluetoothStackS60: l2OpenClientConnection: TMTU: " + aTransmitMTU);
        if (aReceiveMTU > 672) {
            throw new IllegalArgumentException("Invalid ReceiveMTU value: " + aReceiveMTU);
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        BTPermission permission = new BTPermission("*", "client");
        appUtils.checkPermission(permission);
        this.checkBluetoothRadio(false);
        long nativeHandle = this._l2OpenClientConnection(aParams.address, aParams.channel, aParams.authenticate, aParams.encrypt, aReceiveMTU, aTransmitMTU, this.iFunctionServer);
        BluetoothL2CAPSource streamer = new BluetoothL2CAPSource(this, nativeHandle);
        BluetoothPrefetchSource source = new BluetoothPrefetchSource(streamer);
        this.iInputStreamHash.put(new Long(nativeHandle), source);
        return nativeHandle;
    }

    private native long _l2OpenClientConnection(long var1, int var3, boolean var4, boolean var5, int var6, int var7, long var8);

    public void l2CloseClientConnection(long aHandle) throws IOException {
        DebugLog.debug("BluetoothStackS60:l2CloseClientConnection(): Closing Client");
        DebugLog.debug("BluetoothStackS60: l2CloseClientConnection: After closing client connection ");
        this.clientClose(aHandle);
        DebugLog.debug("BluetoothStackS60: l2CloseClientConnection: Close complete");
        this.iInputStreamHash.remove(new Long(aHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long l2ServerOpen(BluetoothConnectionNotifierParams aParams, int aReceiveMTU, int aTransmitMTU, ServiceRecordImpl aServiceRecord) throws IOException {
        DebugLog.debug("+ BluetoothStackS60:l2ServerOpen()");
        if (aReceiveMTU > 672) {
            throw new IllegalArgumentException("Invalid receive MTU param value " + aReceiveMTU);
        }
        Uid suiteUid = ApplicationInfo.getInstance().getSuiteUid();
        String baseUri = "btl2cap://localhost:" + aParams.uuid;
        DebugLog.debug(baseUri);
        if (PushValidator.isRegisteredPushUriStartingWith(baseUri, suiteUid, "javacaptain")) {
            throw new IOException("URI is reserved by other application");
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        BTPermission permission = new BTPermission("*", "server");
        appUtils.checkPermission(permission);
        DebugLog.debug("  BluetoothStackS60: l2ServerOpen Checking Bluetooth state");
        this.checkBluetoothRadio(true);
        DebugLog.debug("  BluetoothStackS60: l2ServerOpen Calling _l2ServerOpen");
        long handle = this._l2ServerOpen(aParams.iUrl, aParams.authorize, aParams.authenticate, aParams.encrypt, aParams.master, aReceiveMTU, aTransmitMTU);
        boolean success = false;
        try {
            int channel = this._l2ServerGetPSM(handle);
            aServiceRecord.populateL2CAPAttributes(0, channel, aParams.uuid, aParams.name);
            if (!this._isL2ServerAlreadyRunning(handle)) {
                this._l2capRegisterSDPRecord(handle, channel, Utils.UUIDToByteArray(aParams.uuid), aParams.name);
            }
            this._restoreL2ServiceRecord(handle, aServiceRecord);
            success = true;
            DebugLog.debug("(PSM)channel:" + channel);
            DebugLog.debug("- BluetoothStackS60:l2ServerOpen() Server Handle:" + Long.toString(handle, 16));
            long l = handle;
            return l;
        }
        finally {
            if (!success) {
                this._l2ServerClose(handle);
            }
        }
    }

    private native boolean _isL2ServerAlreadyRunning(long var1);

    private native void _restoreL2ServiceRecord(long var1, ServiceRecordImpl var3);

    private native long _l2ServerOpen(String var1, boolean var2, boolean var3, boolean var4, boolean var5, int var6, int var7) throws IOException;

    public native int _l2ServerGetPSM(long var1) throws IOException;

    public native int _l2ServerGetServiceRecord(long var1);

    public native void _l2capRegisterSDPRecord(long var1, int var3, byte[] var4, String var5) throws IOException;

    public void l2ServerUpdateServiceRecord(long aHandle, ServiceRecordImpl aServiceRecord, boolean aAcceptAndOpen) throws ServiceRegistrationException {
        DebugLog.debug("+ BluetoothStackS60:l2ServerUpdateServiceRecord()");
        if (aAcceptAndOpen) {
            int srvRecHandle = this._l2ServerGetServiceRecord(aHandle);
            aServiceRecord.populateServiceRecordHandle(srvRecHandle);
        } else {
            this.sdpUpdateServiceRecord("btl2cap", aHandle, aServiceRecord);
        }
        DebugLog.debug("- BluetoothStackS60:l2ServerUpdateServiceRecord()");
    }

    public long l2ServerAcceptAndOpenServerConnection(long aHandle) throws IOException {
        int[] receiveMtu = new int[1];
        DebugLog.debug("+ BluetoothStackS60:l2ServerAcceptAndOpenServerConnection()");
        long nativeHandle = this._l2ServerAcceptAndOpenServerConnection(aHandle, receiveMtu);
        DebugLog.debug("  BluetoothStackS60:l2ServerAcceptAndOpenServerConnection() Connection Handle:" + Long.toString(nativeHandle, 16) + " Receive MTU:" + receiveMtu);
        BluetoothL2CAPSource streamer = new BluetoothL2CAPSource(this, nativeHandle, receiveMtu[0]);
        BluetoothPrefetchSource source = new BluetoothPrefetchSource(streamer);
        this.iInputStreamHash.put(new Long(nativeHandle), source);
        return nativeHandle;
    }

    public native long _l2ServerAcceptAndOpenServerConnection(long var1, int[] var3) throws IOException;

    public void l2CloseServerConnection(long aHandle) throws IOException {
        DebugLog.debug("+ BluetoothStackS60:l2CloseServerConnection Handler:" + Long.toString(aHandle, 16));
        this.clientClose(aHandle);
    }

    public void l2ServerClose(long aHandle, ServiceRecordImpl aServiceRecord) throws IOException {
        DebugLog.debug("+ BluetoothStackS60:l2ServerClose Handler:" + Long.toString(aHandle, 16));
        DebugLog.debug("+ BluetoothStackS60:l2ServerClose()");
        this._l2ServerClose(aHandle);
        DebugLog.debug("- BluetoothStackS60:l2ServerClose()");
    }

    public native int _l2ServerClose(long var1) throws IOException;

    public int l2GetSecurityOpt(long aHandle, int aExpected) throws IOException {
        DebugLog.debug("BluetoothStackS60: l2GetSecurityOpt");
        return aExpected;
    }

    public int l2GetTransmitMTU(long aHandle) throws IOException {
        DebugLog.debug("+ BluetoothStackS60: l2GetTransmitMTU");
        int result = this._l2GetTransmitMTU(aHandle);
        if (result < 0) {
            throw new IOException("Retrieving TransmitMTU failed");
        }
        DebugLog.debug("- BluetoothStackS60: l2GetTransmitMTU: " + result);
        return result;
    }

    private native int _l2GetTransmitMTU(long var1);

    public int l2GetReceiveMTU(long aHandle) throws IOException {
        DebugLog.debug("+ BluetoothStackS60: l2GetReceiveMTU");
        int result = this._l2GetReceiveMTU(aHandle);
        if (result < 0) {
            throw new IOException("Retrieving ReceiveMTU failed");
        }
        DebugLog.debug("- BluetoothStackS60: l2GetReceiveMTU: " + result);
        return result;
    }

    public native int _l2GetReceiveMTU(long var1);

    public boolean l2Ready(long aHandle) throws IOException {
        DebugLog.debug("BluetoothStackS60: l2Ready");
        if (this.available(aHandle) > 0) {
            DebugLog.debug("BluetoothStackS60: l2Ready: Return True");
            return true;
        }
        DebugLog.debug("BluetoothStackS60: l2Ready: Return False");
        return false;
    }

    public int l2Receive(long aHandle, byte[] aInBuf) throws IOException {
        BluetoothPrefetchSource source = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
        BluetoothL2CAPSource streamer = source.getL2Source();
        return streamer.receive(aHandle, aInBuf);
    }

    public void l2Send(long aHandle, byte[] aData) throws IOException {
        int tMtu = this._l2GetTransmitMTU(aHandle);
        int newBufLen = tMtu < aData.length ? tMtu : aData.length;
        byte[] toSend = new byte[newBufLen];
        System.arraycopy((Object)aData, 0, (Object)toSend, 0, newBufLen);
        this.clientSend(aHandle, toSend);
    }

    public long l2RemoteAddress(long aHandle) throws IOException {
        return this.getRemoteAddress(aHandle);
    }

    public boolean l2Encrypt(long aAddress, long aHandle, boolean aOn) throws IOException {
        DebugLog.debug("BluetoothStackS60: l2Encrypt");
        return false;
    }

    private int available(long aHandle) throws IOException {
        DebugLog.debug("BluetoothStackS60: available");
        int ret = this._available(aHandle);
        if (ret < 0) {
            throw new IOException("available() method failed: connection is closed");
        }
        DebugLog.debug("BluetoothStackS60: available: Returning: " + ret);
        return ret;
    }

    private native int _available(long var1);

    private long getRemoteAddress(long aHandle) throws IOException {
        long retVal = this._getRemoteAddress(aHandle);
        if (retVal <= 0L) {
            throw new IOException("Retrieving remote device address failed");
        }
        return retVal;
    }

    private native long _getRemoteAddress(long var1);

    int clientSend(long handle, byte[] data) throws IOException {
        DebugLog.debug("BluetoothStackS60: clientSend" + data.length + ":" + data);
        int retVal = 0;
        retVal = this._clientSend(handle, data, data.length);
        if (retVal < 0) {
            throw new IOException("Send failed. Symbian OS error: " + retVal);
        }
        return retVal;
    }

    private native int _clientSend(long var1, byte[] var3, long var4);

    private native void _registerForCallback(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int clientReceive(long aHandle, byte[] aInBuf) throws IOException {
        Object iReadLock;
        DebugLog.debug("BluetoothStackS60: clientReceive");
        int retVal = 0;
        BluetoothPrefetchSource dataSource = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
        Object object = iReadLock = dataSource.getLock();
        synchronized (object) {
            DebugLog.debug("BluetoothStackS60: clientReceive Requested Length:" + aInBuf.length);
            DebugLog.debug("BluetoothStackS60: clientReceive: Registering for callback");
            if (dataSource.isClosed()) {
                return 0;
            }
            this._registerForCallback(aHandle);
            if (this.available(aHandle) <= 0) {
                DebugLog.debug("BluetoothStackS60: clientReceive: Entering lock");
                try {
                    DebugLog.debug("BluetoothStackS60: clientReceive: Waiting for read to complete");
                    iReadLock.wait();
                }
                catch (Exception e) {}
            } else {
                DebugLog.debug("BluetoothStackS60: clientReceive Data present. GOing to read");
            }
            dataSource = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
            if (!dataSource.isClosed()) {
                DebugLog.debug("BluetoothStackS60: clientReceive: Calling native receive");
                retVal = this._clientReceive(aHandle, aInBuf);
            } else {
                DebugLog.debug("BluetoothStackS60: clientReceive: source already closed");
                retVal = 0;
            }
        }
        if (retVal < 0) {
            throw new IOException("Read failed. Symbian OS error: " + retVal);
        }
        if (retVal == 0) {
            retVal = -1;
        }
        DebugLog.debug("BluetoothStackS60: clientReceive: return: " + retVal);
        return retVal;
    }

    private native int _clientReceive(long var1, byte[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientClose(long aHandle) {
        try {
            Object iReadLock;
            BluetoothPrefetchSource dataSource = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
            Object object = iReadLock = dataSource.getLock();
            synchronized (object) {
                DebugLog.debug("BluetoothStackS60: clientClose");
                dataSource.setClosed();
                iReadLock.notify();
            }
            this._clientClose(aHandle);
            DebugLog.debug("BluetoothStackS60: clientClose: notifying read lock");
        }
        catch (Exception e) {
            DebugLog.debug("Exception in ClientClose");
        }
    }

    private native void _clientClose(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveCompleteCallback(long aHandle) {
        DebugLog.debug("BluetoothStackS60: receiveCompleteCallback");
        try {
            Object iReadLock;
            BluetoothPrefetchSource dataSource = (BluetoothPrefetchSource)this.iInputStreamHash.get(new Long(aHandle));
            Object object = iReadLock = dataSource.getLock();
            synchronized (object) {
                DebugLog.debug("BluetoothStackS60: receiveCompleteCallback. Notifying read lock");
                iReadLock.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sdpUpdateServiceRecord(String aProtocol, long aHandle, ServiceRecordImpl aServiceRecord) throws ServiceRegistrationException {
        DebugLog.debug("+ BluetoothStackS60:sdpUpdateServiceRecord");
        int[] ids = aServiceRecord.getAttributeIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        this._initializeUpdateRecord(aProtocol, aHandle, aServiceRecord.deviceServiceClasses);
        try {
            block6: for (int i = ids.length - 1; i >= 0; --i) {
                int attrID = ids[i];
                switch (attrID) {
                    case 0: 
                    case 4: {
                        continue block6;
                    }
                    default: {
                        this.sdpAddAttribute(aProtocol, aHandle, attrID, aServiceRecord.getAttributeValue(attrID));
                    }
                }
            }
        }
        finally {
            this._completesUpdateRecord(aProtocol, aHandle);
        }
        DebugLog.debug("- BluetoothStackS60:sdpUpdateServiceRecord");
    }

    private void sdpAddAttribute(String aProtocol, long aHandle, int aAttrID, DataElement aElement) throws ServiceRegistrationException {
        int type = aElement.getDataType();
        DebugLog.debug("+ BluetoothStackS60:sdpAddAttribute():" + aProtocol + ":" + type);
        switch (type) {
            case 0: {
                this._sdpAddAttribute(aProtocol, aHandle, aAttrID, type, 0L, null);
                break;
            }
            case 40: {
                this._sdpAddAttribute(aProtocol, aHandle, aAttrID, type, aElement.getBoolean() ? 1L : 0L, null);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this._sdpAddAttribute(aProtocol, aHandle, aAttrID, type, aElement.getLong(), null);
                break;
            }
            case 11: 
            case 12: 
            case 20: {
                this._sdpAddAttribute(aProtocol, aHandle, aAttrID, type, 0L, (byte[])aElement.getValue());
                break;
            }
            case 24: {
                this._sdpAddAttribute(aProtocol, aHandle, aAttrID, type, 0L, Utils.UUIDToByteArray((UUID)aElement.getValue()));
                break;
            }
            case 32: {
                byte[] bstr = ((String)aElement.getValue()).getBytes();
                this._sdpAddAttribute(aProtocol, aHandle, aAttrID, type, 0L, bstr);
                break;
            }
            case 64: {
                byte[] burl = ((String)aElement.getValue()).getBytes();
                this._sdpAddAttribute(aProtocol, aHandle, aAttrID, type, 0L, burl);
                break;
            }
            case 48: 
            case 56: {
                this._sdpAttributeListStart(aProtocol, aHandle, aAttrID, type);
                Enumeration e = (Enumeration)aElement.getValue();
                while (e.hasMoreElements()) {
                    DataElement child = (DataElement)e.nextElement();
                    this.sdpAddAttribute(aProtocol, aHandle, -1, child);
                }
                this._sdpAttributeListEnd(aProtocol, aHandle, aAttrID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data type");
            }
        }
        DebugLog.debug("- BluetoothStackS60:sdpAddAttribute()");
    }

    private native void _initializeUpdateRecord(String var1, long var2, int var4);

    private native void _completesUpdateRecord(String var1, long var2);

    private native void _sdpAddAttribute(String var1, long var2, int var4, int var5, long var6, byte[] var8) throws ServiceRegistrationException;

    private native void _sdpAttributeListStart(String var1, long var2, int var4, int var5) throws ServiceRegistrationException;

    private native void _sdpAttributeListEnd(String var1, long var2, int var4) throws ServiceRegistrationException;
}

