/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.bluetooth;

import com.nokia.mj.impl.bluetooth.BluetoothInputStream;
import com.nokia.mj.impl.bluetooth.BluetoothStackS60;
import com.nokia.mj.impl.bluetooth.utils.DebugLog;
import com.nokia.mj.impl.gcf.utils.StreamConnectionBase;
import java.io.IOException;
import java.io.InputStream;

public class BluetoothStreamer
extends StreamConnectionBase {
    private BluetoothStackS60 iDataSource;
    private long iNativeHandle;

    public BluetoothStreamer(BluetoothStackS60 aStack, long aHandle, int aBufferSize) {
        super("BluetoothL2CAP", 3, false, true, aBufferSize);
        this.iDataSource = aStack;
        this.iNativeHandle = aHandle;
    }

    public BluetoothStreamer(BluetoothStackS60 aStack, long aHandle) {
        super("BluetoothRFCOMM", 3, false);
        this.iDataSource = aStack;
        this.iNativeHandle = aHandle;
    }

    protected int createNativePeer(String aUri, int aMode, boolean aTimeouts) {
        return 0;
    }

    public int writeData(byte[] aBytes, int aOffset, int aLength) {
        return 0;
    }

    public int readData(byte[] aBytes) {
        try {
            DebugLog.debug("BluetoothStreamer: readData: Goting to recive");
            return this.iDataSource.clientReceive(this.iNativeHandle, aBytes);
        }
        catch (IOException ex) {
            DebugLog.debug("BluetoothStreamer: readData: IOException caught");
            return -1;
        }
        catch (Exception e) {
            DebugLog.debug("BluetoothStreamer: readData: Unexpected Exception caught Ignoring");
            return -1;
        }
    }

    public void stopReading() {
        this.iDataSource.clientClose(this.iNativeHandle);
    }

    public void cancelWrite() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        Object object = this.iReadOperation;
        synchronized (object) {
            Object object2 = this.iCloseOperation;
            synchronized (object2) {
                this.ensureOpen();
                if (this.iInputStream != null) {
                    throw new IOException();
                }
                this.iInputStream = new BluetoothInputStream(this, this.iCloseOperation, this.iSupportMarkAndReset);
                if (this.iDoPrefetch) {
                    this.startPrefetch();
                }
            }
        }
        return this.iInputStream;
    }
}

