/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.connectionmanager;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.storage.StorageAttribute;
import com.nokia.mj.impl.storage.StorageEntry;
import com.nokia.mj.impl.storage.StorageException;
import com.nokia.mj.impl.storage.StorageFactory;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;

public class ConnectionManager {
    private static String NOKIANETID = ";nokia_netid=";
    private static String NOKIAAPNID = ";nokia_apnid=";
    private static char NONE = (char)78;
    private static char ASKALWAYS = (char)65;
    private static char DEFAULTCONN = (char)70;
    private static char ASKONCE = (char)79;
    private static char SNAPID = (char)68;
    private static char IAPID = (char)73;
    private int iNativeHandle;
    private static ConnectionManager iCmInstance = null;
    public AccessPoint iSessionNetworkAccessPoint = null;

    public static synchronized ConnectionManager getInstance() {
        Logger.LOG(14, 4, "+ConnectionManager getInstance");
        if (iCmInstance == null) {
            Logger.LOG(14, 4, "CMImpl instance is null so creating it");
            iCmInstance = new ConnectionManager();
            ConnectionManager.iCmInstance.iSessionNetworkAccessPoint = new AccessPoint(AccessPoint.NAP_INITIAL, 0);
        }
        Logger.LOG(14, 4, "-ConnectionManager getInstance");
        return iCmInstance;
    }

    private void log(String str) {
        Logger.LOG(14, 4, "ConnectionManager- " + str);
    }

    private void logReturn(AccessPoint ap) {
        Logger.LOG(14, 4, "ConnectionManager- ap.type = " + ap.getType() + "ap.id = " + ap.getNapId());
    }

    public synchronized AccessPoint getNetworkAccessPoint(Uid aAppSuiteUid, String aUri) throws Exception {
        this.log("CMImpl +getNetworkAccessPoint");
        String apn = null;
        Object temp1 = null;
        Object temp2 = null;
        this.log("getNetworkAccessPoint trying NOKIANETID");
        AccessPoint accesspoint = this.getNetworkAccessPointFromUrl(aUri, NOKIANETID, AccessPoint.NAP_SNAP);
        if (accesspoint == null) {
            this.log("getNetworkAccessPoint trying NOKIAAPNID");
            accesspoint = this.getNetworkAccessPointFromUrl(aUri, NOKIAAPNID, AccessPoint.NAP_IAP);
        }
        if (accesspoint != null) {
            this.logReturn(accesspoint);
            return accesspoint;
        }
        this.log("getNetworkAccessPoint trying cache");
        this.logReturn(this.iSessionNetworkAccessPoint);
        int cacheType = this.iSessionNetworkAccessPoint.getType();
        if (cacheType == AccessPoint.NAP_SNAP || cacheType == AccessPoint.NAP_IAP) {
            this.logReturn(this.iSessionNetworkAccessPoint);
            return this.iSessionNetworkAccessPoint;
        }
        if (this.iSessionNetworkAccessPoint.getType() != AccessPoint.NAP_ERR) {
            this.log("getNetworkAccessPoint trying application default");
            AccessPoint appDefault = this.getApplicationDefault(aAppSuiteUid);
            this.log(" appDefault returned ");
            this.logReturn(appDefault);
            int type = appDefault.getType();
            if ((type == AccessPoint.NAP_SNAP || type == AccessPoint.NAP_IAP) && appDefault.getNapId() == 0) {
                type = AccessPoint.NAP_NONE;
                appDefault.setType(AccessPoint.NAP_NONE);
            }
            if (type == AccessPoint.NAP_SNAP || type == AccessPoint.NAP_IAP) {
                this.logReturn(appDefault);
                this.iSessionNetworkAccessPoint = appDefault;
                return appDefault;
            }
            if (type == AccessPoint.NAP_DEFAULT || type == AccessPoint.NAP_NONE) {
                this.log("getNetworkAccessPoint looking for device's default");
                apn = this._getDeviceDefaultAccessPoint();
                if (apn == null) {
                    return null;
                }
                accesspoint = this.parseNetworkAccess(apn);
                if (accesspoint != null && accesspoint.getType() != AccessPoint.NAP_ASKALWAYS) {
                    this.logReturn(accesspoint);
                    this.iSessionNetworkAccessPoint = accesspoint;
                    return accesspoint;
                }
                this.log("device default not defined");
            }
        }
        this.log("getNetworkAccessPoint calling _askNetworkAccessPoint");
        apn = this._askNetworkAccessPoint();
        if (apn == null) {
            return null;
        }
        accesspoint = this.parseNetworkAccess(apn);
        if (accesspoint == null) {
            this.logReturn(null);
            return null;
        }
        this.iSessionNetworkAccessPoint = accesspoint;
        this.logReturn(accesspoint);
        return accesspoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessPoint getApplicationDefault(Uid aAppSuiteUid) throws Exception {
        String apn = null;
        Object iap = null;
        Object snap = null;
        this.log("+getApplicationDefault()");
        StorageSession session = null;
        Object temp1 = null;
        try {
            StorageAttribute nameAttr;
            session = StorageFactory.createSession();
            session.open();
            StorageEntry readEntry = session.readEntry("APPLICATION_PACKAGE", aAppSuiteUid);
            if (readEntry != null && (nameAttr = readEntry.getAttribute("ACCESS_POINT")) != null) {
                apn = nameAttr.getValue();
            }
        }
        catch (StorageException se) {
            Logger.LOG(14, 1, "storage exception " + se);
            AccessPoint accessPoint = new AccessPoint();
            return accessPoint;
        }
        finally {
            if (session != null) {
                session.close();
                session.destroySession();
            }
        }
        this.log("app default is " + apn);
        if (apn == null || apn.length() < 2) {
            this.log("Application default is null");
            return new AccessPoint();
        }
        if (apn.equals("N")) {
            return new AccessPoint(AccessPoint.NAP_NONE, 0);
        }
        if (apn.equals("O")) {
            return new AccessPoint(AccessPoint.NAP_ONCE, 0);
        }
        if (apn.startsWith("I") || apn.startsWith("D")) {
            try {
                int id = Integer.parseInt(apn.substring(1));
                int type = apn.startsWith("I") ? AccessPoint.NAP_IAP : AccessPoint.NAP_SNAP;
                return new AccessPoint(type, id);
            }
            catch (NumberFormatException e) {
                this.log("Application default in invalid Format");
                return new AccessPoint();
            }
        }
        this.log(" Unknown app mgr settings");
        return new AccessPoint();
    }

    private AccessPoint parseNetworkAccess(String aAccess) throws Exception {
        int type;
        int id = -1;
        String idString = null;
        char ch = aAccess.charAt(0);
        if (ch == ASKALWAYS) {
            type = AccessPoint.NAP_ASKALWAYS;
        } else if (ch == SNAPID) {
            type = AccessPoint.NAP_SNAP;
        } else if (ch == IAPID) {
            type = AccessPoint.NAP_IAP;
        } else {
            throw new Exception("Illegal network access format");
        }
        if (type == AccessPoint.NAP_ASKALWAYS) {
            if (aAccess.length() > 1) {
                throw new Exception("Illegal network access format");
            }
        } else {
            if (aAccess.length() <= 1) {
                throw new Exception("Illegal network access format");
            }
            idString = aAccess.substring(1);
            if (idString != null) {
                try {
                    id = Integer.parseInt(idString);
                }
                catch (NumberFormatException e) {
                    throw new Exception("Illegal network access format");
                }
            }
        }
        return new AccessPoint(type, id);
    }

    public AccessPoint getNetworkAccessPointFromUrl(String aUri, String aParam, int aType) throws Exception {
        String NapString;
        int index = aUri.indexOf(aParam);
        if (index != -1 && (NapString = aUri.substring(index + aParam.length())) != null) {
            try {
                int id = Integer.parseInt(NapString);
                return new AccessPoint(aType, id);
            }
            catch (NumberFormatException e) {
                this.log("url does not have valid IAP/SNAP id");
            }
        }
        return null;
    }

    public synchronized void reset() {
        this.log("reset()");
        this.iSessionNetworkAccessPoint = new AccessPoint(AccessPoint.NAP_ERR, 0);
    }

    private native String _getDeviceDefaultAccessPoint();

    private native String _askNetworkAccessPoint();

    static {
        try {
            Logger.LOG(14, 4, "loading connectionmanager");
            Jvm.loadSystemLibrary("javaconnectionmanager");
            Logger.LOG(14, 4, "after loading connectionmanager");
        }
        catch (Exception e) {
            Logger.LOG(14, 1, e.toString());
        }
    }
}

