/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.datagram;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.datagram.DatagramImpl;
import com.nokia.mj.impl.gcf.protocol.datagram.DatagramPermissionImpl;
import com.nokia.mj.impl.gcf.utils.UrlParser;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.Datagram;
import javax.microedition.io.UDPDatagramConnection;

public class UDPDatagramConnectionImpl
implements UDPDatagramConnection {
    private int iNativePeerHandle;
    private UrlParser iUri;
    private boolean iConnectionOpen = true;
    private Finalizer iFinalizer;
    private static final String DATAGRAM_PROTOCOL = "datagram";
    private static final int MAX_DATAGRAM_SIZE = 65535;
    private static final int NOMINAL_DATAGRAM_SIZE = 256;
    private ConnectionManager iCmInstance = null;
    private AccessPoint iApn = null;
    private String iFullUrl = null;

    public UDPDatagramConnectionImpl(String aUri, int aMode, boolean aTimeout) throws IOException {
        String temp;
        int equalindex;
        Logger.LOG(14, 4, " +UDPDatagramConnectionImpl(): aUri = " + aUri);
        int retVal = 0;
        int[] retval = new int[1];
        String apnstring = null;
        String urls = null;
        int apnid = -1;
        int index = -1;
        this.iFullUrl = "datagram:" + aUri;
        index = aUri.indexOf(";nokia_netid=");
        if (index != -1) {
            apnstring = aUri.substring(index);
            equalindex = apnstring.indexOf(61);
            if (equalindex != -1) {
                temp = apnstring.substring(equalindex + 1);
                try {
                    apnid = Integer.parseInt(temp);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid URL: " + this.iFullUrl);
                }
            } else {
                throw new IllegalArgumentException("Invalid URL: " + this.iFullUrl);
            }
            urls = aUri.substring(0, index);
        } else {
            index = aUri.indexOf(";nokia_apnid=");
            if (index != -1) {
                apnstring = aUri.substring(index);
                equalindex = apnstring.indexOf(61);
                if (equalindex != -1) {
                    temp = apnstring.substring(equalindex + 1);
                    try {
                        apnid = Integer.parseInt(temp);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid URL: " + this.iFullUrl);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid URL: " + this.iFullUrl);
                }
                urls = aUri.substring(0, index);
            } else {
                urls = aUri;
            }
        }
        Logger.LOG(14, 4, "UDPDatagramConnectionImpl -after removing nokia_apnid : " + urls);
        if (urls.equals("//:")) {
            String temp2 = "datagram:" + urls;
            ApplicationUtils appUtils = ApplicationUtils.getInstance();
            DatagramPermissionImpl per = new DatagramPermissionImpl("datagram://");
            Logger.LOG(14, 4, "calling check permissions from UDPDatagramConnectionImpl");
            appUtils.checkPermission(per);
            this.iNativePeerHandle = this._createNativePeer(temp2, aMode, "", 0);
        } else {
            DatagramPermissionImpl per;
            ApplicationUtils appUtils;
            this.iUri = new UrlParser(DATAGRAM_PROTOCOL, urls);
            if (this.iUri.port == -1) {
                throw new IllegalArgumentException("Invalid URL: " + this.iFullUrl);
            }
            Logger.LOG(14, 4, "port = " + this.iUri.port);
            if ((this.iUri.getPort() == 9200 || this.iUri.getPort() == 9201 || this.iUri.getPort() == 9202 || this.iUri.getPort() == 9203) && ApplicationInfo.getInstance().getRuntimeType().equals("MIDP") && ApplicationInfo.getInstance().getProtectionDomain().equals("UTPD")) {
                Logger.LOG(14, 4, "Throwing security exception for restricted port");
                throw new SecurityException("Unable to open datagram connection: port " + this.iUri.getPort() + " is restricted");
            }
            if (this.iUri.host == null) {
                appUtils = ApplicationUtils.getInstance();
                per = new DatagramPermissionImpl("datagram://");
                Logger.LOG(14, 4, "calling check permissions from UDPDatagramConnectionImpl");
                appUtils.checkPermission(per);
                this.iNativePeerHandle = this._createNativePeer(this.iUri.toString(), aMode, "", this.iUri.port);
            } else {
                appUtils = ApplicationUtils.getInstance();
                per = new DatagramPermissionImpl("datagram://*");
                Logger.LOG(14, 4, "calling check permissions from UDPDatagramConnectionImpl");
                appUtils.checkPermission(per);
                this.iNativePeerHandle = this._createNativePeer(this.iUri.toString(), aMode, this.iUri.host, this.iUri.port);
            }
        }
        if (this.iNativePeerHandle == 0) {
            throw new IOException("Unable to open datagram connection.Creating native peer failed");
        }
        this.iCmInstance = ConnectionManager.getInstance();
        Logger.LOG(14, 4, "after getting ConnectionManager instance");
        try {
            Uid appSuite = ApplicationInfo.getInstance().getSuiteUid();
            try {
                this.iApn = this.iCmInstance.getNetworkAccessPoint(appSuite, aUri);
                Logger.LOG(14, 4, "iApn.getType = " + this.iApn.getType() + " iApn.getNapId= " + this.iApn.getNapId());
            }
            catch (Exception e) {
                Logger.LOG(14, 4, "getNetworkAccessPoint threw Exception");
            }
        }
        catch (Exception e) {
            Logger.LOG(14, 4, "getSuiteUid exception ");
        }
        retVal = this.iApn != null ? this._openConnection(this.iNativePeerHandle, this.iApn.getType(), this.iApn.getNapId(), retval) : this._openConnection(this.iNativePeerHandle, -1, -1, retval);
        Logger.LOG(14, 4, "UDPDatagramConnectionImpl::UDPDatagramConnectionImpl(): _openConnection return value " + retVal);
        if (this.iCmInstance != null && retval[0] < 0) {
            this.iCmInstance.reset();
        }
        if (retVal < 0) {
            throw new IOException("Unable to open datagram connection. POSIX error code: " + retVal);
        }
        this.iFinalizer = this.registerforFinalization();
        this.setShutdownListener();
        Logger.LOG(14, 4, " --UDPDatagramConnectionImpl()");
    }

    private void setShutdownListener() {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                try {
                    UDPDatagramConnectionImpl.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (UDPDatagramConnectionImpl.this.iNativePeerHandle != 0) {
                    UDPDatagramConnectionImpl.this._dispose(UDPDatagramConnectionImpl.this.iNativePeerHandle);
                    UDPDatagramConnectionImpl.this.iNativePeerHandle = 0;
                }
            }
        });
    }

    public String getLocalAddress() throws IOException {
        String[] address = new String[1];
        if (!this.iConnectionOpen) {
            throw new IOException("getLocalAddress failed: connection is already closed");
        }
        int retVal = this._getLocalAddress(this.iNativePeerHandle, address);
        if (retVal < 0) {
            throw new IOException("getLocalAddress method failed.Posix error code: " + retVal);
        }
        return address[0];
    }

    public int getLocalPort() throws IOException {
        if (!this.iConnectionOpen) {
            throw new IOException("getLocalPort failed: connection is already closed");
        }
        int retVal = this._getLocalPort(this.iNativePeerHandle);
        if (retVal < 0) {
            throw new IOException("getLocalPort method failed.Posix error code: " + retVal);
        }
        return retVal;
    }

    public synchronized void close() throws IOException {
        Logger.LOG(14, 4, "+UDPDatagramConnectionImpl::Close()");
        if (this.iConnectionOpen) {
            this.iConnectionOpen = false;
            int ret = this._close(this.iNativePeerHandle);
            if (ret != 0) {
                if (ret == -4) {
                    throw new InterruptedIOException();
                }
                throw new IOException("close method failed.Posix error code: " + ret);
            }
        }
        Logger.LOG(14, 4, "-UDPDatagramConnectionImpl::Close()");
    }

    public int getMaximumLength() throws IOException {
        if (!this.iConnectionOpen) {
            throw new IOException("getMaximumLength failed: connection is already closed");
        }
        return 65535;
    }

    public int getNominalLength() throws IOException {
        if (!this.iConnectionOpen) {
            throw new IOException("getNominalLength failed: connection is already closed");
        }
        return 256;
    }

    public void send(Datagram aDgram) throws IOException {
        UrlParser url1;
        if (!this.iConnectionOpen) {
            throw new IOException("send failed: connection is already closed");
        }
        String addr = aDgram.getAddress();
        if (addr == null) {
            url1 = this.iUri;
        } else {
            url1 = new UrlParser(addr);
            if ((url1.getPort() == 9200 || url1.getPort() == 9201 || url1.getPort() == 9202 || url1.getPort() == 9203) && ApplicationInfo.getInstance().getProtectionDomain().equals("UTPD")) {
                Logger.LOG(14, 4, "Throwing secuirty exception for restricted port");
                throw new SecurityException("Unable to open datagram connection: port " + url1.getPort() + " is restricted");
            }
        }
        int retVal = this._send(this.iNativePeerHandle, aDgram.getData(), aDgram.getOffset(), aDgram.getLength(), url1.host, url1.port);
        if (retVal < 0) {
            throw new IOException("send method failed.Posix error code: " + retVal);
        }
    }

    public void receive(Datagram aDgram) throws IOException {
        String addr = new String("  ");
        String[] senderAddr = new String[1];
        int[] senderPort = new int[1];
        boolean port = false;
        if (!this.iConnectionOpen) {
            throw new IOException("receive failed: connection is already closed");
        }
        int retVal = this._receive(this.iNativePeerHandle, aDgram.getData(), aDgram.getOffset(), aDgram.getLength(), senderAddr, senderPort);
        Logger.LOG(14, 4, "UDPDatagramConnectionImpl.java recieve returned : " + retVal);
        if (retVal < 0) {
            throw new IOException("receive method failed.Posix error code: " + retVal);
        }
        Logger.LOG(14, 4, "addr = " + senderAddr[0] + "port = " + senderPort[0] + "recieve retval = " + retVal);
        StringBuffer recvurl = new StringBuffer();
        recvurl.append("datagram://");
        recvurl.append(senderAddr[0]);
        recvurl.append(":");
        recvurl.append(senderPort[0]);
        Logger.LOG(14, 4, "recvurl = " + recvurl);
        aDgram.setAddress(recvurl.toString());
        aDgram.setLength(retVal);
    }

    public Datagram newDatagram(int aSize) throws IOException {
        return this.newDatagram(aSize, null);
    }

    public Datagram newDatagram(int aSize, String aAddr) throws IOException {
        if (aSize < 0) {
            throw new IllegalArgumentException("Invalid argument in newDatagram method");
        }
        byte[] buf = new byte[aSize];
        return this.newDatagram(buf, aSize, aAddr);
    }

    public Datagram newDatagram(byte[] aBuf, int aSize) throws IOException {
        return this.newDatagram(aBuf, aSize, null);
    }

    public Datagram newDatagram(byte[] aBuf, int aSize, String aAddr) throws IOException {
        if (!this.iConnectionOpen) {
            throw new IOException("newDatagram failed: connection is already closed");
        }
        if (aBuf == null) {
            throw new IllegalArgumentException("Invalid argument in newDatagram method");
        }
        if (aAddr != null) {
            UrlParser urlvalidation = new UrlParser(aAddr);
        }
        DatagramImpl t = new DatagramImpl(aBuf, aSize, aAddr);
        return t;
    }

    Finalizer registerforFinalization() {
        Logger.LOG(14, 4, "creating a datagram finalizer object ");
        return new Finalizer(){

            public void finalizeImpl() {
                UDPDatagramConnectionImpl.this.doFinalize();
            }
        };
    }

    public void doFinalize() {
        Logger.LOG(14, 4, "datagram doFinalize() called :");
        if (this.iConnectionOpen) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.iNativePeerHandle != 0) {
            this._dispose(this.iNativePeerHandle);
            this.iNativePeerHandle = 0;
        }
    }

    private native int _createNativePeer(String var1, int var2, String var3, int var4);

    private native int _openConnection(int var1, int var2, int var3, int[] var4);

    private native int _send(int var1, byte[] var2, int var3, int var4, String var5, int var6);

    private native int _receive(int var1, byte[] var2, int var3, int var4, String[] var5, int[] var6);

    private native int _getLocalAddress(int var1, String[] var2);

    private native int _getLocalPort(int var1);

    private native int _close(int var1);

    private native void _dispose(int var1);
}

