/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.comms.CommsEndpoint;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.comms.exception.CommsException;
import com.nokia.mj.impl.fileutils.DriveInfo;
import com.nokia.mj.impl.utils.Logger;

class DriveObserverMessages {
    static final int DRIVEOBSERVER_MSG_SUBSCRIBE_EVENTS = 1;
    static final int DRIVEOBSERVER_MSG_UNSUBSCRIBE_EVENTS = 2;
    static final int DRIVEOBSERVER_MSG_DRIVE_CHANGED_EVENT = 3;
    static final int DRIVEOBSERVER_MSG_GETDRIVES_REQUEST = 4;
    static final int DRIVEOBSERVER_MSG_GETDRIVES_RESULT = 5;
    static final int DRIVEOBSERER_GET_DRIVES_ALL = 1;
    static final int DRIVEOBSERER_GET_DRIVES_ACCESIBLE = 2;
    static final int PLUGIN_ID_DRIVE_OBSERVER_NATIVE_C = 50;
    static final int PLUGIN_ID_DRIVE_OBSERVER_JAVA_C = 51;

    DriveObserverMessages() {
    }

    static final DriveInfo[] getDrives(boolean allDrives) {
        DriveInfo[] drives = null;
        try {
            boolean commsOwner = false;
            CommsEndpoint comms = CommsEndpoint.find("javacaptain");
            if (comms == null) {
                comms = new CommsEndpoint();
                comms.connect(10000);
                commsOwner = true;
            }
            CommsMessage msg = new CommsMessage();
            msg.setMessageId(4);
            msg.setModuleId(50);
            if (allDrives) {
                msg.write(1);
            } else {
                msg.write(2);
            }
            CommsMessage replyMsg = comms.sendReceive(msg, 5);
            if (commsOwner) {
                comms.destroy();
            }
            int numOfDrives = 0;
            numOfDrives = replyMsg.readInt();
            Logger.LOG(13, 4, "extracting " + numOfDrives + " driveInfos");
            if (numOfDrives > 0) {
                drives = new DriveInfo[numOfDrives];
                for (int i = 0; i < numOfDrives; ++i) {
                    drives[i] = DriveObserverMessages.extractDriveInfo(replyMsg);
                }
            }
        }
        catch (CommsException e) {
            Logger.ELOG(13, "getDrives failed", e);
        }
        return drives;
    }

    static DriveInfo extractDriveInfo(CommsMessage aMessage) {
        DriveInfo drive = new DriveInfo();
        try {
            Logger.LOG(13, 4, "extracting drive");
            drive.iRootPath = aMessage.readString();
            Logger.LOG(13, 4, "drives[].iRootPath=" + drive.iRootPath);
            drive.iIsPresent = aMessage.readInt() != 0;
            Logger.LOG(13, 4, "drives[].iIsPresent=" + drive.iIsPresent);
            drive.iIsRemovable = aMessage.readInt() != 0;
            Logger.LOG(13, 4, "drives[].iIsRemovable=" + drive.iIsRemovable);
            drive.iIsLocal = aMessage.readInt() != 0;
            Logger.LOG(13, 4, "drives[].iIsLocal=" + drive.iIsLocal);
            drive.iIsReadOnly = aMessage.readInt() != 0;
            Logger.LOG(13, 4, "drives[].iIsReadOnly=" + drive.iIsReadOnly);
            drive.iId = aMessage.readInt();
            Logger.LOG(13, 4, "drives[].iId=" + drive.iId);
        }
        catch (Exception e) {
            Logger.LOG(13, 4, "Exception in extraction", e);
        }
        return drive;
    }

    static void subscribeEvents(CommsEndpoint aComms, boolean aUnsubscribe) {
        CommsMessage msg = new CommsMessage();
        if (aUnsubscribe) {
            msg.setMessageId(2);
        } else {
            msg.setMessageId(1);
        }
        msg.setModuleId(50);
        msg.write(51);
        aComms.send(msg);
    }
}

