/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.fileutils.FileUtility;
import java.io.IOException;

final class FilePlatformSpecifics {
    FilePlatformSpecifics() {
    }

    public static String resolveDrive(String aPath) {
        String path = aPath;
        String separator = System.getProperty("file.separator");
        if (!(path = path.replace('/', '\\')).startsWith(separator)) {
            return null;
        }
        FileUtility resolved = new FileUtility("C:" + path);
        if (resolved.exists()) {
            return "C:" + path;
        }
        resolved = new FileUtility("Z:" + path);
        if (resolved.exists()) {
            return "Z:" + path;
        }
        return null;
    }

    public static boolean copy(String aSourceFile, String aDestFile, boolean aOverwrite) {
        FileUtility source = new FileUtility(aSourceFile);
        if (!source.isFile()) {
            throw new IllegalArgumentException("Source not a file");
        }
        if (aDestFile.endsWith("/") || aDestFile.endsWith("\\")) {
            throw new IllegalArgumentException("Invalid destination path");
        }
        try {
            return FilePlatformSpecifics._copy(aSourceFile, aDestFile, aOverwrite);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static native boolean _copy(String var0, String var1, boolean var2) throws IOException;

    public static boolean move(String aSourceFile, String aDestFile, boolean aOverwrite) {
        try {
            return FilePlatformSpecifics._move(aSourceFile, aDestFile, aOverwrite);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static native boolean _move(String var0, String var1, boolean var2) throws IOException;

    public static boolean copyAll(String aSourceFile, String aDestFile, boolean aOverwrite) {
        String sourceFile = aSourceFile;
        String destFile = aDestFile;
        FileUtility source = new FileUtility(sourceFile);
        FileUtility destination = new FileUtility(destFile);
        if (source.isDirectory()) {
            if (sourceFile.indexOf("\\") != -1) {
                if (!sourceFile.endsWith("\\")) {
                    sourceFile = sourceFile + "\\";
                }
            } else if (!sourceFile.endsWith("/")) {
                sourceFile = sourceFile + "/";
            }
        } else {
            throw new IllegalArgumentException("Source is not Directory");
        }
        if (destination.exists()) {
            if (!destination.isDirectory()) {
                throw new IllegalArgumentException("Destination is not Directory");
            }
        } else {
            try {
                destination.mkdir();
            }
            catch (Exception e) {
                return false;
            }
        }
        if (destFile.indexOf("\\") != -1) {
            if (!destFile.endsWith("\\")) {
                destFile = destFile + "\\";
            }
        } else if (!destFile.endsWith("/")) {
            destFile = destFile + "/";
        }
        try {
            return FilePlatformSpecifics._copyAll(sourceFile, destFile, aOverwrite);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static native boolean _copyAll(String var0, String var1, boolean var2) throws IOException;

    public static boolean deleteAll(String aTargetFile) {
        String target = aTargetFile;
        if (!aTargetFile.endsWith("/") && !aTargetFile.endsWith("\\")) {
            target = target.indexOf(92) != -1 ? aTargetFile + "\\" : aTargetFile + "/";
        }
        try {
            return FilePlatformSpecifics._deleteAll(target);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static native boolean _deleteAll(String var0) throws IOException;

    public static void setHidden(FileUtility aCaller, boolean aHidden) throws IOException {
        FilePlatformSpecifics._setHidden(aCaller.getAbsolutePath(), aHidden);
    }

    private static native void _setHidden(String var0, boolean var1) throws IOException;

    public static String getContentId(String aFilePath) {
        return FilePlatformSpecifics._getContentId(aFilePath);
    }

    private static native String _getContentId(String var0);
}

